/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema;

import commvault.cte.common.schema.SchemaAnnotation;
import commvault.cte.common.schema.SchemaDocument;
import commvault.cte.common.schema.SchemaType;
import java.io.Serializable;
import java.util.List;
import javax.xml.namespace.QName;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class SchemaProperty
implements Serializable {
    protected SchemaDocument schemaDocument;
    protected Element element;
    protected SchemaType type;
    protected SchemaAnnotation annotation;

    protected SchemaProperty(Element element, SchemaDocument schemaDocument) {
        this.element = element;
        this.schemaDocument = schemaDocument;
    }

    protected void parse() throws Exception {
        if (this.element.getAttribute("type") != null) {
            QName qName = this.schemaDocument.buildName(this.element.getAttributeValue("type"), this.element.getAdditionalNamespaces());
            this.type = this.schemaDocument.getSchemaTypeSystem().lookupType(qName);
            if (this.type == null) {
                System.err.println("could not find type for [" + qName + "] in namespace [" + this.schemaDocument.getTargetNamespace() + "]");
            }
        }
        this.parse(this.element.getChildren());
    }

    public SchemaAnnotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new SchemaAnnotation(this.element.getNamespace());
            this.element.addContent((Content)this.annotation.getElement());
        }
        return this.annotation;
    }

    public String toString() {
        return String.valueOf(this.getName());
    }

    public Element getElement() {
        return this.element;
    }

    public QName getName() {
        return new QName(this.schemaDocument.getTargetNamespace(), this.element.getAttributeValue("name"));
    }

    public SchemaType getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.element.getAttributeValue("default");
    }

    public void setDefaultValue(String string) {
        this.element.setAttribute("default", string);
    }

    public boolean isRequried() {
        return this.getMinOccurs() > 0;
    }

    public boolean isList() {
        return this.getMaxOccurs() > 1;
    }

    public SchemaDocument getSchemaDocument() {
        return this.schemaDocument;
    }

    protected QName getTypeName() throws Exception {
        if (this.type.getName() != null) {
            QName qName = this.type.getName();
            return new QName(qName.getLocalPart(), qName.getNamespaceURI(), this.schemaDocument.lookupPrefix(qName.getNamespaceURI()));
        }
        return null;
    }

    protected abstract void parse(List<Element> var1) throws Exception;

    public abstract int getMinOccurs();

    public abstract int getMaxOccurs();

    public abstract boolean isAttribute();

    public abstract boolean isGlobal();

    public abstract void setRequired(boolean var1);

    public abstract void setList(boolean var1);

    public abstract void setType(SchemaType var1) throws Exception;
}

