/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema;

import commvault.cte.common.schema.ComplexType;
import commvault.cte.common.schema.GenericType;
import commvault.cte.common.schema.GenericTypes;
import commvault.cte.common.schema.SchemaAttribute;
import commvault.cte.common.schema.SchemaElement;
import commvault.cte.common.schema.SchemaException;
import commvault.cte.common.schema.SchemaImport;
import commvault.cte.common.schema.SchemaProperty;
import commvault.cte.common.schema.SchemaType;
import commvault.cte.common.schema.SchemaTypeSystem;
import commvault.cte.common.schema.SimpleType;
import commvault.cte.common.schema.util.SchemaUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SchemaDocument
implements Serializable {
    private static final String AUTO_PREFIX = "ns";
    protected SchemaTypeSystem sts = null;
    private Element schema;
    private String fileName;
    private boolean replace = false;
    protected boolean parsed = false;
    protected Map<String, SchemaImport> imports = new HashMap<String, SchemaImport>();
    protected Map<String, SchemaType> types = new HashMap<String, SchemaType>();
    protected Map<String, SchemaElement> elements = new HashMap<String, SchemaElement>();
    protected Map<String, SchemaAttribute> attributes = new HashMap<String, SchemaAttribute>();

    protected SchemaDocument(String string, String string2, SchemaTypeSystem schemaTypeSystem) {
        this.sts = schemaTypeSystem;
        this.fileName = string2;
        Namespace namespace = Namespace.getNamespace((String)"xs", (String)"http://www.w3.org/2001/XMLSchema");
        this.schema = new Element("schema", namespace);
        this.schema.addNamespaceDeclaration(Namespace.getNamespace((String)"tns", (String)string));
        this.schema.setAttribute("targetNamespace", string);
    }

    protected SchemaDocument(Element element, SchemaTypeSystem schemaTypeSystem) throws Exception {
        if (!element.getName().equals("schema")) {
            throw new SchemaException("invalid schema document [" + element.getName() + "]");
        }
        this.schema = element;
        this.sts = schemaTypeSystem;
        this.set(element);
    }

    protected void merge(SchemaDocument schemaDocument) throws Exception {
        Element element = schemaDocument.getSchema().clone();
        this.localizeElement(element);
        this.importNamespaces(element);
        this.set(element);
    }

    private void importNamespaces(Element element) throws Exception {
        for (Namespace namespace : element.getAdditionalNamespaces()) {
            boolean bl = false;
            for (Namespace namespace2 : this.schema.getAdditionalNamespaces()) {
                if (!namespace.getPrefix().equals(namespace2.getPrefix())) continue;
                if (namespace.getURI().equals(namespace2.getURI())) {
                    bl = true;
                    continue;
                }
                throw new SchemaException("cannot import namespace prefix [" + namespace.getPrefix() + "], it is already assigned to [" + namespace2.getURI() + "]");
            }
            if (bl) continue;
            this.schema.addNamespaceDeclaration(namespace);
        }
    }

    private void localizeElement(Element element) {
        element.setNamespace(this.getNamespace());
        for (Element element2 : element.getChildren()) {
            this.localizeElement(element2);
        }
    }

    private void set(Element element) throws Exception {
        if (!this.schema.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            throw new SchemaException("xsd file for target namspace [" + this.getTargetNamespace() + "] is not a valid [" + "http://www.w3.org/2001/XMLSchema" + "] document");
        }
        for (Element element2 : element.getChildren()) {
            Serializable serializable;
            if (element2.getName().equals("complexType")) {
                if (element2.getParent().equals(this.schema)) {
                    serializable = new ComplexType(element2, this);
                } else {
                    serializable = new ComplexType(element2.clone(), this);
                    if (this.types.containsKey(((ComplexType)serializable).getName().getLocalPart())) {
                        this.remove(this.types.get(((ComplexType)serializable).getName().getLocalPart()));
                    }
                    this.schema.addContent((Content)((ComplexType)serializable).element);
                }
                if (((ComplexType)serializable).getName() == null) {
                    throw new SchemaException("cannot add a non-named type to schema document [" + ((ComplexType)serializable).toString() + "]");
                }
                this.types.put(((ComplexType)serializable).getName().getLocalPart(), (SchemaType)serializable);
                continue;
            }
            if (element2.getName().equals("simpleType")) {
                if (element2.getParent().equals(this.schema)) {
                    serializable = new SimpleType(element2, this);
                } else {
                    serializable = new SimpleType(element2.clone(), this);
                    if (this.types.containsKey(((SimpleType)serializable).getName().getLocalPart())) {
                        this.remove(this.types.get(((SimpleType)serializable).getName().getLocalPart()));
                    }
                    this.schema.addContent((Content)((SimpleType)serializable).element);
                }
                if (((SimpleType)serializable).getName() == null) {
                    throw new SchemaException("cannot add a non-named type to schema document [" + ((SchemaType)serializable).toString() + "]");
                }
                this.types.put(((SimpleType)serializable).getName().getLocalPart(), (SchemaType)serializable);
                continue;
            }
            if (element2.getName().equals("element")) {
                if (element2.getParent().equals(this.schema)) {
                    serializable = new SchemaElement(element2, this);
                } else {
                    serializable = new SchemaElement(element2.clone(), this);
                    if (this.elements.containsKey(((SchemaProperty)serializable).getName().getLocalPart())) {
                        this.remove(this.elements.get(((SchemaProperty)serializable).getName().getLocalPart()));
                    }
                    this.schema.addContent((Content)((SchemaElement)serializable).element);
                }
                if (((SchemaProperty)serializable).getName() == null) {
                    throw new SchemaException("cannot add a non-named element to schema document [" + ((SchemaElement)serializable).toString() + "]");
                }
                this.elements.put(((SchemaProperty)serializable).getName().getLocalPart(), (SchemaElement)serializable);
                continue;
            }
            if (element2.getName().equals("attribute")) {
                if (element2.getParent().equals(this.schema)) {
                    serializable = new SchemaAttribute(element2, this);
                } else {
                    serializable = new SchemaAttribute(element2.clone(), this);
                    if (this.attributes.containsKey(((SchemaProperty)serializable).getName().getLocalPart())) {
                        this.remove(this.attributes.get(((SchemaProperty)serializable).getName().getLocalPart()));
                    }
                    this.schema.addContent((Content)((SchemaAttribute)serializable).element);
                }
                if (((SchemaProperty)serializable).getName() == null) {
                    throw new SchemaException("cannot add a non-named attribute to schema document [" + ((SchemaProperty)serializable).toString() + "]");
                }
                this.attributes.put(((SchemaProperty)serializable).getName().getLocalPart(), (SchemaAttribute)serializable);
                continue;
            }
            if (element2.getName().equals("import")) {
                serializable = new SchemaImport(element2);
                if (this.imports.containsKey(((SchemaImport)serializable).getNamespace())) continue;
                if (!((SchemaImport)serializable).element.getParent().equals(this.schema)) {
                    this.schema.addContent(0, (Content)((SchemaImport)serializable).element.clone());
                }
                this.imports.put(((SchemaImport)serializable).getNamespace(), (SchemaImport)serializable);
                continue;
            }
            throw new SchemaException("unhandled top level schema element [" + element2.getName() + "] in namespace [" + this.getTargetNamespace() + "]");
        }
    }

    protected void parse() throws Exception {
        if (!this.parsed) {
            for (SchemaElement serializable : this.elements.values()) {
                serializable.parse();
            }
            for (SchemaAttribute schemaAttribute : this.attributes.values()) {
                schemaAttribute.parse();
            }
            for (SchemaType schemaType : this.types.values()) {
                schemaType.parse();
            }
        }
        this.parsed = true;
    }

    public String getTargetNamespace() {
        return this.schema.getAttributeValue("targetNamespace");
    }

    public String toString() {
        return "schema for [" + this.getTargetNamespace() + "]";
    }

    protected QName buildName(String string, List<Namespace> list) throws Exception {
        int n = string.indexOf(58);
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = this.getNamespaceByPrefix(string2);
            if (string3 == null) {
                for (Namespace namespace : list) {
                    if (!string2.equals(namespace.getPrefix())) continue;
                    string3 = namespace.getURI();
                    break;
                }
            }
            return new QName(string3, string.substring(n + 1));
        }
        throw new SchemaException("missing namespace prefix for name [" + string + "] in namespace [" + this.getTargetNamespace() + "]");
    }

    protected String getReferenceName(QName qName) throws Exception {
        return this.lookupPrefix(qName.getNamespaceURI()) + ":" + qName.getLocalPart();
    }

    public SchemaTypeSystem getSchemaTypeSystem() {
        return this.sts;
    }

    public List<Namespace> getNamespaces() {
        return this.schema.getAdditionalNamespaces();
    }

    public SchemaImport[] getImports() {
        return this.imports.values().toArray(new SchemaImport[0]);
    }

    public SchemaDocument[] getDocumentImports() {
        ArrayList<SchemaDocument> arrayList = new ArrayList<SchemaDocument>();
        for (SchemaImport schemaImport : this.getImports()) {
            arrayList.add(this.sts.getNamespace(schemaImport.getNamespace()));
        }
        return arrayList.toArray(new SchemaDocument[0]);
    }

    public SchemaImport getImport(String string) {
        return this.imports.get(string);
    }

    public SchemaType getType(String string) {
        return this.types.get(string);
    }

    public ComplexType[] getTypes() {
        return this.types.values().toArray(new ComplexType[0]);
    }

    public SchemaElement getElement(String string) {
        return this.elements.get(string);
    }

    public SchemaElement[] getElements() {
        return this.elements.values().toArray(new SchemaElement[0]);
    }

    public Namespace getNamespace() {
        return this.schema.getNamespace();
    }

    public Element getSchema() {
        return this.schema;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isImported(String string) {
        return this.imports.containsKey(string);
    }

    public Namespace addImport(SchemaDocument schemaDocument) {
        if (!this.isImported(schemaDocument.getTargetNamespace())) {
            Namespace namespace = Namespace.getNamespace((String)this.buildPrefix(schemaDocument.getTargetNamespace()), (String)schemaDocument.getTargetNamespace());
            this.addImport(namespace, schemaDocument.getFileName());
            return namespace;
        }
        return null;
    }

    private String buildPrefix(String string) {
        return string;
    }

    public void addImport(Namespace namespace) {
        this.addImport(namespace, namespace.getURI());
    }

    public void addImport(Namespace namespace, String string) {
        this.schema.addNamespaceDeclaration(namespace);
        SchemaImport schemaImport = new SchemaImport(this.schema.getNamespace(), namespace.getURI(), string);
        this.imports.put(namespace.getURI(), schemaImport);
        this.schema.addContent(0, (Content)schemaImport.element);
    }

    public SimpleType addSimpleType(String string, SchemaType schemaType) throws Exception {
        SimpleType simpleType = new SimpleType(string, schemaType, this);
        this.addType(simpleType);
        return simpleType;
    }

    public ComplexType createComplexType() throws Exception {
        return new ComplexType(this);
    }

    public ComplexType addComplexType(String string) throws Exception {
        return this.addComplexType(null, string, false);
    }

    public ComplexType addComplexType(String string, boolean bl) throws Exception {
        return this.addComplexType(null, string, bl);
    }

    public ComplexType addComplexType(SchemaType schemaType, String string) throws Exception {
        return this.addComplexType(schemaType, string, false);
    }

    public ComplexType addComplexType(SchemaType schemaType, String string, boolean bl) throws Exception {
        if (SchemaUtils.isValidName(string)) {
            ComplexType complexType = new ComplexType(string, schemaType, bl, this);
            this.addType(complexType);
            return complexType;
        }
        throw new SchemaException("invalid type name [" + string + "]");
    }

    private void addType(SchemaType schemaType) throws Exception {
        if (this.types.containsKey(schemaType.getName().getLocalPart())) {
            if (this.replace) {
                this.remove(this.types.get(schemaType.getName().getLocalPart()));
            } else {
                throw new SchemaException("type [" + schemaType.getName().getLocalPart() + "] already exists in namespace [" + this.getTargetNamespace() + "]");
            }
        }
        this.schema.addContent((Content)schemaType.getElement());
        this.types.put(schemaType.getName().getLocalPart(), schemaType);
    }

    public SchemaElement addGlobalElement(String string) throws Exception {
        return this.addGlobalElement(string, GenericTypes.STRING.getType());
    }

    public SchemaElement addGlobalElement(String string, SchemaType schemaType) throws Exception {
        if (SchemaUtils.isValidName(string)) {
            if (!this.elements.containsKey(string)) {
                SchemaElement schemaElement = SchemaElement.newInstance(string, schemaType, this);
                this.addGlobalElement(schemaElement);
                return schemaElement;
            }
            throw new SchemaException("namspace [" + this.getTargetNamespace() + "] already contains global element [" + string + "]");
        }
        throw new SchemaException("invalid element name [" + string + "]");
    }

    private void addGlobalElement(SchemaElement schemaElement) throws Exception {
        this.schema.addContent((Content)schemaElement.element);
        this.elements.put(schemaElement.getName().getLocalPart(), schemaElement);
    }

    public void removeType(String string) throws Exception {
        if (!this.types.containsKey(string)) {
            throw new SchemaException("type [" + string + "] is not a member of [" + this.getTargetNamespace() + "]");
        }
        this.remove(this.types.get(string));
    }

    public void removeElement(String string) throws Exception {
        if (!this.elements.containsKey(string)) {
            throw new SchemaException("element [" + string + "] is not a member of [" + this.getTargetNamespace() + "]");
        }
        this.remove(this.elements.get(string));
    }

    private void remove(SchemaType schemaType) throws Exception {
        if (!this.schema.removeContent((Content)schemaType.getElement())) {
            throw new SchemaException("complex type [" + schemaType.getName() + "] is not a member of [" + this.getTargetNamespace() + "]");
        }
        this.types.remove(schemaType.getName());
    }

    private void remove(SchemaElement schemaElement) throws Exception {
        if (!this.schema.removeContent((Content)schemaElement.element)) {
            throw new SchemaException("element [" + schemaElement.getName() + "] is not a member of [" + this.getTargetNamespace() + "]");
        }
        this.types.remove(schemaElement.getName());
    }

    private void remove(SchemaAttribute schemaAttribute) throws Exception {
        if (!this.schema.removeContent((Content)schemaAttribute.element)) {
            throw new SchemaException("attribute [" + schemaAttribute.getName() + "] is not a member of [" + this.getTargetNamespace() + "]");
        }
        this.attributes.remove(schemaAttribute.getName());
    }

    protected String lookupPrefix(String string) throws Exception {
        Namespace namespace = this.getNamespaceByURI(string);
        if (namespace != null) {
            return namespace.getPrefix();
        }
        SchemaDocument schemaDocument = this.sts.getNamespace(string);
        if (schemaDocument != null) {
            namespace = this.addImport(schemaDocument);
            return namespace.getPrefix();
        }
        throw new SchemaException("namespace [" + string + "] was not found in SchemaTypeSystem");
    }

    protected String getNamespaceByPrefix(String string) {
        if (string.equals(this.schema.getNamespacePrefix())) {
            return this.schema.getNamespaceURI();
        }
        for (Namespace namespace : this.schema.getAdditionalNamespaces()) {
            if (!namespace.getPrefix().equals(string)) continue;
            return namespace.getURI();
        }
        return null;
    }

    protected Namespace getNamespaceByURI(String string) {
        if (string.equals(this.schema.getNamespaceURI())) {
            return this.schema.getNamespace();
        }
        for (Namespace namespace : this.schema.getAdditionalNamespaces()) {
            if (!namespace.getURI().equals(string)) continue;
            return namespace;
        }
        return null;
    }

    private int parsePrefix(String string) {
        if (string.toLowerCase().startsWith(AUTO_PREFIX)) {
            try {
                return Integer.parseInt(string.substring(2));
            }
            catch (Exception exception) {
                System.err.println(string + " = " + exception.getMessage());
                return -1;
            }
        }
        return -1;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean bl) {
        this.replace = bl;
    }

    public SchemaType buildType(QName qName) {
        String string = qName.getNamespaceURI().replaceAll("/", "_").replaceAll(":", "_");
        QName qName2 = new QName(qName.getNamespaceURI(), qName.getLocalPart(), string);
        if (!qName.getNamespaceURI().equalsIgnoreCase("http://www.w3.org/2001/XMLSchema") && this.getImport(qName.getNamespaceURI()) == null) {
            this.addImport(Namespace.getNamespace((String)string, (String)qName.getNamespaceURI()));
        }
        return new GenericType(qName2);
    }
}

