/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common;

import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CheckBoxSelectionAdapter {
    Vector checkBoxes = new Vector();
    GroupCheckBoxChangeListener changeListener = new GroupCheckBoxChangeListener();
    boolean listenerAdded = false;

    public CheckBoxSelectionAdapter() {
    }

    public CheckBoxSelectionAdapter(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) == null) continue;
            this.checkBoxes.add(vector.elementAt(i));
        }
        this.addCheckBoxChangeListener();
    }

    public CheckBoxSelectionAdapter(JCheckBox[] jCheckBoxArray) {
        for (int i = 0; i < jCheckBoxArray.length; ++i) {
            if (jCheckBoxArray[i] == null) continue;
            this.checkBoxes.add(jCheckBoxArray[i]);
        }
        this.addCheckBoxChangeListener();
    }

    public CheckBoxSelectionAdapter(JCheckBox jCheckBox) {
        if (jCheckBox != null) {
            this.checkBoxes.add(jCheckBox);
            this.addCheckBoxChangeListener();
        }
    }

    public void addChangeListenerToCheckBox(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) == null || !(vector.elementAt(i) instanceof JCheckBox)) continue;
            ((JCheckBox)vector.elementAt(i)).addChangeListener(this.changeListener);
            this.checkBoxes.add(vector.elementAt(i));
        }
    }

    public void addChangeListenerToCheckBox(JCheckBox[] jCheckBoxArray) {
        for (int i = 0; i < jCheckBoxArray.length; ++i) {
            if (jCheckBoxArray[i] == null) continue;
            jCheckBoxArray[i].addChangeListener(this.changeListener);
            this.checkBoxes.add(jCheckBoxArray[i]);
        }
    }

    public void addChangeListenerToCheckBox(JCheckBox jCheckBox) {
        if (jCheckBox != null) {
            jCheckBox.addChangeListener(this.changeListener);
            this.checkBoxes.add(jCheckBox);
        }
    }

    public void removeChangeListenerToCheckBox(JCheckBox jCheckBox) {
        if (jCheckBox != null) {
            jCheckBox.removeChangeListener(this.changeListener);
            this.checkBoxes.remove(jCheckBox);
        }
    }

    private void addCheckBoxChangeListener() {
        if (this.listenerAdded) {
            return;
        }
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            ((JCheckBox)this.checkBoxes.elementAt(i)).addChangeListener(this.changeListener);
        }
        this.listenerAdded = true;
    }

    private boolean isAllUnselected() {
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            if (!((JCheckBox)this.checkBoxes.elementAt(i)).isSelected()) continue;
            return false;
        }
        return true;
    }

    private JCheckBox getChangedCheckBox(ChangeEvent changeEvent) {
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            if (changeEvent.getSource() != this.checkBoxes.elementAt(i)) continue;
            return (JCheckBox)changeEvent.getSource();
        }
        return null;
    }

    public void dispose() {
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            ((JCheckBox)this.checkBoxes.elementAt(i)).removeChangeListener(this.changeListener);
        }
        this.changeListener = null;
        this.checkBoxes.removeAllElements();
        this.checkBoxes = null;
    }

    public void clearElements() {
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            ((JCheckBox)this.checkBoxes.elementAt(i)).removeChangeListener(this.changeListener);
        }
        this.checkBoxes.removeAllElements();
    }

    class GroupCheckBoxChangeListener
    implements ChangeListener {
        GroupCheckBoxChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (CheckBoxSelectionAdapter.this.isAllUnselected()) {
                JCheckBox jCheckBox = CheckBoxSelectionAdapter.this.getChangedCheckBox(changeEvent);
                if (jCheckBox == null) {
                    return;
                }
                jCheckBox.setSelected(true);
            }
        }
    }
}

