/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common;

import commvault.cte.CteStringBank;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

class BrowserLauncher {
    private static int jvm;
    private static Object browser;
    private static boolean loadedWithoutErrors;
    private static Class mrjFileUtilsClass;
    private static Class mrjOSTypeClass;
    private static Class macOSErrorClass;
    private static Class aeDescClass;
    private static Constructor aeTargetConstructor;
    private static Constructor appleEventConstructor;
    private static Constructor aeDescConstructor;
    private static Method findFolder;
    private static Method getFileType;
    private static Method makeOSType;
    private static Method putParameter;
    private static Method sendNoReply;
    private static Object kSystemFolderType;
    private static Integer keyDirectObject;
    private static Integer kAutoGenerateReturnID;
    private static Integer kAnyTransactionID;
    private static final int MRJ_2_0 = 0;
    private static final int MRJ_2_1 = 1;
    private static final int MRJ_FUTURE = 200;
    private static final int WINDOWS_9x = 2;
    private static final int WINDOWS_NT = 3;
    private static final int OTHER = -1;
    private static final String FINDER_TYPE = "FNDR";
    private static final String FINDER_CREATOR = "MACS";
    private static final String GURL_EVENT = "GURL";
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String NETSCAPE_OPEN_PARAMETER_START = " -remote openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")";
    private static String errorMessage;

    private BrowserLauncher() {
    }

    private static boolean loadClasses() {
        switch (jvm) {
            case 0: {
                try {
                    Class<?> clazz = Class.forName("com.apple.MacOS.AETarget");
                    macOSErrorClass = Class.forName("com.apple.MacOS.MacOSError");
                    Class<?> clazz2 = Class.forName("com.apple.MacOS.OSUtils");
                    Class<?> clazz3 = Class.forName("com.apple.MacOS.AppleEvent");
                    Class<?> clazz4 = Class.forName("com.apple.MacOS.ae");
                    aeDescClass = Class.forName("com.apple.MacOS.AEDesc");
                    aeTargetConstructor = clazz.getDeclaredConstructor(Integer.TYPE);
                    appleEventConstructor = clazz3.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, clazz, Integer.TYPE, Integer.TYPE);
                    aeDescConstructor = aeDescClass.getDeclaredConstructor(String.class);
                    makeOSType = clazz2.getDeclaredMethod("makeOSType", String.class);
                    putParameter = clazz3.getDeclaredMethod("putParameter", Integer.TYPE, aeDescClass);
                    sendNoReply = clazz3.getDeclaredMethod("sendNoReply", new Class[0]);
                    Field field = clazz4.getDeclaredField("keyDirectObject");
                    keyDirectObject = (Integer)field.get(null);
                    Field field2 = clazz3.getDeclaredField("kAutoGenerateReturnID");
                    kAutoGenerateReturnID = (Integer)field2.get(null);
                    Field field3 = clazz3.getDeclaredField("kAnyTransactionID");
                    kAnyTransactionID = (Integer)field3.get(null);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    errorMessage = classNotFoundException.getMessage();
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    errorMessage = noSuchMethodException.getMessage();
                    return false;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    errorMessage = noSuchFieldException.getMessage();
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    errorMessage = illegalAccessException.getMessage();
                    return false;
                }
            }
            case 1: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
                    Field field = mrjFileUtilsClass.getDeclaredField("kSystemFolderType");
                    kSystemFolderType = field.get(null);
                    findFolder = mrjFileUtilsClass.getDeclaredMethod("findFolder", mrjOSTypeClass);
                    getFileType = mrjFileUtilsClass.getDeclaredMethod("getFileType", File.class);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    errorMessage = classNotFoundException.getMessage();
                    return false;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    errorMessage = noSuchFieldException.getMessage();
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    errorMessage = noSuchMethodException.getMessage();
                    return false;
                }
                catch (SecurityException securityException) {
                    errorMessage = securityException.getMessage();
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    errorMessage = illegalAccessException.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    private static Object locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (jvm) {
            case 0: {
                try {
                    Integer n = (Integer)makeOSType.invoke(null, FINDER_CREATOR);
                    Object t = aeTargetConstructor.newInstance(n);
                    Integer n2 = (Integer)makeOSType.invoke(null, GURL_EVENT);
                    Object t2 = appleEventConstructor.newInstance(n2, n2, t, kAutoGenerateReturnID, kAnyTransactionID);
                    return t2;
                }
                catch (IllegalAccessException illegalAccessException) {
                    browser = null;
                    errorMessage = illegalAccessException.getMessage();
                    return browser;
                }
                catch (InstantiationException instantiationException) {
                    browser = null;
                    errorMessage = instantiationException.getMessage();
                    return browser;
                }
                catch (InvocationTargetException invocationTargetException) {
                    browser = null;
                    errorMessage = invocationTargetException.getMessage();
                    return browser;
                }
            }
            case 1: {
                File file;
                try {
                    file = (File)findFolder.invoke(null, kSystemFolderType);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    browser = null;
                    errorMessage = illegalArgumentException.getMessage();
                    return browser;
                }
                catch (IllegalAccessException illegalAccessException) {
                    browser = null;
                    errorMessage = illegalAccessException.getMessage();
                    return browser;
                }
                catch (InvocationTargetException invocationTargetException) {
                    browser = null;
                    errorMessage = invocationTargetException.getTargetException().getClass() + ": " + invocationTargetException.getTargetException().getMessage();
                    return browser;
                }
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        File file2 = new File(file, stringArray[i]);
                        if (!file2.isFile()) continue;
                        Object object = getFileType.invoke(null, file2);
                        if (!FINDER_TYPE.equals(object.toString())) continue;
                        browser = file2.toString();
                        return browser;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        errorMessage = illegalArgumentException.getMessage();
                        return null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        browser = null;
                        errorMessage = illegalAccessException.getMessage();
                        return browser;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        browser = null;
                        errorMessage = invocationTargetException.getTargetException().getClass() + ": " + invocationTargetException.getTargetException().getMessage();
                        return browser;
                    }
                }
                browser = null;
                break;
            }
            case 3: {
                browser = "rundll32 url.dll,FileProtocolHandler";
                break;
            }
            case 2: {
                browser = "command.com";
                break;
            }
            default: {
                browser = "netscape";
            }
        }
        return browser;
    }

    public static void openURL(String string) throws IOException {
        System.out.println("BrowserLauncher.openURL: url=" + string);
        if (!loadedWithoutErrors) {
            throw new IOException(CteStringBank.Exception_in_finding_browser7_.getI18n() + errorMessage);
        }
        Object object = BrowserLauncher.locateBrowser();
        if (object == null && jvm != 200) {
            throw new IOException(CteStringBank.Unable_to_locate_browser7_.getI18n() + errorMessage);
        }
        switch (jvm) {
            case 0: {
                Object var2_2 = null;
                try {
                    var2_2 = aeDescConstructor.newInstance(string);
                    putParameter.invoke(object, keyDirectObject, var2_2);
                    sendNoReply.invoke(object, new Object[0]);
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new IOException("InvocationTargetException while creating AEDesc: " + invocationTargetException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IOException("IllegalAccessException while building AppleEvent: " + illegalAccessException.getMessage());
                }
                catch (InstantiationException instantiationException) {
                    throw new IOException("InstantiationException while creating AEDesc: " + instantiationException.getMessage());
                }
                finally {
                    var2_2 = null;
                    object = null;
                }
            }
            case 1: {
                Runtime.getRuntime().exec(new String[]{(String)object, string});
                break;
            }
            case 3: {
                if (!string.startsWith("http:") && !string.startsWith("https:")) {
                    Runtime.getRuntime().exec(new String[]{"cmd", "/C", SECOND_WINDOWS_PARAMETER, "\"\"", "\"" + string + "\""});
                    break;
                }
                String string2 = System.getProperty("os.name").toLowerCase();
                System.out.println("Launching browser for " + string2);
                if (string2.contains("windows 2000")) {
                    try {
                        Runtime.getRuntime().exec(object + " " + string);
                    }
                    catch (RuntimeException runtimeException) {
                        System.out.println("OS: " + string2 + runtimeException.getMessage() + "; " + runtimeException.toString());
                    }
                    break;
                }
                try {
                    final Object object2 = object;
                    final String string3 = string;
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                Runtime.getRuntime().exec(object2 + " \"" + string3 + "\"");
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            return null;
                        }
                    });
                }
                catch (RuntimeException runtimeException) {
                    System.out.println("OS: " + string2 + runtimeException.getMessage() + "; " + runtimeException.toString());
                }
                break;
            }
            case 2: {
                Runtime.getRuntime().exec(new String[]{(String)object, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, string});
                break;
            }
            case -1: {
                try {
                    String[] stringArray = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                    String string4 = null;
                    for (int i = 0; i < stringArray.length && string4 == null; ++i) {
                        if (Runtime.getRuntime().exec(new String[]{"which", stringArray[i]}).waitFor() != 0) continue;
                        string4 = stringArray[i];
                    }
                    if (string4 == null) {
                        System.err.println("BrowserLauncher.openURL: Could not find web browser");
                        throw new Exception("Could not find web browser");
                    }
                    System.out.println("BrowserLauncher.openURL: selectedBrowser=" + string4 + ", url=" + string);
                    Runtime.getRuntime().exec(new String[]{string4, string});
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 200: {
                try {
                    Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                    Method method = clazz.getDeclaredMethod("openURL", String.class);
                    method.invoke(null, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            default: {
                Runtime.getRuntime().exec(new String[]{(String)object, string});
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 1) {
            BrowserLauncher.openURL("http://java.sun.com");
        } else {
            BrowserLauncher.openURL(stringArray[0]);
        }
    }

    static {
        block7: {
            loadedWithoutErrors = true;
            String string = System.getProperty("os.name");
            if ("Mac OS".equals(string)) {
                String string2 = System.getProperty("mrj.version");
                String string3 = string2.substring(0, 3);
                try {
                    double d = Double.valueOf(string3);
                    if (d == 2.0) {
                        jvm = 0;
                        break block7;
                    }
                    if (d >= 2.1) {
                        jvm = 1;
                        break block7;
                    }
                    jvm = 200;
                    loadedWithoutErrors = false;
                    errorMessage = "Unsupported MRJ version: " + d;
                }
                catch (NumberFormatException numberFormatException) {
                    loadedWithoutErrors = false;
                    errorMessage = "Invalid MRJ version: " + string2;
                }
            } else {
                jvm = string.startsWith("Windows") ? (string.indexOf("9") != -1 ? 2 : 3) : -1;
            }
        }
        if (loadedWithoutErrors) {
            loadedWithoutErrors = BrowserLauncher.loadClasses();
        }
    }
}

