/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.cm;

import commvault.cte.cm.BaseFolder;
import commvault.cte.cm.CMUtil;
import commvault.cte.cm.ColumnType;
import commvault.cte.cm.FolderColumn;
import commvault.cte.cm.FolderDocumentModel;
import commvault.cte.cm.FolderEntry;
import commvault.cte.cm.FolderListModel;
import commvault.cte.cm.FolderType;
import commvault.cte.cm.db.DBSelect;
import commvault.cte.cm.db.DBTransaction;
import commvault.cte.cm.db.DBXml;
import commvault.msgs.CM.Column;
import commvault.msgs.CM.CreateFolder;
import commvault.msgs.CM.Folder;
import commvault.msgs.CM.FolderResponse;
import commvault.msgs.CM.GetFolder;
import commvault.msgs.CM.Site;
import commvault.msgs.CM.UpdateFolder;
import commvault.msgs.CvEntities.FolderEntity;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public abstract class FolderModel
extends BaseFolder {
    private DBSelect db;
    private ResultSet rows;

    public static FolderModel getFolder(int n) throws Exception {
        FolderEntity folderEntity = new FolderEntity();
        folderEntity.setFolderId(n);
        return FolderModel.getFolder(folderEntity);
    }

    public static FolderModel getFolder(FolderEntity folderEntity) throws Exception {
        GetFolder getFolder = new GetFolder();
        getFolder.setFolder(folderEntity);
        FolderResponse folderResponse = (FolderResponse)DBXml.execute("GetFolder", getFolder);
        if (folderResponse.getFolder().getFolderType() == FolderType.LIST.toInt()) {
            return new FolderListModel(folderResponse.getFolder());
        }
        return new FolderDocumentModel(folderResponse.getFolder());
    }

    protected FolderModel(Site site) {
        super(site);
        FolderColumn folderColumn = FolderColumn.create("Date Created", "Date entry was created", ColumnType.DATETIME, false, "");
        folderColumn.getColumn().setSqlName("Created");
        folderColumn.setSystem(true);
        folderColumn.setReadOnly(true);
        folderColumn.setColumnIndex(999);
        this.getColumns().add(folderColumn);
        FolderColumn folderColumn2 = FolderColumn.create("Date Modified", "Date entry was modified", ColumnType.DATETIME, false, "");
        folderColumn2.getColumn().setSqlName("Modified");
        folderColumn2.setSystem(true);
        folderColumn2.setReadOnly(true);
        folderColumn.setColumnIndex(999);
        this.getColumns().add(folderColumn2);
    }

    protected FolderModel(Folder folder) {
        super(folder);
    }

    private ResultSet queryRows() throws Exception {
        ArrayList arrayList = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT Id,");
        for (int i = 0; i < this.columns.size(); ++i) {
            if (((Column)this.columns.get(i)).getDefaultValue() != null && ((Column)this.columns.get(i)).getDefaultValue().length() > 0) {
                stringBuilder.append("ISNULL(");
                stringBuilder.append(((Column)this.columns.get(i)).getColumn().getSqlName());
                stringBuilder.append(",?) AS ");
                stringBuilder.append(((Column)this.columns.get(i)).getColumn().getSqlName());
                arrayList.add(this.columns.get(i));
            } else {
                stringBuilder.append(((Column)this.columns.get(i)).getColumn().getSqlName());
            }
            if (i >= this.columns.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.getTableName());
        this.db = DBSelect.create(stringBuilder.toString(), true);
        for (Column column : arrayList) {
            this.db.addParameter(column);
        }
        return this.db.execute();
    }

    public ResultSet getRows() throws Exception {
        if (this.getFolder().getFolderId() > 0 && this.rows == null) {
            this.rows = this.queryRows();
        }
        return this.rows;
    }

    public void closeResult() {
        this.db.close();
        this.rows = null;
    }

    public void save() throws Exception {
        Folder folder = null;
        this.sort();
        this.reindex();
        folder = this.getFolder().getFolderId() == 0 ? this.create() : this.update();
        if (folder != null) {
            this.updateFolder(folder);
        }
    }

    public Folder create() throws Exception {
        CreateFolder createFolder = new CreateFolder();
        createFolder.setSite(this.getSite().getSite());
        createFolder.setFolder((Folder)this);
        FolderResponse folderResponse = (FolderResponse)DBXml.execute("CreateFolder", createFolder);
        String[] stringArray = CMUtil.getCreateFolderScript(folderResponse.getFolder());
        DBTransaction.executeTransaction(stringArray);
        return folderResponse.getFolder();
    }

    private Folder update() throws Exception {
        UpdateFolder updateFolder = new UpdateFolder();
        updateFolder.setFolder((Folder)this);
        FolderResponse folderResponse = (FolderResponse)DBXml.execute("p_UpdateFolder", updateFolder);
        List<String> list = CMUtil.getAlterFolderScript(this);
        if (list.size() > 0) {
            DBTransaction.executeTransaction(list.toArray(new String[0]));
        }
        return folderResponse.getFolder();
    }

    private void updateFolder(Folder folder) {
        this.folder = folder.getFolder();
        this.site = folder.getSite();
        this.folderType = folder.getFolderType();
        this.description = folder.getDescription();
        this.tableName = folder.getTableName();
        this.auditTable = folder.getAuditTable();
        this.attachmentTable = folder.getAttachmentTable();
        this.folderView = folder.getFolderView();
        this.status = folder.getStatus();
        this.created = folder.getCreated();
        this.modified = folder.getModified();
        this.deleted = folder.getDeleted();
        this.columns = folder.getColumns();
    }

    public abstract FolderEntry getEntry(int var1) throws Exception;
}

