/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.cm;

import commvault.cte.cm.FolderAttachment;
import commvault.cte.cm.FolderEntry;
import commvault.cte.cm.db.DBConnection;
import commvault.cte.cm.db.DBSelect;
import commvault.msgs.CM.Column;
import commvault.msgs.CM.Folder;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FolderListEntry
extends FolderEntry {
    private List<FolderAttachment> attachments = new ArrayList<FolderAttachment>();
    protected Map<String, FolderAttachment> namedAttachments = new HashMap<String, FolderAttachment>();

    protected FolderListEntry(Folder folder) {
        super(folder);
        for (Column column : this.getColumns()) {
            if (column.getDefaultValue() == null || column.getDefaultValue().length() <= 0) continue;
            column.setRowValue(column.getDefaultValue());
        }
    }

    protected FolderListEntry(Folder folder, int n) throws Exception {
        super(folder, n);
        this.loadAttachments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttachments() throws Exception {
        try (DBConnection dBConnection = null;){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select AttachmentId,RowId,FileName,Size,Description,ContentType,Created from ");
            stringBuilder.append(this.getAttachmentTable());
            stringBuilder.append(" where RowId = ");
            stringBuilder.append(this.rowId);
            dBConnection = DBSelect.create(stringBuilder.toString());
            ResultSet resultSet = ((DBSelect)dBConnection).execute();
            while (resultSet.next()) {
                FolderAttachment folderAttachment = new FolderAttachment();
                folderAttachment.setAttachmentId(resultSet.getInt("AttachmentId"));
                folderAttachment.setRowId(this.getRowId());
                folderAttachment.setAttachmentTable(this.getAttachmentTable());
                folderAttachment.setFileName(resultSet.getString("FileName"));
                folderAttachment.setSize(resultSet.getInt("Size"));
                folderAttachment.setDescription(resultSet.getString("Description"));
                folderAttachment.setContentType(resultSet.getString("ContentType"));
                folderAttachment.setCreated(resultSet.getString("Created"));
                this.attachments.add(folderAttachment);
                this.namedAttachments.put(folderAttachment.getFileName(), folderAttachment);
            }
        }
    }

    public List<FolderAttachment> getAttachments() {
        return this.attachments;
    }

    public void attach(String string, String string2, long l, String string3, InputStream inputStream) throws Exception {
        if (this.getRowId() == 0) {
            throw new Exception("cannot add attachment to new folder entry");
        }
        if (this.namedAttachments.containsKey(string)) {
            FolderAttachment folderAttachment = this.namedAttachments.get(string);
            folderAttachment.setContentType(string2);
            folderAttachment.setSize(l);
            folderAttachment.setDescription(string3);
            folderAttachment.save(inputStream);
        } else {
            FolderAttachment folderAttachment = new FolderAttachment();
            folderAttachment.setRowId(this.rowId);
            folderAttachment.setAttachmentTable(this.getAttachmentTable());
            folderAttachment.setFileName(string);
            folderAttachment.setContentType(string2);
            folderAttachment.setSize(l);
            folderAttachment.setDescription(string3);
            folderAttachment.save(inputStream);
            this.getAttachments().add(folderAttachment);
            this.namedAttachments.put(string, folderAttachment);
        }
    }

    public FolderAttachment getAttachment(String string) {
        return this.namedAttachments.get(string);
    }
}

