/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.cm;

import commvault.cte.cm.ColumnType;
import commvault.msgs.CM.Column;
import commvault.msgs.CM.Folder;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class CMUtil {
    private static final String CREATE_COLUMN = "    [%s] %s NULL,\n";
    private static final String ADD_COLUMN = "ALTER TABLE %s ADD %s %s NULL";
    private static final String ALTER_COLUMN = "ALTER TABLE %s ALTER COLUMN %s %s";

    public static String readStream(InputStream inputStream) throws Exception {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string + "\n");
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public static String readFile(String string) throws Exception {
        File file = new File(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray = new byte[(int)file.length()];
        bufferedInputStream.read(byArray);
        bufferedInputStream.close();
        return new String(byArray);
    }

    protected static String[] getCreateFolderScript(Folder folder) throws Exception {
        String[] stringArray = new String[]{CMUtil.buildDataTableScript(folder), CMUtil.buildAuditTableScript(folder), CMUtil.buildAttachmentTableScript(folder)};
        return stringArray;
    }

    private static String buildDataTableScript(Folder folder) throws Exception {
        String string = CMUtil.readFile("C:\\Development\\CTEJava\\Source\\commvault\\cte\\cm\\db\\dataTable.sql");
        string = string.replaceAll("TABLENAME", folder.getTableName());
        StringBuilder stringBuilder = new StringBuilder();
        for (Column column : folder.getColumns()) {
            if (column.getSystem()) continue;
            ColumnType columnType = ColumnType.fromInt(column.getColumnType());
            stringBuilder.append(String.format(CREATE_COLUMN, column.getColumn().getSqlName(), columnType.getSqlScript()));
        }
        string = string.replaceFirst("COLUMNS", stringBuilder.toString());
        return string;
    }

    private static String buildAuditTableScript(Folder folder) throws Exception {
        String string = CMUtil.readFile("C:\\Development\\CTEJava\\Source\\commvault\\cte\\cm\\db\\auditTable.sql");
        string = string.replaceAll("TABLENAME", folder.getAuditTable());
        return string;
    }

    private static String buildAttachmentTableScript(Folder folder) throws Exception {
        String string = CMUtil.readFile("C:\\Development\\CTEJava\\Source\\commvault\\cte\\cm\\db\\attachmentTable.sql");
        string = string.replaceAll("TABLENAME", folder.getAttachmentTable());
        return string;
    }

    protected static List<String> getAlterFolderScript(Folder folder) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Column column : folder.getColumns()) {
            ColumnType columnType = ColumnType.fromInt(column.getColumnType());
            if (!column.getSqlCreated()) {
                arrayList.add(String.format(ADD_COLUMN, folder.getTableName(), column.getColumn().getSqlName(), columnType.getSqlScript()));
                continue;
            }
            if (column.getSqlType().length() <= 0 || column.getSqlType().equals(columnType.getSqlType())) continue;
            arrayList.add(String.format(ALTER_COLUMN, folder.getTableName(), column.getColumn().getSqlName(), columnType.getSqlScript()));
        }
        return arrayList;
    }
}

