/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.alert.model;

import commvault.cte.alert.model.ICriteria;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class AlertCriteria {
    private ICriteria criteria;
    private List tokenizedName = null;
    private String alertValue;
    private int reportId;
    private int taskId;
    private boolean selected;

    public AlertCriteria(ICriteria iCriteria) {
        this.criteria = iCriteria;
        this.parseCriteria(this.criteria.getCriterta().getName());
    }

    public ICriteria getCriteria() {
        return this.criteria;
    }

    public List getParsedName() {
        return this.tokenizedName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AlertCriteria)) {
            return false;
        }
        AlertCriteria alertCriteria = (AlertCriteria)object;
        return !(this.criteria.getCriterta() != null ? !this.criteria.getCriterta().equals(alertCriteria.getCriteria()) : alertCriteria.getCriteria() != null);
    }

    public int hashCode() {
        return this.criteria != null ? this.criteria.hashCode() : 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.tokenizedName != null) {
            for (Object e : this.tokenizedName) {
                stringBuffer.append(" ");
                stringBuffer.append(e);
            }
        }
        return stringBuffer.toString();
    }

    private void parseCriteria(String string) {
        this.tokenizedName = new ArrayList();
        int n = 0;
        while (n >= 0) {
            int n2 = string.indexOf(60, n);
            if (n2 < 0) {
                this.tokenizedName.add(string.substring(n));
                return;
            }
            if (n2 != n) {
                this.tokenizedName.add(string.substring(n, n2));
            }
            n = n2;
            int n3 = string.indexOf(62, n);
            String string2 = string.substring(n + 1, n3);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n4 = 0;
            int[] nArray = new int[5];
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().trim();
                nArray[n4++] = Integer.parseInt(string3);
            }
            this.tokenizedName.add(new CriteriaInput(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]));
            n = n3 + 1;
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void setValueAt(long l, long l2) {
        Iterator iterator = this.getParsedName().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CriteriaInput)) continue;
            CriteriaInput criteriaInput = (CriteriaInput)e;
            if (l == (long)n) {
                criteriaInput.setValue((int)l2);
                return;
            }
            ++n;
        }
    }

    public boolean isCompositeCriteria() {
        if (this.tokenizedName != null) {
            for (Object e : this.tokenizedName) {
                CriteriaInput criteriaInput;
                if (!(e instanceof CriteriaInput) || (criteriaInput = (CriteriaInput)e).getType() == 0) continue;
                return true;
            }
        }
        return false;
    }

    public String getAlertValue() {
        return this.alertValue;
    }

    public void setAlertValue(String string) {
        this.alertValue = string;
    }

    public int getReportId() {
        return this.reportId;
    }

    public void setReportId(int n) {
        this.reportId = n;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int n) {
        this.taskId = n;
    }

    public static class CriteriaInput {
        private int type;
        private int value;
        private int unit;
        private int defaulValue;
        private int minValue;
        private int maxValue;

        private CriteriaInput(int n, int n2) {
            this.type = n;
            this.unit = n2;
        }

        private CriteriaInput(int n, int n2, int n3, int n4, int n5) {
            this.type = n;
            this.unit = n2;
            this.defaulValue = n3;
            this.minValue = n4;
            this.maxValue = n5;
        }

        public int getType() {
            return this.type;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }

        public int getUnit() {
            return this.unit;
        }

        public String toString() {
            return "" + this.value;
        }

        public int getDefaulValue() {
            return this.defaulValue;
        }

        public int getMinValue() {
            return this.minValue;
        }

        public int getMaxValue() {
            return this.maxValue;
        }
    }
}

