/*
  This is a basic skeleton JavaScript update processor.

  In order for this to be executed, it must be properly wired into solrconfig.xml; by default it is commented out in
  the example solrconfig.xml and must be uncommented to be enabled.

  See http://wiki.apache.org/solr/ScriptUpdateProcessor for more details.
*/

function processAdd(cmd) {
	
	
	if(typeof params == 'undefined') return;

    doc = cmd.solrDoc;  // org.apache.solr.common.SolrInputDocument

    var lookup_url          = params.get('lookup_url');
    var lookupSourceField   = params.get("lookupSourceField");
    var lookupDestField     = params.get("lookupDestField");
    var requestedFields     = params.get("fields");	//comma separated value
	var sourceToDestFieldMap = params.get("fieldsMap");	//<sourcefield>:<destinationfield>,<sourcefield_1>:<destinationfield_1>
	
    //fetch value for
    var lookupSourceFieldValue = doc.getFieldValue(lookupSourceField);
    logger.info("update-script#processAdd: "+ lookupSourceField +"=" + lookupSourceFieldValue);

    if (lookupSourceFieldValue && lookup_url && lookupSourceField && lookupDestField && requestedFields) {
		
		var arrayFields 			= requestedFields.split(',');
		var sourceToDestFieldMapArray= new Object();
		
		if(sourceToDestFieldMap)
			sourceToDestFieldMapArray = sourceToDestFieldMap.split(',') ;
		
        //logger.info("lookup url" + lookup_url);
        var urlConnection = new java.net.URL(lookup_url + "?q=" + lookupDestField + ":" + lookupSourceFieldValue + "&wt=json&rows=1&fl=" + requestedFields);
        var yc = urlConnection.openConnection();
        var br = new java.io.BufferedReader(new java.io.InputStreamReader(yc.getInputStream()));
        var response = "";
        while ((inputLine = br.readLine()) != null)
            response += inputLine;
        br.close();
		
        var resp = mapSearchEngineRespToDTFormat(response);
        //logger.info(resp);
        if (resp && resp.length > 0) {
			
			//create source and destinationfield map
			var fieldsMap = new Object();
			
			if(sourceToDestFieldMapArray && sourceToDestFieldMapArray.length > 0){
				for (i = 0; i < sourceToDestFieldMapArray.length; i++) {
					var tempmap = sourceToDestFieldMapArray[i].split(":",2);
					if(tempmap && tempmap.length == 2){
						fieldsMap[tempmap[0]]= tempmap[1];
					}
				}
			}
			
            for (i = 0; i < arrayFields.length; i++) {
                var name = arrayFields[i];
                var value = resp[0][arrayFields[i]];
				
				if(fieldsMap[name])
					name = fieldsMap[name];
				
				if (value) {			
				    doc.setField(name, value);
				}
            }
        }
    }
    //else
      //doc.setField("CDVADADSA", "No value");	
	
}

function mapSearchEngineRespToDTFormat(seResp) {
	//logger.info("method called"+seResp);
	if (seResp)
	{
		var seRespObj = JSON.parse(seResp);	
		if( seRespObj.response && seRespObj.response.docs) 
			return seRespObj.response.docs;
	} 
	return [];
}
function processDelete(cmd) {
  // no-op
}

function processMergeIndexes(cmd) {
  // no-op
}

function processCommit(cmd) {
  // no-op
}

function processRollback(cmd) {
  // no-op
}

function finish() {
  // no-op
}
