/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import javax.net.SocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SingleServerSet
extends ServerSet {
    private final int port;
    private final LDAPConnectionOptions connectionOptions;
    private final SocketFactory socketFactory;
    private final String address;

    public SingleServerSet(String address, int port) {
        this(address, port, null, null);
    }

    public SingleServerSet(String address, int port, LDAPConnectionOptions connectionOptions) {
        this(address, port, null, connectionOptions);
    }

    public SingleServerSet(String address, int port, SocketFactory socketFactory) {
        this(address, port, socketFactory, null);
    }

    public SingleServerSet(String address, int port, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions) {
        Validator.ensureNotNull(address);
        Validator.ensureTrue(port > 0 && port < 65536, "SingleServerSet.port must be between 1 and 65535.");
        this.address = address;
        this.port = port;
        this.socketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        this.connectionOptions = connectionOptions == null ? new LDAPConnectionOptions() : connectionOptions;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public LDAPConnection getConnection() throws LDAPException {
        return new LDAPConnection(this.socketFactory, this.connectionOptions, this.address, this.port);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("SingleServerSet(server=");
        buffer.append(this.address);
        buffer.append(':');
        buffer.append(this.port);
        buffer.append(')');
    }
}

