/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractSparseDoubleMatrix2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedSparseDoubleMatrix2D
extends AbstractSparseDoubleMatrix2D {
    private static final long serialVersionUID = -8455710302874238051L;
    private final long[] data = new long[300];
    private int entryCount = 0;

    public IndexedSparseDoubleMatrix2D(Matrix m) {
        this(m.getRowCount(), m.getColumnCount());
    }

    public IndexedSparseDoubleMatrix2D(long rows, long columns) {
        super(rows, columns);
    }

    @Override
    public double getDouble(long row, long column) {
        if (this.entryCount == 0) {
            return 0.0;
        }
        int stepSize = this.entryCount / 4 + 1;
        int pos = this.entryCount / 2;
        do {
            if (this.data[pos * 3] == row) {
                if (this.data[pos * 3 + 1] == column) {
                    return Double.longBitsToDouble(this.data[pos + 2]);
                }
                if (this.data[pos * 3 + 1] < column) {
                    pos += stepSize;
                    continue;
                }
                pos -= stepSize;
                continue;
            }
            if (this.data[pos * 3] < row) {
                pos += stepSize;
                continue;
            }
            pos -= stepSize;
        } while ((stepSize /= 2) > 0);
        return 0.0;
    }

    @Override
    public void setDouble(double value, long row, long column) {
        if (this.entryCount * 3 == this.data.length) {
            this.grow();
        }
        if (this.entryCount == 0) {
            this.data[2] = Double.doubleToLongBits(value);
            ++this.entryCount;
            return;
        }
        int stepSize = this.entryCount / 4 + 1;
        int pos = this.entryCount / 2;
        do {
            if (this.data[pos * 3] == row) {
                if (this.data[pos * 3 + 1] == column) {
                    this.data[pos * 3 + 2] = Double.doubleToLongBits(value);
                    return;
                }
                if (this.data[pos * 3 + 1] < column) {
                    pos += stepSize;
                    continue;
                }
                pos -= stepSize;
                continue;
            }
            if (this.data[pos * 3] < row) {
                pos += stepSize;
                continue;
            }
            pos -= stepSize;
        } while ((stepSize /= 2) > 0);
        this.data[pos * 3] = row;
        this.data[pos * 3 + 1] = column;
        this.data[pos * 3 + 2] = Double.doubleToLongBits(value);
        ++this.entryCount;
    }

    private void grow() {
    }

    @Override
    public final void clear() {
        this.entryCount = 0;
    }

    private int getPos(long row, long column) {
        int stepSize = this.entryCount / 2;
        int pos = stepSize * 3;
        while (stepSize > 1) {
            if (this.data[pos] == row) {
                if (this.data[pos + 1] == column) {
                    return pos;
                }
                if (this.data[pos + 1] < column) {
                    pos -= (stepSize /= 2);
                    continue;
                }
                pos += (stepSize /= 2);
                continue;
            }
            if (this.data[pos] < row) {
                pos -= (stepSize /= 2);
                continue;
            }
            pos += (stepSize /= 2);
        }
        return -1;
    }

    @Override
    public double getDouble(int row, int column) {
        return this.getDouble((long)row, (long)column);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.setDouble(value, (long)row, (long)column);
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        return this.getDouble(coordinates) == 0.0;
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        throw new RuntimeException("not implemented");
    }
}

