/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.booleanmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.booleanmatrix.BooleanMatrix;
import org.ujmp.core.booleanmatrix.calculation.BooleanCalculation;
import org.ujmp.core.booleanmatrix.impl.BooleanCalculationMatrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;

public abstract class AbstractBooleanCalculation
extends AbstractCalculation
implements BooleanCalculation {
    private static final long serialVersionUID = 1357508932960938265L;

    public AbstractBooleanCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractBooleanCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final BooleanMatrix calcNew() {
        BooleanMatrix result = (BooleanMatrix)Matrix.Factory.zeros(ValueType.BOOLEAN, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsBoolean(this.getBoolean(c), c);
        }
        if (this.getMetaData() != null) {
            result.setMetaData(this.getMetaData().clone());
        }
        return result;
    }

    public final BooleanMatrix calcLink() {
        return new BooleanCalculationMatrix(this);
    }

    public final Matrix calcOrig() {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new RuntimeException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsBoolean(this.getBoolean(c), c);
        }
        this.getSource().fireValueChanged();
        return this.getSource();
    }

    public void setBoolean(boolean value, long ... coordinates) {
    }

    public final ValueType getValueType() {
        return ValueType.BOOLEAN;
    }
}

