/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bigintegermatrix.impl;

import java.math.BigInteger;
import java.util.Arrays;
import org.ujmp.core.bigintegermatrix.stub.AbstractDenseBigIntegerMatrix2D;

public class ArrayDenseBigIntegerMatrix2D
extends AbstractDenseBigIntegerMatrix2D {
    private static final long serialVersionUID = 3110279640095711135L;
    private final BigInteger[][] values;

    public ArrayDenseBigIntegerMatrix2D(BigInteger[] ... v) {
        super((long)v.length, (long)v[0].length);
        this.values = v;
    }

    public ArrayDenseBigIntegerMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.values = new BigInteger[rows][columns];
        int r = this.values.length;
        while (--r != -1) {
            Arrays.fill(this.values[r], BigInteger.ZERO);
        }
    }

    public ArrayDenseBigIntegerMatrix2D(BigInteger ... v) {
        super((long)v.length, 1L);
        this.values = new BigInteger[v.length][1];
        int r = v.length;
        while (--r >= 0) {
            this.values[r][0] = v[r];
        }
    }

    public BigInteger getBigInteger(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setBigInteger(BigInteger value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public BigInteger getBigInteger(int row, int column) {
        return this.values[row][column];
    }

    public void setBigInteger(BigInteger value, int row, int column) {
        this.values[row][column] = value;
    }
}

