/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Buffer;
import com.github.benmanes.caffeine.cache.StripedBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

final class BoundedBuffer<E>
extends StripedBuffer<E> {
    static final int BUFFER_SIZE = 32;
    static final int BUFFER_MASK = 31;

    BoundedBuffer() {
    }

    @Override
    protected Buffer<E> create(E e) {
        return new RingBuffer<E>(e);
    }

    static final class RingBuffer<E>
    implements Buffer<E> {
        final AtomicLong readCounter = new AtomicLong();
        final AtomicLong writeCounter = new AtomicLong(1L);
        final AtomicReference<E>[] buffer = new AtomicReference[32];

        public RingBuffer(E e) {
            for (int i = 0; i < 32; ++i) {
                this.buffer[i] = new AtomicReference();
            }
            this.buffer[0].lazySet(e);
        }

        @Override
        public int offer(E e) {
            long head = this.readCounter.get();
            long tail = this.writeCounter.get();
            long size = tail - head;
            if (size >= 32L) {
                return 1;
            }
            if (this.writeCounter.compareAndSet(tail, tail + 1L)) {
                int index = (int)(tail & 0x1FL);
                this.buffer[index].lazySet(e);
                return 0;
            }
            return -1;
        }

        @Override
        public void drain(Consumer<E> consumer) {
            int index;
            AtomicReference<E> slot;
            E e;
            long head = this.readCounter.get();
            long tail = this.writeCounter.get();
            long size = tail - head;
            if (size == 0L) {
                return;
            }
            while ((e = (slot = this.buffer[index = (int)(head & 0x1FL)]).get()) != null) {
                slot.lazySet(null);
                consumer.accept(e);
                if (++head != tail) continue;
            }
            this.readCounter.lazySet(head);
        }

        @Override
        public int size() {
            return this.writes() - this.reads();
        }

        @Override
        public int reads() {
            return this.readCounter.intValue();
        }

        @Override
        public int writes() {
            return this.writeCounter.intValue();
        }
    }
}

