/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.RemovalNotification;
import com.github.benmanes.caffeine.cache.Weigher;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

final class Async {
    private Async() {
    }

    static boolean isReady(@Nullable CompletableFuture<?> future) {
        return future != null && future.isDone() && !future.isCompletedExceptionally();
    }

    @Nullable
    static <V> V getIfReady(@Nullable CompletableFuture<V> future) {
        return Async.isReady(future) ? (V)future.join() : null;
    }

    @Nullable
    static <V> V getWhenSuccessful(@Nullable CompletableFuture<V> future) {
        try {
            return future == null ? null : (V)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    static final class AsyncWeigher<K, V>
    implements Weigher<K, CompletableFuture<V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Weigher<K, V> delegate;

        AsyncWeigher(Weigher<K, V> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public int weigh(K key, CompletableFuture<V> future) {
            return Async.isReady(future) ? this.delegate.weigh(key, future.join()) : 0;
        }

        Object writeReplace() {
            return this.delegate;
        }
    }

    static final class AsyncRemovalListener<K, V>
    implements RemovalListener<K, CompletableFuture<V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final RemovalListener<K, V> delegate;
        final Executor executor;

        AsyncRemovalListener(RemovalListener<K, V> delegate, Executor executor) {
            this.delegate = Objects.requireNonNull(delegate);
            this.executor = Objects.requireNonNull(executor);
        }

        @Override
        public void onRemoval(RemovalNotification<K, CompletableFuture<V>> notification) {
            notification.getValue().thenAcceptAsync(value -> this.delegate.onRemoval(new RemovalNotification(notification.getKey(), value, notification.getCause())), this.executor);
        }

        Object writeReplace() {
            return this.delegate;
        }
    }
}

