/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSamplingParameters;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Collect;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sample;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.stream.Delta;
import org.apache.calcite.rel.stream.LogicalDelta;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.schema.ModifiableView;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SemiJoinType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSampleSpec;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSetOperator;
import org.apache.calcite.sql.SqlUnnestOperator;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlValuesOperator;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlInOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.type.TableFunctionReturnTypeInference;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.AggregatingSelectScope;
import org.apache.calcite.sql.validate.CollectNamespace;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.ListScope;
import org.apache.calcite.sql.validate.MatchRecognizeScope;
import org.apache.calcite.sql.validate.ParameterScope;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.AuxiliaryConverter;
import org.apache.calcite.sql2rel.DeduplicateCorrelateVariables;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.sql2rel.RelStructuredTypeFlattener;
import org.apache.calcite.sql2rel.SqlNodeToRexConverter;
import org.apache.calcite.sql2rel.SqlNodeToRexConverterImpl;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.calcite.sql2rel.SubQueryConverter;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.NumberUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public class SqlToRelConverter {
    protected static final Logger SQL2REL_LOGGER = CalciteTrace.getSqlToRelTracer();
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);
    public static final int DEFAULT_IN_SUB_QUERY_THRESHOLD = 20;
    @Deprecated
    public static final int DEFAULT_IN_SUBQUERY_THRESHOLD = 20;
    protected final SqlValidator validator;
    protected final RexBuilder rexBuilder;
    protected final Prepare.CatalogReader catalogReader;
    protected final RelOptCluster cluster;
    private SubQueryConverter subQueryConverter;
    protected final List<RelNode> leaves = new ArrayList<RelNode>();
    private final List<SqlDynamicParam> dynamicParamSqlNodes = new ArrayList<SqlDynamicParam>();
    private final SqlOperatorTable opTab;
    protected final RelDataTypeFactory typeFactory;
    private final SqlNodeToRexConverter exprConverter;
    private int explainParamCount;
    public final Config config;
    private final Map<CorrelationId, DeferredLookup> mapCorrelToDeferred = new HashMap<CorrelationId, DeferredLookup>();
    private final Deque<String> datasetStack = new ArrayDeque<String>();
    private final Map<SqlNode, RexNode> mapConvertedNonCorrSubqs = new HashMap<SqlNode, RexNode>();
    public final RelOptTable.ViewExpander viewExpander;

    @Deprecated
    public SqlToRelConverter(RelOptTable.ViewExpander viewExpander, SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptPlanner planner, RexBuilder rexBuilder, SqlRexConvertletTable convertletTable) {
        this(viewExpander, validator, catalogReader, RelOptCluster.create(planner, rexBuilder), convertletTable, Config.DEFAULT);
    }

    @Deprecated
    public SqlToRelConverter(RelOptTable.ViewExpander viewExpander, SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable) {
        this(viewExpander, validator, catalogReader, cluster, convertletTable, Config.DEFAULT);
    }

    public SqlToRelConverter(RelOptTable.ViewExpander viewExpander, SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable, Config config) {
        this.viewExpander = viewExpander;
        this.opTab = validator == null ? SqlStdOperatorTable.instance() : validator.getOperatorTable();
        this.validator = validator;
        this.catalogReader = catalogReader;
        this.subQueryConverter = new NoOpSubQueryConverter();
        this.rexBuilder = cluster.getRexBuilder();
        this.typeFactory = this.rexBuilder.getTypeFactory();
        this.cluster = (RelOptCluster)Preconditions.checkNotNull((Object)cluster);
        this.exprConverter = new SqlNodeToRexConverterImpl(convertletTable);
        this.explainParamCount = 0;
        this.config = new ConfigBuilder().withConfig(config).build();
    }

    public RelOptCluster getCluster() {
        return this.cluster;
    }

    public RexBuilder getRexBuilder() {
        return this.rexBuilder;
    }

    public int getDynamicParamCount() {
        return this.dynamicParamSqlNodes.size();
    }

    public RelDataType getDynamicParamType(int index) {
        SqlNode sqlNode = this.dynamicParamSqlNodes.get(index);
        if (sqlNode == null) {
            throw Util.needToImplement("dynamic param type inference");
        }
        return this.validator.getValidatedNodeType(sqlNode);
    }

    public int getDynamicParamCountInExplain(boolean increment) {
        int retVal = this.explainParamCount++;
        if (increment) {
            // empty if block
        }
        return retVal;
    }

    public Map<SqlNode, RexNode> getMapConvertedNonCorrSubqs() {
        return this.mapConvertedNonCorrSubqs;
    }

    public void addConvertedNonCorrSubqs(Map<SqlNode, RexNode> alreadyConvertedNonCorrSubqs) {
        this.mapConvertedNonCorrSubqs.putAll(alreadyConvertedNonCorrSubqs);
    }

    public void setSubQueryConverter(SubQueryConverter converter) {
        this.subQueryConverter = converter;
    }

    public void setDynamicParamCountInExplain(int explainParamCount) {
        assert (this.config.isExplain());
        this.explainParamCount = explainParamCount;
    }

    private void checkConvertedType(SqlNode query, RelNode result) {
        if (query.isA(SqlKind.DML)) {
            return;
        }
        List<RelDataTypeField> validatedFields = this.validator.getValidatedNodeType(query).getFieldList();
        RelDataType validatedRowType = this.validator.getTypeFactory().createStructType(Pair.right(validatedFields), SqlValidatorUtil.uniquify(Pair.left(validatedFields), this.catalogReader.nameMatcher().isCaseSensitive()));
        List<RelDataTypeField> convertedFields = result.getRowType().getFieldList().subList(0, validatedFields.size());
        RelDataType convertedRowType = this.validator.getTypeFactory().createStructType(convertedFields);
        if (!RelOptUtil.equal("validated row type", validatedRowType, "converted row type", convertedRowType, Litmus.IGNORE)) {
            throw new AssertionError((Object)("Conversion to relational algebra failed to preserve datatypes:\nvalidated type:\n" + validatedRowType.getFullTypeString() + "\nconverted type:\n" + convertedRowType.getFullTypeString() + "\nrel:\n" + RelOptUtil.toString(result)));
        }
    }

    public RelNode flattenTypes(RelNode rootRel, boolean restructure) {
        RelStructuredTypeFlattener typeFlattener = new RelStructuredTypeFlattener(this.rexBuilder, this.createToRelContext(), restructure);
        return typeFlattener.rewrite(rootRel);
    }

    public RelNode decorrelate(SqlNode query, RelNode rootRel) {
        if (!this.enableDecorrelation()) {
            return rootRel;
        }
        RelNode result = this.decorrelateQuery(rootRel);
        if (result != rootRel) {
            this.checkConvertedType(query, result);
        }
        return result;
    }

    public RelNode trimUnusedFields(boolean ordered, RelNode rootRel) {
        if (this.isTrimUnusedFields()) {
            RelFieldTrimmer trimmer = this.newFieldTrimmer();
            List<RelCollation> collations = rootRel.getTraitSet().getTraits(RelCollationTraitDef.INSTANCE);
            rootRel = trimmer.trim(rootRel);
            if (!(ordered || collations == null || collations.isEmpty() || collations.equals(ImmutableList.of((Object)RelCollations.EMPTY)))) {
                RelTraitSet traitSet = rootRel.getTraitSet().replace(RelCollationTraitDef.INSTANCE, collations);
                rootRel = rootRel.copy(traitSet, rootRel.getInputs());
            }
            if (SQL2REL_LOGGER.isDebugEnabled()) {
                SQL2REL_LOGGER.debug(RelOptUtil.dumpPlan("Plan after trimming unused fields", rootRel, SqlExplainFormat.TEXT, SqlExplainLevel.EXPPLAN_ATTRIBUTES));
            }
        }
        return rootRel;
    }

    protected RelFieldTrimmer newFieldTrimmer() {
        RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(this.cluster, null);
        return new RelFieldTrimmer(this.validator, relBuilder);
    }

    public RelRoot convertQuery(SqlNode query, boolean needsValidation, boolean top) {
        if (needsValidation) {
            query = this.validator.validate(query);
        }
        RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of(this.cluster.getMetadataProvider()));
        RelNode result = this.convertQueryRecursive((SqlNode)query, (boolean)top, null).rel;
        if (top && SqlToRelConverter.isStream(query)) {
            result = new LogicalDelta(this.cluster, result.getTraitSet(), result);
        }
        RelCollation collation = RelCollations.EMPTY;
        if (!query.isA(SqlKind.DML) && SqlToRelConverter.isOrdered(query)) {
            collation = this.requiredCollation(result);
        }
        this.checkConvertedType(query, result);
        if (SQL2REL_LOGGER.isDebugEnabled()) {
            SQL2REL_LOGGER.debug(RelOptUtil.dumpPlan("Plan after converting SqlNode to RelNode", result, SqlExplainFormat.TEXT, SqlExplainLevel.EXPPLAN_ATTRIBUTES));
        }
        RelDataType validatedRowType = this.validator.getValidatedNodeType(query);
        return RelRoot.of(result, validatedRowType, query.getKind()).withCollation(collation);
    }

    private static boolean isStream(SqlNode query) {
        return query instanceof SqlSelect && ((SqlSelect)query).isKeywordPresent(SqlSelectKeyword.STREAM);
    }

    public static boolean isOrdered(SqlNode query) {
        switch (query.getKind()) {
            case SELECT: {
                return ((SqlSelect)query).getOrderList() != null && ((SqlSelect)query).getOrderList().size() > 0;
            }
            case WITH: {
                return SqlToRelConverter.isOrdered(((SqlWith)query).body);
            }
            case ORDER_BY: {
                return ((SqlOrderBy)query).orderList.size() > 0;
            }
        }
        return false;
    }

    private RelCollation requiredCollation(RelNode r) {
        if (r instanceof Sort) {
            return ((Sort)r).collation;
        }
        if (r instanceof Project) {
            return this.requiredCollation(((Project)r).getInput());
        }
        if (r instanceof Delta) {
            return this.requiredCollation(((Delta)r).getInput());
        }
        throw new AssertionError();
    }

    public RelNode convertSelect(SqlSelect select, boolean top) {
        SqlValidatorScope selectScope = this.validator.getWhereScope(select);
        Blackboard bb = this.createBlackboard(selectScope, null, top);
        this.convertSelectImpl(bb, select);
        return bb.root;
    }

    protected Blackboard createBlackboard(SqlValidatorScope scope, Map<String, RexNode> nameToNodeMap, boolean top) {
        return new Blackboard(scope, nameToNodeMap, top);
    }

    protected void convertSelectImpl(Blackboard bb, SqlSelect select) {
        this.convertFrom(bb, select.getFrom());
        this.convertWhere(bb, select.getWhere());
        ArrayList<SqlNode> orderExprList = new ArrayList<SqlNode>();
        ArrayList<RelFieldCollation> collationList = new ArrayList<RelFieldCollation>();
        this.gatherOrderExprs(bb, select, select.getOrderList(), orderExprList, collationList);
        RelCollation collation = this.cluster.traitSet().canonize(RelCollations.of(collationList));
        if (this.validator.isAggregate(select)) {
            this.convertAgg(bb, select, orderExprList);
        } else {
            this.convertSelectList(bb, select, orderExprList);
        }
        if (select.isDistinct()) {
            this.distinctify(bb, true);
        }
        this.convertOrder(select, bb, collation, orderExprList, select.getOffset(), select.getFetch());
        bb.setRoot(bb.root, true);
    }

    private void distinctify(Blackboard bb, boolean checkForDupExprs) {
        RelNode rel = bb.root;
        if (checkForDupExprs && rel instanceof LogicalProject) {
            LogicalProject project = (LogicalProject)rel;
            List<RexNode> projectExprs = project.getProjects();
            ArrayList<Integer> origins = new ArrayList<Integer>();
            int dupCount = 0;
            for (int i = 0; i < projectExprs.size(); ++i) {
                int x = this.findExpr(projectExprs.get(i), projectExprs, i);
                if (x >= 0) {
                    origins.add(x);
                    ++dupCount;
                    continue;
                }
                origins.add(i);
            }
            if (dupCount == 0) {
                this.distinctify(bb, false);
                return;
            }
            HashMap squished = Maps.newHashMap();
            List<RelDataTypeField> fields = rel.getRowType().getFieldList();
            ArrayList newProjects = Lists.newArrayList();
            for (int i = 0; i < fields.size(); ++i) {
                if ((Integer)origins.get(i) != i) continue;
                squished.put(i, newProjects.size());
                newProjects.add(RexInputRef.of2(i, fields));
            }
            bb.root = rel = LogicalProject.create(rel, Pair.left(newProjects), Pair.right(newProjects));
            this.distinctify(bb, false);
            rel = bb.root;
            ArrayList undoProjects = Lists.newArrayList();
            for (int i = 0; i < fields.size(); ++i) {
                int origin = (Integer)origins.get(i);
                RelDataTypeField field = fields.get(i);
                undoProjects.add(Pair.of(new RexInputRef((Integer)squished.get(origin), field.getType()), field.getName()));
            }
            rel = LogicalProject.create(rel, Pair.left(undoProjects), Pair.right(undoProjects));
            bb.setRoot(rel, false);
            return;
        }
        ImmutableBitSet groupSet = ImmutableBitSet.range(rel.getRowType().getFieldCount());
        rel = this.createAggregate(bb, false, groupSet, (ImmutableList<ImmutableBitSet>)ImmutableList.of((Object)groupSet), (List<AggregateCall>)ImmutableList.of());
        bb.setRoot(rel, false);
    }

    private int findExpr(RexNode seek, List<RexNode> exprs, int count) {
        for (int i = 0; i < count; ++i) {
            RexNode expr = exprs.get(i);
            if (!expr.toString().equals(seek.toString())) continue;
            return i;
        }
        return -1;
    }

    protected void convertOrder(SqlSelect select, Blackboard bb, RelCollation collation, List<SqlNode> orderExprList, SqlNode offset, SqlNode fetch) {
        if (select.getOrderList() == null || select.getOrderList().getList().isEmpty()) {
            assert (collation.getFieldCollations().isEmpty());
            if ((offset == null || ((SqlLiteral)offset).bigDecimalValue().equals(BigDecimal.ZERO)) && fetch == null) {
                return;
            }
        }
        bb.setRoot(LogicalSort.create(bb.root, collation, offset == null ? null : this.convertExpression(offset), fetch == null ? null : this.convertExpression(fetch)), false);
        if (orderExprList.size() > 0 && !bb.top) {
            ArrayList<RexInputRef> exprs = new ArrayList<RexInputRef>();
            RelDataType rowType = bb.root.getRowType();
            int fieldCount = rowType.getFieldCount() - orderExprList.size();
            for (int i = 0; i < fieldCount; ++i) {
                exprs.add(this.rexBuilder.makeInputRef(bb.root, i));
            }
            bb.setRoot(LogicalProject.create(bb.root, exprs, rowType.getFieldNames().subList(0, fieldCount)), false);
        }
    }

    private static boolean containsInOperator(SqlNode node) {
        try {
            SqlBasicVisitor<Void> visitor = new SqlBasicVisitor<Void>(){

                @Override
                public Void visit(SqlCall call) {
                    if (call.getOperator() instanceof SqlInOperator) {
                        throw new Util.FoundOne(call);
                    }
                    return (Void)super.visit(call);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    private static SqlNode pushDownNotForIn(SqlValidatorScope scope, SqlNode sqlNode) {
        if (sqlNode instanceof SqlCall && SqlToRelConverter.containsInOperator(sqlNode)) {
            SqlCall sqlCall = (SqlCall)sqlNode;
            if (sqlCall.getOperator() == SqlStdOperatorTable.AND || sqlCall.getOperator() == SqlStdOperatorTable.OR) {
                SqlNode[] sqlOperands = ((SqlBasicCall)sqlCall).operands;
                for (int i = 0; i < sqlOperands.length; ++i) {
                    sqlOperands[i] = SqlToRelConverter.pushDownNotForIn(scope, sqlOperands[i]);
                }
                return SqlToRelConverter.reg(scope, sqlNode);
            }
            if (sqlCall.getOperator() == SqlStdOperatorTable.NOT) {
                Object childNode = sqlCall.operand(0);
                assert (childNode instanceof SqlCall);
                SqlBasicCall childSqlCall = (SqlBasicCall)childNode;
                if (childSqlCall.getOperator() == SqlStdOperatorTable.AND) {
                    int i;
                    SqlNode[] andOperands = childSqlCall.getOperands();
                    SqlNode[] orOperands = new SqlNode[andOperands.length];
                    for (i = 0; i < orOperands.length; ++i) {
                        orOperands[i] = SqlToRelConverter.reg(scope, SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, andOperands[i]));
                    }
                    for (i = 0; i < orOperands.length; ++i) {
                        orOperands[i] = SqlToRelConverter.pushDownNotForIn(scope, orOperands[i]);
                    }
                    return SqlToRelConverter.reg(scope, SqlStdOperatorTable.OR.createCall(SqlParserPos.ZERO, orOperands[0], orOperands[1]));
                }
                if (childSqlCall.getOperator() == SqlStdOperatorTable.OR) {
                    int i;
                    SqlNode[] orOperands = childSqlCall.getOperands();
                    SqlNode[] andOperands = new SqlNode[orOperands.length];
                    for (i = 0; i < andOperands.length; ++i) {
                        andOperands[i] = SqlToRelConverter.reg(scope, SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, orOperands[i]));
                    }
                    for (i = 0; i < andOperands.length; ++i) {
                        andOperands[i] = SqlToRelConverter.pushDownNotForIn(scope, andOperands[i]);
                    }
                    return SqlToRelConverter.reg(scope, SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, andOperands[0], andOperands[1]));
                }
                if (childSqlCall.getOperator() == SqlStdOperatorTable.NOT) {
                    SqlNode[] notOperands = childSqlCall.getOperands();
                    assert (notOperands.length == 1);
                    return SqlToRelConverter.pushDownNotForIn(scope, notOperands[0]);
                }
                if (childSqlCall.getOperator() instanceof SqlInOperator) {
                    SqlNode[] inOperands = childSqlCall.getOperands();
                    SqlInOperator inOp = (SqlInOperator)childSqlCall.getOperator();
                    if (inOp.isNotIn()) {
                        return SqlToRelConverter.reg(scope, SqlStdOperatorTable.IN.createCall(SqlParserPos.ZERO, inOperands[0], inOperands[1]));
                    }
                    return SqlToRelConverter.reg(scope, SqlStdOperatorTable.NOT_IN.createCall(SqlParserPos.ZERO, inOperands[0], inOperands[1]));
                }
                return sqlNode;
            }
            return sqlNode;
        }
        return sqlNode;
    }

    private static SqlNode reg(SqlValidatorScope scope, SqlNode e) {
        scope.getValidator().deriveType(scope, e);
        return e;
    }

    private void convertWhere(Blackboard bb, SqlNode where) {
        RelNode r;
        if (where == null) {
            return;
        }
        SqlNode newWhere = SqlToRelConverter.pushDownNotForIn(bb.scope, where);
        this.replaceSubQueries(bb, newWhere, RelOptUtil.Logic.UNKNOWN_AS_FALSE);
        RexNode convertedWhere = bb.convertExpression(newWhere);
        if (convertedWhere.isAlwaysTrue()) {
            return;
        }
        RelFactories.FilterFactory factory = RelFactories.DEFAULT_FILTER_FACTORY;
        RelNode filter = factory.createFilter(bb.root, convertedWhere);
        CorrelationUse p = this.getCorrelationUse(bb, filter);
        if (p != null) {
            assert (p.r instanceof Filter);
            Filter f = (Filter)p.r;
            r = LogicalFilter.create(f.getInput(), f.getCondition(), (ImmutableSet<CorrelationId>)ImmutableSet.of((Object)p.id));
        } else {
            r = filter;
        }
        bb.setRoot(r, false);
    }

    private void replaceSubQueries(Blackboard bb, SqlNode expr, RelOptUtil.Logic logic) {
        this.findSubQueries(bb, expr, logic, false);
        for (SubQuery node : bb.subQueryList) {
            this.substituteSubQuery(bb, node);
        }
    }

    private void substituteSubQuery(Blackboard bb, SubQuery subQuery) {
        RexNode expr = subQuery.expr;
        if (expr != null) {
            return;
        }
        switch (subQuery.node.getKind()) {
            case CURSOR: {
                this.convertCursor(bb, subQuery);
                return;
            }
            case MULTISET_QUERY_CONSTRUCTOR: 
            case MULTISET_VALUE_CONSTRUCTOR: 
            case ARRAY_QUERY_CONSTRUCTOR: {
                RelNode rel = this.convertMultisets((List<SqlNode>)ImmutableList.of((Object)subQuery.node), bb);
                subQuery.expr = bb.register(rel, JoinRelType.INNER);
                return;
            }
            case IN: {
                SqlNodeList valueList;
                ArrayList leftKeys;
                SqlBasicCall call = (SqlBasicCall)subQuery.node;
                Object query = call.operand(1);
                if (!this.config.isExpand() && !(query instanceof SqlNodeList)) {
                    return;
                }
                Object leftKeyNode = call.operand(0);
                switch (((SqlNode)leftKeyNode).getKind()) {
                    case ROW: {
                        leftKeys = Lists.newArrayList();
                        for (SqlNode sqlExpr : ((SqlBasicCall)leftKeyNode).getOperandList()) {
                            leftKeys.add(bb.convertExpression(sqlExpr));
                        }
                        break;
                    }
                    default: {
                        leftKeys = ImmutableList.of((Object)bb.convertExpression((SqlNode)leftKeyNode));
                    }
                }
                boolean notIn = ((SqlInOperator)call.getOperator()).isNotIn();
                if (query instanceof SqlNodeList && !SqlToRelConverter.containsNullLiteral(valueList = (SqlNodeList)query) && valueList.size() < this.config.getInSubQueryThreshold()) {
                    subQuery.expr = this.convertInToOr(bb, leftKeys, valueList, notIn);
                    return;
                }
                RelDataType targetRowType = SqlTypeUtil.promoteToRowType(this.typeFactory, this.validator.getValidatedNodeType((SqlNode)leftKeyNode), null);
                RelOptUtil.Exists converted = this.convertExists((SqlNode)query, RelOptUtil.SubQueryType.IN, subQuery.logic, notIn, targetRowType);
                if (converted.indicator) {
                    RelDataType longType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
                    RelNode seek = converted.r.getInput(0);
                    int keyCount = leftKeys.size();
                    List<Integer> args = ImmutableIntList.range(0, keyCount);
                    LogicalAggregate aggregate = LogicalAggregate.create(seek, false, ImmutableBitSet.of(), null, (List<AggregateCall>)ImmutableList.of((Object)AggregateCall.create(SqlStdOperatorTable.COUNT, false, (List<Integer>)ImmutableList.of(), -1, longType, null), (Object)AggregateCall.create(SqlStdOperatorTable.COUNT, false, args, -1, longType, null)));
                    LogicalJoin join = LogicalJoin.create(bb.root, (RelNode)aggregate, (RexNode)this.rexBuilder.makeLiteral(true), (Set<CorrelationId>)ImmutableSet.of(), JoinRelType.INNER);
                    bb.setRoot(join, false);
                }
                RexNode rex = bb.register(converted.r, converted.outerJoin ? JoinRelType.LEFT : JoinRelType.INNER, leftKeys);
                RelOptUtil.Logic logic = subQuery.logic;
                switch (logic) {
                    case TRUE_FALSE_UNKNOWN: 
                    case UNKNOWN_AS_TRUE: {
                        if (converted.indicator) break;
                        logic = RelOptUtil.Logic.TRUE_FALSE;
                    }
                }
                subQuery.expr = this.translateIn(logic, bb.root, rex);
                if (notIn) {
                    subQuery.expr = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, subQuery.expr);
                }
                return;
            }
            case EXISTS: {
                SqlBasicCall call = (SqlBasicCall)subQuery.node;
                Object query = call.operand(0);
                if (!this.config.isExpand()) {
                    return;
                }
                RelOptUtil.Exists converted = this.convertExists((SqlNode)query, RelOptUtil.SubQueryType.EXISTS, subQuery.logic, true, null);
                assert (!converted.indicator);
                if (this.convertNonCorrelatedSubQuery(subQuery, bb, converted.r, true)) {
                    return;
                }
                subQuery.expr = bb.register(converted.r, JoinRelType.LEFT);
                return;
            }
            case SCALAR_QUERY: {
                if (!this.config.isExpand()) {
                    return;
                }
                SqlBasicCall call = (SqlBasicCall)subQuery.node;
                Object query = call.operand(0);
                RelOptUtil.Exists converted = this.convertExists((SqlNode)query, RelOptUtil.SubQueryType.SCALAR, subQuery.logic, true, null);
                assert (!converted.indicator);
                if (this.convertNonCorrelatedSubQuery(subQuery, bb, converted.r, false)) {
                    return;
                }
                RelNode rel = this.convertToSingleValueSubq((SqlNode)query, converted.r);
                subQuery.expr = bb.register(rel, JoinRelType.LEFT);
                return;
            }
            case SELECT: {
                RelOptUtil.Exists converted = this.convertExists(subQuery.node, RelOptUtil.SubQueryType.SCALAR, subQuery.logic, true, null);
                assert (!converted.indicator);
                subQuery.expr = bb.register(converted.r, JoinRelType.LEFT);
                return;
            }
        }
        throw new AssertionError((Object)("unexpected kind of sub-query: " + subQuery.node));
    }

    private RexNode translateIn(RelOptUtil.Logic logic, RelNode root, RexNode rex) {
        switch (logic) {
            case TRUE: {
                return this.rexBuilder.makeLiteral(true);
            }
            case TRUE_FALSE: 
            case UNKNOWN_AS_FALSE: {
                assert (rex instanceof RexRangeRef);
                int fieldCount = rex.getType().getFieldCount();
                RexNode rexNode = this.rexBuilder.makeFieldAccess(rex, fieldCount - 1);
                rexNode = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, rexNode);
                int k = (fieldCount - 1) / 2;
                for (int i = 0; i < k; ++i) {
                    rexNode = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, rexNode, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, this.rexBuilder.makeFieldAccess(rex, i)));
                }
                return rexNode;
            }
            case TRUE_FALSE_UNKNOWN: 
            case UNKNOWN_AS_TRUE: {
                Join join = (Join)root;
                Project left = (Project)join.getLeft();
                RelNode leftLeft = ((Join)left.getInput()).getLeft();
                int leftLeftCount = leftLeft.getRowType().getFieldCount();
                RelDataType longType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
                RexInputRef cRef = this.rexBuilder.makeInputRef(root, leftLeftCount);
                RexInputRef ckRef = this.rexBuilder.makeInputRef(root, leftLeftCount + 1);
                RexInputRef iRef = this.rexBuilder.makeInputRef(root, root.getRowType().getFieldCount() - 1);
                RexLiteral zero = this.rexBuilder.makeExactLiteral(BigDecimal.ZERO, longType);
                RexLiteral trueLiteral = this.rexBuilder.makeLiteral(true);
                RexLiteral falseLiteral = this.rexBuilder.makeLiteral(false);
                RexLiteral unknownLiteral = this.rexBuilder.makeNullLiteral(trueLiteral.getType());
                ImmutableList.Builder args = ImmutableList.builder();
                args.add((Object[])new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, cRef, zero), falseLiteral, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, iRef), trueLiteral});
                JoinInfo joinInfo = join.analyzeCondition();
                for (int leftKey : joinInfo.leftKeys) {
                    RexInputRef kRef = this.rexBuilder.makeInputRef(root, leftKey);
                    args.add((Object[])new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, kRef), unknownLiteral});
                }
                args.add((Object[])new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, ckRef, cRef), unknownLiteral, falseLiteral});
                return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, (List<? extends RexNode>)args.build());
            }
        }
        throw new AssertionError((Object)logic);
    }

    private static boolean containsNullLiteral(SqlNodeList valueList) {
        for (SqlNode node : valueList.getList()) {
            SqlLiteral lit;
            if (!(node instanceof SqlLiteral) || (lit = (SqlLiteral)node).getValue() != null) continue;
            return true;
        }
        return false;
    }

    private boolean convertNonCorrelatedSubQuery(SubQuery subQuery, Blackboard bb, RelNode converted, boolean isExists) {
        SqlBasicCall call = (SqlBasicCall)subQuery.node;
        if (this.subQueryConverter.canConvertSubQuery() && this.isSubQueryNonCorrelated(converted, bb)) {
            RexNode constExpr = this.mapConvertedNonCorrSubqs.get(call);
            if (constExpr == null) {
                constExpr = this.subQueryConverter.convertSubQuery(call, this, isExists, this.config.isExplain());
            }
            if (constExpr != null) {
                subQuery.expr = constExpr;
                this.mapConvertedNonCorrSubqs.put(call, constExpr);
                return true;
            }
        }
        return false;
    }

    public RelNode convertToSingleValueSubq(SqlNode query, RelNode plan) {
        SqlCall exprCall;
        if (query instanceof SqlSelect) {
            SqlSelect select = (SqlSelect)query;
            SqlNodeList selectList = select.getSelectList();
            SqlNodeList groupList = select.getGroup();
            if (selectList.size() == 1 && (groupList == null || groupList.size() == 0)) {
                SqlNumericLiteral limitNum;
                SqlCall selectExprCall;
                SqlNode selectExpr = selectList.get(0);
                if (selectExpr instanceof SqlCall && Util.isSingleValue(selectExprCall = (SqlCall)selectExpr)) {
                    return plan;
                }
                if (select.getFetch() != null && select.getFetch() instanceof SqlNumericLiteral && ((BigDecimal)(limitNum = (SqlNumericLiteral)select.getFetch()).getValue()).intValue() < 2) {
                    return plan;
                }
            }
        } else if (query instanceof SqlCall && (exprCall = (SqlCall)query).getOperator() instanceof SqlValuesOperator && Util.isSingleValue(exprCall)) {
            return plan;
        }
        return RelOptUtil.createSingleValueAggRel(this.cluster, plan);
    }

    private RexNode convertInToOr(final Blackboard bb, List<RexNode> leftKeys, SqlNodeList valuesList, boolean isNotIn) {
        ArrayList<RexNode> comparisons = new ArrayList<RexNode>();
        for (SqlNode rightVals : valuesList) {
            RexNode rexComparison;
            if (leftKeys.size() == 1) {
                rexComparison = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, leftKeys.get(0), this.ensureSqlType(leftKeys.get(0).getType(), bb.convertExpression(rightVals)));
            } else {
                assert (rightVals instanceof SqlCall);
                SqlBasicCall call = (SqlBasicCall)rightVals;
                assert (call.getOperator() instanceof SqlRowOperator && call.operandCount() == leftKeys.size());
                rexComparison = RexUtil.composeConjunction(this.rexBuilder, Iterables.transform(Pair.zip(leftKeys, call.getOperandList()), (Function)new Function<Pair<RexNode, SqlNode>, RexNode>(){

                    public RexNode apply(Pair<RexNode, SqlNode> pair) {
                        return SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, (RexNode)pair.left, SqlToRelConverter.this.ensureSqlType(((RexNode)pair.left).getType(), bb.convertExpression((SqlNode)pair.right)));
                    }
                }), false);
            }
            comparisons.add(rexComparison);
        }
        RexNode result = RexUtil.composeDisjunction(this.rexBuilder, comparisons, true);
        assert (result != null);
        if (isNotIn) {
            result = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, result);
        }
        return result;
    }

    private RexNode ensureSqlType(RelDataType type, RexNode node) {
        if (type.getSqlTypeName() == node.getType().getSqlTypeName() || type.getSqlTypeName() == SqlTypeName.VARCHAR && node.getType().getSqlTypeName() == SqlTypeName.CHAR) {
            return node;
        }
        return this.rexBuilder.ensureType(type, node, true);
    }

    @Deprecated
    protected int getInSubqueryThreshold() {
        return this.config.getInSubQueryThreshold();
    }

    private RelOptUtil.Exists convertExists(SqlNode seek, RelOptUtil.SubQueryType subQueryType, RelOptUtil.Logic logic, boolean notIn, RelDataType targetDataType) {
        SqlValidatorScope seekScope = seek instanceof SqlSelect ? this.validator.getSelectScope((SqlSelect)seek) : null;
        Blackboard seekBb = this.createBlackboard(seekScope, null, false);
        RelNode seekRel = this.convertQueryOrInList(seekBb, seek, targetDataType);
        return RelOptUtil.createExistsPlan(seekRel, subQueryType, logic, notIn);
    }

    private RelNode convertQueryOrInList(Blackboard bb, SqlNode seek, RelDataType targetRowType) {
        if (seek instanceof SqlNodeList) {
            return this.convertRowValues(bb, seek, ((SqlNodeList)seek).getList(), false, targetRowType);
        }
        return this.convertQueryRecursive(seek, false, null).project();
    }

    private RelNode convertRowValues(Blackboard bb, SqlNode rowList, Collection<SqlNode> rows, boolean allowLiteralsOnly, RelDataType targetRowType) {
        AbstractRelNode resultRel;
        ImmutableList.Builder tupleList = ImmutableList.builder();
        RelDataType rowType = targetRowType != null ? targetRowType : SqlTypeUtil.promoteToRowType(this.typeFactory, this.validator.getValidatedNodeType(rowList), null);
        ArrayList<RelNode> unionInputs = new ArrayList<RelNode>();
        for (SqlNode node : rows) {
            SqlBasicCall call;
            if (this.isRowConstructor(node)) {
                call = (SqlBasicCall)node;
                ImmutableList.Builder tuple = ImmutableList.builder();
                for (Ord operand : Ord.zip((Object[])call.operands)) {
                    RexLiteral rexLiteral = this.convertLiteralInValuesList((SqlNode)operand.e, bb, rowType, operand.i);
                    if (rexLiteral == null && allowLiteralsOnly) {
                        return null;
                    }
                    if (rexLiteral == null || !this.config.isCreateValuesRel()) {
                        tuple = null;
                        break;
                    }
                    tuple.add((Object)rexLiteral);
                }
                if (tuple != null) {
                    tupleList.add((Object)tuple.build());
                    continue;
                }
            } else {
                RexLiteral rexLiteral = this.convertLiteralInValuesList(node, bb, rowType, 0);
                if (rexLiteral != null && this.config.isCreateValuesRel()) {
                    tupleList.add((Object)ImmutableList.of((Object)rexLiteral));
                    continue;
                }
                if (rexLiteral == null && allowLiteralsOnly) {
                    return null;
                }
                call = (SqlBasicCall)SqlStdOperatorTable.ROW.createCall(SqlParserPos.ZERO, node);
            }
            unionInputs.add(this.convertRowConstructor(bb, call));
        }
        LogicalValues values = LogicalValues.create(this.cluster, rowType, (ImmutableList<ImmutableList<RexLiteral>>)tupleList.build());
        if (unionInputs.isEmpty()) {
            resultRel = values;
        } else {
            if (!values.getTuples().isEmpty()) {
                unionInputs.add(values);
            }
            resultRel = LogicalUnion.create(unionInputs, true);
        }
        this.leaves.add(resultRel);
        return resultRel;
    }

    private RexLiteral convertLiteralInValuesList(SqlNode sqlNode, Blackboard bb, RelDataType rowType, int iField) {
        if (!(sqlNode instanceof SqlLiteral)) {
            return null;
        }
        RelDataTypeField field = rowType.getFieldList().get(iField);
        RelDataType type = field.getType();
        if (type.isStruct()) {
            return null;
        }
        RexNode literalExpr = this.exprConverter.convertLiteral(bb, (SqlLiteral)sqlNode);
        if (!(literalExpr instanceof RexLiteral)) {
            assert (literalExpr.isA(SqlKind.CAST));
            RexNode child = ((RexCall)literalExpr).getOperands().get(0);
            assert (RexLiteral.isNullLiteral(child));
            return (RexLiteral)child;
        }
        RexLiteral literal = (RexLiteral)literalExpr;
        Comparable value = literal.getValue();
        if (SqlTypeUtil.isExactNumeric(type) && SqlTypeUtil.hasScale(type)) {
            BigDecimal roundedValue = NumberUtil.rescaleBigDecimal((BigDecimal)value, type.getScale());
            return this.rexBuilder.makeExactLiteral(roundedValue, type);
        }
        if (value instanceof NlsString && type.getSqlTypeName() == SqlTypeName.CHAR) {
            NlsString unpadded = (NlsString)value;
            return this.rexBuilder.makeCharLiteral(new NlsString(Spaces.padRight((String)unpadded.getValue(), (int)type.getPrecision()), unpadded.getCharsetName(), unpadded.getCollation()));
        }
        return literal;
    }

    private boolean isRowConstructor(SqlNode node) {
        if (node.getKind() != SqlKind.ROW) {
            return false;
        }
        SqlCall call = (SqlCall)node;
        return call.getOperator().getName().equalsIgnoreCase("row");
    }

    private void findSubQueries(Blackboard bb, SqlNode node, RelOptUtil.Logic logic, boolean registerOnlyScalarSubQueries) {
        SqlKind kind = node.getKind();
        switch (kind) {
            case SELECT: 
            case CURSOR: 
            case MULTISET_QUERY_CONSTRUCTOR: 
            case MULTISET_VALUE_CONSTRUCTOR: 
            case ARRAY_QUERY_CONSTRUCTOR: 
            case EXISTS: 
            case SCALAR_QUERY: {
                if (!registerOnlyScalarSubQueries || kind == SqlKind.SCALAR_QUERY) {
                    bb.registerSubQuery(node, RelOptUtil.Logic.TRUE_FALSE);
                }
                return;
            }
            case IN: {
                if (((SqlCall)node).getOperator() != SqlStdOperatorTable.NOT_IN) break;
                logic = logic.negate();
                break;
            }
            case NOT: {
                logic = logic.negate();
            }
        }
        if (node instanceof SqlCall) {
            for (SqlNode operand : ((SqlCall)node).getOperandList()) {
                if (operand == null) continue;
                this.findSubQueries(bb, operand, logic, kind == SqlKind.IN || registerOnlyScalarSubQueries);
            }
        } else if (node instanceof SqlNodeList) {
            for (SqlNode child : (SqlNodeList)node) {
                this.findSubQueries(bb, child, logic, kind == SqlKind.IN || registerOnlyScalarSubQueries);
            }
        }
        if (kind == SqlKind.IN) {
            switch (logic) {
                case TRUE_FALSE_UNKNOWN: {
                    if (!this.validator.getValidatedNodeType(node).isNullable()) break;
                    break;
                }
                case UNKNOWN_AS_FALSE: {
                    logic = RelOptUtil.Logic.TRUE;
                }
            }
            bb.registerSubQuery(node, logic);
        }
    }

    public RexNode convertExpression(SqlNode node) {
        Map<String, RelDataType> nameToTypeMap = Collections.emptyMap();
        ParameterScope scope = new ParameterScope((SqlValidatorImpl)this.validator, nameToTypeMap);
        Blackboard bb = this.createBlackboard(scope, null, false);
        return bb.convertExpression(node);
    }

    public RexNode convertExpression(SqlNode node, Map<String, RexNode> nameToNodeMap) {
        HashMap<String, RelDataType> nameToTypeMap = new HashMap<String, RelDataType>();
        for (Map.Entry<String, RexNode> entry : nameToNodeMap.entrySet()) {
            nameToTypeMap.put(entry.getKey(), entry.getValue().getType());
        }
        ParameterScope scope = new ParameterScope((SqlValidatorImpl)this.validator, nameToTypeMap);
        Blackboard bb = this.createBlackboard(scope, nameToNodeMap, false);
        return bb.convertExpression(node);
    }

    protected RexNode convertExtendedExpression(SqlNode node, Blackboard bb) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RexNode convertOver(Blackboard bb, SqlNode node) {
        SqlCall call = (SqlCall)node;
        SqlCall aggCall = (SqlCall)call.operand(0);
        Object windowOrRef = call.operand(1);
        SqlWindow window = this.validator.resolveWindow((SqlNode)windowOrRef, bb.scope, true);
        if (aggCall.getKind() == SqlKind.ROW_NUMBER) {
            window.setLowerBound(SqlWindow.createUnboundedPreceding(SqlParserPos.ZERO));
            window.setUpperBound(SqlWindow.createCurrentRow(SqlParserPos.ZERO));
            window.setRows(SqlLiteral.createBoolean(true, SqlParserPos.ZERO));
        }
        SqlNodeList partitionList = window.getPartitionList();
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        for (SqlNode partition : partitionList) {
            partitionKeys.add((Object)bb.convertExpression(partition));
        }
        RexNode lowerBound = bb.convertExpression(window.getLowerBound());
        RexNode upperBound = bb.convertExpression(window.getUpperBound());
        SqlNodeList orderList = window.getOrderList();
        if (orderList.size() == 0 && !window.isRows() && (orderList = bb.scope.getOrderList()) == null) {
            throw new AssertionError((Object)"Relation should have sort key for implicit ORDER BY");
        }
        ImmutableList.Builder orderKeys = ImmutableList.builder();
        EnumSet<SqlKind> flags = EnumSet.noneOf(SqlKind.class);
        for (SqlNode order : orderList) {
            flags.clear();
            RexNode e = bb.convertSortExpression(order, flags);
            orderKeys.add((Object)new RexFieldCollation(e, (Set<SqlKind>)flags));
        }
        try {
            RexNode overNode;
            Preconditions.checkArgument((bb.window == null ? 1 : 0) != 0, (Object)"already in window agg mode");
            bb.window = window;
            RexNode rexAgg = this.exprConverter.convertCall(bb, aggCall);
            rexAgg = this.rexBuilder.ensureType(this.validator.getValidatedNodeType(call), rexAgg, false);
            boolean isDistinct = false;
            if (aggCall.getFunctionQuantifier() != null && aggCall.getFunctionQuantifier().getValue().equals((Object)SqlSelectKeyword.DISTINCT)) {
                isDistinct = true;
            }
            HistogramShuttle visitor = new HistogramShuttle((List<RexNode>)partitionKeys.build(), (ImmutableList<RexFieldCollation>)orderKeys.build(), RexWindowBound.create(window.getLowerBound(), lowerBound), RexWindowBound.create(window.getUpperBound(), upperBound), window, isDistinct);
            RexNode rexNode = overNode = rexAgg.accept(visitor);
            return rexNode;
        }
        finally {
            bb.window = null;
        }
    }

    protected void convertFrom(Blackboard bb, SqlNode from) {
        if (from == null) {
            bb.setRoot(LogicalValues.createOneRow(this.cluster), false);
            return;
        }
        switch (from.getKind()) {
            case MATCH_RECOGNIZE: {
                this.convertMatchRecognize(bb, (SqlCall)from);
                return;
            }
            case AS: {
                this.convertFrom(bb, (SqlNode)((SqlCall)from).operand(0));
                return;
            }
            case WITH_ITEM: {
                this.convertFrom(bb, ((SqlWithItem)from).query);
                return;
            }
            case WITH: {
                this.convertFrom(bb, ((SqlWith)from).body);
                return;
            }
            case TABLESAMPLE: {
                SqlNode[] operands = ((SqlBasicCall)from).getOperands();
                SqlSampleSpec sampleSpec = SqlLiteral.sampleValue(operands[1]);
                if (sampleSpec instanceof SqlSampleSpec.SqlSubstitutionSampleSpec) {
                    String sampleName = ((SqlSampleSpec.SqlSubstitutionSampleSpec)sampleSpec).getName();
                    this.datasetStack.push(sampleName);
                    this.convertFrom(bb, operands[0]);
                    this.datasetStack.pop();
                } else if (sampleSpec instanceof SqlSampleSpec.SqlTableSampleSpec) {
                    SqlSampleSpec.SqlTableSampleSpec tableSampleSpec = (SqlSampleSpec.SqlTableSampleSpec)sampleSpec;
                    this.convertFrom(bb, operands[0]);
                    RelOptSamplingParameters params = new RelOptSamplingParameters(tableSampleSpec.isBernoulli(), tableSampleSpec.getSamplePercentage(), tableSampleSpec.isRepeatable(), tableSampleSpec.getRepeatableSeed());
                    bb.setRoot(new Sample(this.cluster, bb.root, params), false);
                } else {
                    throw new AssertionError((Object)("unknown TABLESAMPLE type: " + sampleSpec));
                }
                return;
            }
            case IDENTIFIER: {
                this.convertIdentifier(bb, (SqlIdentifier)from, null);
                return;
            }
            case EXTEND: {
                SqlCall call = (SqlCall)from;
                SqlIdentifier id = (SqlIdentifier)call.getOperandList().get(0);
                SqlNodeList extendedColumns = (SqlNodeList)call.getOperandList().get(1);
                this.convertIdentifier(bb, id, extendedColumns);
                return;
            }
            case JOIN: {
                RexNode conditionExp;
                SqlJoin join = (SqlJoin)from;
                SqlValidatorScope scope = this.validator.getJoinScope(from);
                Blackboard fromBlackboard = this.createBlackboard(scope, null, false);
                SqlNode left = join.getLeft();
                SqlNode right = join.getRight();
                boolean isNatural = join.isNatural();
                JoinType joinType = join.getJoinType();
                SqlValidatorScope leftScope = Util.first(this.validator.getJoinScope(left), ((DelegatingScope)bb.scope).getParent());
                Blackboard leftBlackboard = this.createBlackboard(leftScope, null, false);
                SqlValidatorScope rightScope = Util.first(this.validator.getJoinScope(right), ((DelegatingScope)bb.scope).getParent());
                Blackboard rightBlackboard = this.createBlackboard(rightScope, null, false);
                this.convertFrom(leftBlackboard, left);
                RelNode leftRel = leftBlackboard.root;
                this.convertFrom(rightBlackboard, right);
                RelNode rightRel = rightBlackboard.root;
                JoinRelType convertedJoinType = SqlToRelConverter.convertJoinType(joinType);
                SqlValidatorNamespace leftNamespace = this.validator.getNamespace(left);
                SqlValidatorNamespace rightNamespace = this.validator.getNamespace(right);
                if (isNatural) {
                    RelDataType leftRowType = leftNamespace.getRowType();
                    RelDataType rightRowType = rightNamespace.getRowType();
                    List<String> columnList = SqlValidatorUtil.deriveNaturalJoinColumnList(leftRowType, rightRowType);
                    conditionExp = this.convertUsing(leftNamespace, rightNamespace, columnList);
                } else {
                    conditionExp = this.convertJoinCondition(fromBlackboard, leftNamespace, rightNamespace, join.getCondition(), join.getConditionType(), leftRel, rightRel);
                }
                RelNode joinRel = this.createJoin(fromBlackboard, leftRel, rightRel, conditionExp, convertedJoinType);
                bb.setRoot(joinRel, false);
                return;
            }
            case SELECT: 
            case INTERSECT: 
            case EXCEPT: 
            case UNION: {
                RelNode rel = this.convertQueryRecursive(from, false, null).project();
                bb.setRoot(rel, true);
                return;
            }
            case VALUES: {
                this.convertValuesImpl(bb, (SqlCall)from, null);
                return;
            }
            case UNNEST: {
                SqlCall call = (SqlCall)from;
                List<SqlNode> nodes = call.getOperandList();
                SqlUnnestOperator operator = (SqlUnnestOperator)call.getOperator();
                for (SqlNode node : nodes) {
                    this.replaceSubQueries(bb, node, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
                }
                ArrayList<RexNode> exprs = new ArrayList<RexNode>();
                ArrayList<String> fieldNames = new ArrayList<String>();
                for (Ord node : Ord.zip(nodes)) {
                    exprs.add(bb.convertExpression((SqlNode)node.e));
                    fieldNames.add(this.validator.deriveAlias((SqlNode)node.e, node.i));
                }
                RelNode input = RelOptUtil.createProject(null != bb.root ? bb.root : LogicalValues.createOneRow(this.cluster), exprs, fieldNames, true);
                Uncollect uncollect = new Uncollect(this.cluster, this.cluster.traitSetOf((RelTrait)Convention.NONE), input, operator.withOrdinality);
                bb.setRoot(uncollect, true);
                return;
            }
            case COLLECTION_TABLE: {
                SqlCall call = (SqlCall)from;
                assert (call.getOperandList().size() == 1);
                SqlCall call2 = (SqlCall)call.operand(0);
                this.convertCollectionTable(bb, call2);
                return;
            }
        }
        throw new AssertionError((Object)("not a join operator " + from));
    }

    protected void convertMatchRecognize(Blackboard bb, SqlCall call) {
        RexNode after;
        List<SqlNode> operands;
        SqlMatchRecognize matchRecognize = (SqlMatchRecognize)call;
        SqlValidatorNamespace ns = this.validator.getNamespace(matchRecognize);
        SqlValidatorScope scope = this.validator.getMatchRecognizeScope(matchRecognize);
        Blackboard matchBb = this.createBlackboard(scope, null, false);
        RelDataType rowType = ns.getRowType();
        SqlNode expr = matchRecognize.getTableRef();
        this.convertFrom(matchBb, expr);
        RelNode input = matchBb.root;
        SqlNodeList partitionList = matchRecognize.getPartitionList();
        ArrayList<RexNode> partitionKeys = new ArrayList<RexNode>();
        for (SqlNode partition : partitionList) {
            RexNode e = matchBb.convertExpression(partition);
            partitionKeys.add(e);
        }
        SqlNodeList orderList = matchRecognize.getOrderList();
        ArrayList<RelFieldCollation> orderKeys = new ArrayList<RelFieldCollation>();
        for (SqlNode order : orderList) {
            RelFieldCollation.Direction direction;
            switch (order.getKind()) {
                case DESCENDING: {
                    direction = RelFieldCollation.Direction.DESCENDING;
                    order = ((SqlCall)order).operand(0);
                    break;
                }
                case NULLS_FIRST: 
                case NULLS_LAST: {
                    throw new AssertionError();
                }
                default: {
                    direction = RelFieldCollation.Direction.ASCENDING;
                }
            }
            RelFieldCollation.NullDirection nullDirection = this.validator.getDefaultNullCollation().last(SqlToRelConverter.desc(direction)) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
            RexNode e = matchBb.convertExpression(order);
            orderKeys.add(new RelFieldCollation(((RexInputRef)e).getIndex(), direction, nullDirection));
        }
        RelCollation orders = this.cluster.traitSet().canonize(RelCollations.of(orderKeys));
        final HashSet<String> patternVarsSet = new HashSet<String>();
        SqlNode pattern = matchRecognize.getPattern();
        SqlBasicVisitor<RexNode> patternVarVisitor = new SqlBasicVisitor<RexNode>(){

            @Override
            public RexNode visit(SqlCall call) {
                List<SqlNode> operands = call.getOperandList();
                ArrayList newOperands = Lists.newArrayList();
                for (SqlNode node : operands) {
                    newOperands.add(node.accept(this));
                }
                return SqlToRelConverter.this.rexBuilder.makeCall(SqlToRelConverter.this.validator.getUnknownType(), call.getOperator(), newOperands);
            }

            @Override
            public RexNode visit(SqlIdentifier id) {
                assert (id.isSimple());
                patternVarsSet.add(id.getSimple());
                return SqlToRelConverter.this.rexBuilder.makeLiteral(id.getSimple());
            }

            @Override
            public RexNode visit(SqlLiteral literal) {
                if (literal instanceof SqlNumericLiteral) {
                    return SqlToRelConverter.this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(literal.intValue(true)));
                }
                return SqlToRelConverter.this.rexBuilder.makeLiteral(literal.booleanValue());
            }
        };
        RexNode patternNode = pattern.accept(patternVarVisitor);
        SqlNodeList subsets = matchRecognize.getSubsetList();
        HashMap subsetMap = Maps.newHashMap();
        for (SqlNode node : subsets) {
            operands = ((SqlCall)node).getOperandList();
            SqlIdentifier left = (SqlIdentifier)operands.get(0);
            patternVarsSet.add(left.getSimple());
            SqlNodeList rights = (SqlNodeList)operands.get(1);
            TreeSet<String> list = new TreeSet<String>();
            for (SqlNode right : rights) {
                assert (right instanceof SqlIdentifier);
                list.add(((SqlIdentifier)right).getSimple());
            }
            subsetMap.put(left.getSimple(), list);
        }
        SqlNode afterMatch = matchRecognize.getAfter();
        if (afterMatch == null) {
            afterMatch = SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW.symbol(SqlParserPos.ZERO);
        }
        if (afterMatch instanceof SqlCall) {
            operands = ((SqlCall)afterMatch).getOperandList();
            SqlOperator operator = ((SqlCall)afterMatch).getOperator();
            assert (operands.size() == 1);
            SqlIdentifier id = (SqlIdentifier)operands.get(0);
            assert (patternVarsSet.contains(id.getSimple())) : id.getSimple() + " not defined in pattern";
            RexLiteral rex = this.rexBuilder.makeLiteral(id.getSimple());
            after = this.rexBuilder.makeCall(this.validator.getUnknownType(), operator, (List<RexNode>)ImmutableList.of((Object)rex));
        } else {
            after = matchBb.convertExpression(afterMatch);
        }
        matchBb.setPatternVarRef(true);
        ImmutableMap.Builder measureNodes = ImmutableMap.builder();
        for (Object measure : matchRecognize.getMeasureList()) {
            List<SqlNode> operands2 = ((SqlCall)measure).getOperandList();
            String alias = ((SqlIdentifier)operands2.get(1)).getSimple();
            RexNode rex = matchBb.convertExpression(operands2.get(0));
            measureNodes.put((Object)alias, (Object)rex);
        }
        ImmutableMap.Builder definitionNodes = ImmutableMap.builder();
        for (SqlNode def : matchRecognize.getPatternDefList()) {
            List<SqlNode> operands3 = ((SqlCall)def).getOperandList();
            String alias = ((SqlIdentifier)operands3.get(1)).getSimple();
            RexNode rex = matchBb.convertExpression(operands3.get(0));
            definitionNodes.put((Object)alias, (Object)rex);
        }
        SqlLiteral rowsPerMatch = matchRecognize.getRowsPerMatch();
        boolean allRows = rowsPerMatch != null && rowsPerMatch.getValue() == SqlMatchRecognize.RowsPerMatchOption.ALL_ROWS;
        matchBb.setPatternVarRef(false);
        RelFactories.MatchFactory factory = RelFactories.DEFAULT_MATCH_FACTORY;
        RelNode rel = factory.createMatchRecognize(input, patternNode, matchRecognize.getStrictStart().booleanValue(), matchRecognize.getStrictEnd().booleanValue(), (Map<String, RexNode>)definitionNodes.build(), (Map<String, RexNode>)measureNodes.build(), after, subsetMap, allRows, partitionKeys, orders, rowType);
        bb.setRoot(rel, false);
    }

    private void convertIdentifier(Blackboard bb, SqlIdentifier id, SqlNodeList extendedColumns) {
        SqlValidatorNamespace fromNamespace = this.validator.getNamespace(id).resolve();
        if (fromNamespace.getNode() != null) {
            this.convertFrom(bb, fromNamespace.getNode());
            return;
        }
        String datasetName = this.datasetStack.isEmpty() ? null : this.datasetStack.peek();
        boolean[] usedDataset = new boolean[]{false};
        RelOptTable table = SqlValidatorUtil.getRelOptTable(fromNamespace, this.catalogReader, datasetName, usedDataset);
        if (extendedColumns != null && extendedColumns.size() > 0) {
            assert (table != null);
            SqlValidatorTable validatorTable = table.unwrap(SqlValidatorTable.class);
            List<RelDataTypeField> extendedFields = SqlValidatorUtil.getExtendedColumns(this.validator.getTypeFactory(), validatorTable, extendedColumns);
            table = table.extend(extendedFields);
        }
        RelNode tableRel = this.config.isConvertTableAccess() ? this.toRel(table) : LogicalTableScan.create(this.cluster, table);
        bb.setRoot(tableRel, true);
        if (usedDataset[0]) {
            bb.setDataset(datasetName);
        }
    }

    protected void convertCollectionTable(Blackboard bb, SqlCall call) {
        Type elementType;
        SqlOperator operator = call.getOperator();
        if (operator == SqlStdOperatorTable.TABLESAMPLE) {
            String sampleName = (String)((Object)SqlLiteral.value(call.operand(0)));
            this.datasetStack.push(sampleName);
            SqlCall cursorCall = (SqlCall)call.operand(1);
            Object query = cursorCall.operand(0);
            RelNode converted = this.convertQuery(query, (boolean)false, (boolean)false).rel;
            bb.setRoot(converted, false);
            this.datasetStack.pop();
            return;
        }
        this.replaceSubQueries(bb, call, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        SqlCallBinding callBinding = new SqlCallBinding(bb.scope.getValidator(), bb.scope, call);
        if (operator instanceof SqlUserDefinedTableMacro) {
            SqlUserDefinedTableMacro udf = (SqlUserDefinedTableMacro)operator;
            TranslatableTable table = udf.getTable(this.typeFactory, callBinding.operands());
            RelDataType rowType = table.getRowType(this.typeFactory);
            RelOptTableImpl relOptTable = RelOptTableImpl.create(null, rowType, (Table)table, udf.getNameAsId().names);
            RelNode converted = this.toRel(relOptTable);
            bb.setRoot(converted, true);
            return;
        }
        if (operator instanceof SqlUserDefinedTableFunction) {
            SqlUserDefinedTableFunction udtf = (SqlUserDefinedTableFunction)operator;
            elementType = udtf.getElementType(this.typeFactory, callBinding.operands());
        } else {
            elementType = null;
        }
        RexNode rexCall = bb.convertExpression(call);
        ImmutableList<RelNode> inputs = bb.retrieveCursors();
        Set<RelColumnMapping> columnMappings = this.getColumnMappings(operator);
        LogicalTableFunctionScan callRel = LogicalTableFunctionScan.create(this.cluster, inputs, rexCall, elementType, this.validator.getValidatedNodeType(call), columnMappings);
        bb.setRoot(callRel, true);
        this.afterTableFunction(bb, call, callRel);
    }

    protected void afterTableFunction(Blackboard bb, SqlCall call, LogicalTableFunctionScan callRel) {
    }

    private Set<RelColumnMapping> getColumnMappings(SqlOperator op) {
        SqlReturnTypeInference rti = op.getReturnTypeInference();
        if (rti == null) {
            return null;
        }
        if (rti instanceof TableFunctionReturnTypeInference) {
            TableFunctionReturnTypeInference tfrti = (TableFunctionReturnTypeInference)rti;
            return tfrti.getColumnMappings();
        }
        return null;
    }

    protected RelNode createJoin(Blackboard bb, RelNode leftRel, RelNode rightRel, RexNode joinCond, JoinRelType joinType) {
        assert (joinCond != null);
        CorrelationUse p = this.getCorrelationUse(bb, rightRel);
        if (p != null) {
            LogicalCorrelate corr = LogicalCorrelate.create(leftRel, p.r, p.id, p.requiredColumns, SemiJoinType.of(joinType));
            if (!joinCond.isAlwaysTrue()) {
                RelFactories.FilterFactory factory = RelFactories.DEFAULT_FILTER_FACTORY;
                return factory.createFilter(corr, joinCond);
            }
            return corr;
        }
        Join originalJoin = (Join)RelFactories.DEFAULT_JOIN_FACTORY.createJoin(leftRel, rightRel, joinCond, (Set<CorrelationId>)ImmutableSet.of(), joinType, false);
        return RelOptUtil.pushDownJoinConditions(originalJoin);
    }

    private CorrelationUse getCorrelationUse(Blackboard bb, RelNode r0) {
        Set<CorrelationId> correlatedVariables = RelOptUtil.getVariablesUsed(r0);
        if (correlatedVariables.isEmpty()) {
            return null;
        }
        ImmutableBitSet.Builder requiredColumns = ImmutableBitSet.builder();
        ArrayList correlNames = Lists.newArrayList();
        SqlValidatorNamespace prevNs = null;
        for (CorrelationId correlName : correlatedVariables) {
            DeferredLookup lookup = this.mapCorrelToDeferred.get(correlName);
            RexFieldAccess fieldAccess = lookup.getFieldAccess(correlName);
            String originalRelName = lookup.getOriginalRelName();
            String originalFieldName = fieldAccess.getField().getName();
            SqlNameMatcher nameMatcher = lookup.bb.scope.getValidator().getCatalogReader().nameMatcher();
            SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
            lookup.bb.scope.resolve((List<String>)ImmutableList.of((Object)originalRelName), nameMatcher, false, resolved);
            assert (resolved.count() == 1);
            SqlValidatorScope.Resolve resolve = resolved.only();
            SqlValidatorNamespace foundNs = resolve.namespace;
            RelDataType rowType = resolve.rowType();
            int childNamespaceIndex = resolve.path.steps().get((int)0).i;
            SqlValidatorScope ancestorScope = resolve.scope;
            boolean correlInCurrentScope = ancestorScope == bb.scope;
            if (!correlInCurrentScope) continue;
            if (prevNs == null) {
                prevNs = foundNs;
            } else assert (prevNs == foundNs) : "All correlation variables should resolve to the same namespace. Prev ns=" + prevNs + ", new ns=" + foundNs;
            int namespaceOffset = 0;
            if (childNamespaceIndex > 0) {
                assert (ancestorScope instanceof ListScope);
                List<SqlValidatorNamespace> children = ((ListScope)ancestorScope).getChildren();
                for (int i = 0; i < childNamespaceIndex; ++i) {
                    SqlValidatorNamespace child = children.get(i);
                    namespaceOffset += child.getRowType().getFieldCount();
                }
            }
            RexFieldAccess topLevelFieldAccess = fieldAccess;
            while (topLevelFieldAccess.getReferenceExpr() instanceof RexFieldAccess) {
                topLevelFieldAccess = (RexFieldAccess)topLevelFieldAccess.getReferenceExpr();
            }
            RelDataTypeField field = rowType.getFieldList().get(topLevelFieldAccess.getField().getIndex() - namespaceOffset);
            int pos = namespaceOffset + field.getIndex();
            assert (field.getType() == topLevelFieldAccess.getField().getType());
            assert (pos != -1);
            if (bb.mapRootRelToFieldProjection.containsKey(bb.root)) {
                Map exprProjection = (Map)bb.mapRootRelToFieldProjection.get(bb.root);
                if (exprProjection.containsKey(pos)) {
                    pos = (Integer)exprProjection.get(pos);
                } else {
                    throw new AssertionError((Object)("Identifier '" + originalRelName + "." + originalFieldName + "' is not a group expr"));
                }
            }
            requiredColumns.set(pos);
            correlNames.add(correlName);
        }
        if (correlNames.isEmpty()) {
            return null;
        }
        RelNode r = r0;
        if (correlNames.size() > 1) {
            r = DeduplicateCorrelateVariables.go(this.rexBuilder, (CorrelationId)correlNames.get(0), Util.skip(correlNames), r0);
            this.leaves.add(r);
        }
        return new CorrelationUse((CorrelationId)correlNames.get(0), requiredColumns.build(), r);
    }

    private boolean isSubQueryNonCorrelated(RelNode subq, Blackboard bb) {
        Set<CorrelationId> correlatedVariables = RelOptUtil.getVariablesUsed(subq);
        for (CorrelationId correlName : correlatedVariables) {
            DeferredLookup lookup = this.mapCorrelToDeferred.get(correlName);
            String originalRelName = lookup.getOriginalRelName();
            SqlNameMatcher nameMatcher = lookup.bb.scope.getValidator().getCatalogReader().nameMatcher();
            SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
            lookup.bb.scope.resolve((List<String>)ImmutableList.of((Object)originalRelName), nameMatcher, false, resolved);
            SqlValidatorScope ancestorScope = resolved.only().scope;
            SqlValidatorScope parentScope = bb.scope;
            do {
                if (ancestorScope != parentScope) continue;
                return false;
            } while (parentScope instanceof DelegatingScope && (parentScope = ((DelegatingScope)parentScope).getParent()) != null);
        }
        return true;
    }

    protected List<RelDataTypeField> getSystemFields() {
        return Collections.emptyList();
    }

    private RexNode convertJoinCondition(Blackboard bb, SqlValidatorNamespace leftNamespace, SqlValidatorNamespace rightNamespace, SqlNode condition, JoinConditionType conditionType, RelNode leftRel, RelNode rightRel) {
        if (condition == null) {
            return this.rexBuilder.makeLiteral(true);
        }
        bb.setRoot((List<RelNode>)ImmutableList.of((Object)leftRel, (Object)rightRel));
        this.replaceSubQueries(bb, condition, RelOptUtil.Logic.UNKNOWN_AS_FALSE);
        switch (conditionType) {
            case ON: {
                bb.setRoot((List<RelNode>)ImmutableList.of((Object)leftRel, (Object)rightRel));
                return bb.convertExpression(condition);
            }
            case USING: {
                SqlNodeList list = (SqlNodeList)condition;
                ArrayList<String> nameList = new ArrayList<String>();
                for (SqlNode columnName : list) {
                    SqlIdentifier id = (SqlIdentifier)columnName;
                    String name = id.getSimple();
                    nameList.add(name);
                }
                return this.convertUsing(leftNamespace, rightNamespace, nameList);
            }
        }
        throw Util.unexpected(conditionType);
    }

    private RexNode convertUsing(SqlValidatorNamespace leftNamespace, SqlValidatorNamespace rightNamespace, List<String> nameList) {
        SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
        ArrayList list = Lists.newArrayList();
        for (String name : nameList) {
            ArrayList<RexInputRef> operands = new ArrayList<RexInputRef>();
            int offset = 0;
            for (SqlValidatorNamespace n : ImmutableList.of((Object)leftNamespace, (Object)rightNamespace)) {
                RelDataType rowType = n.getRowType();
                RelDataTypeField field = nameMatcher.field(rowType, name);
                operands.add(this.rexBuilder.makeInputRef(field.getType(), offset + field.getIndex()));
                offset += rowType.getFieldList().size();
            }
            list.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, operands));
        }
        return RexUtil.composeConjunction(this.rexBuilder, list, false);
    }

    private static JoinRelType convertJoinType(JoinType joinType) {
        switch (joinType) {
            case COMMA: 
            case INNER: 
            case CROSS: {
                return JoinRelType.INNER;
            }
            case FULL: {
                return JoinRelType.FULL;
            }
            case LEFT: {
                return JoinRelType.LEFT;
            }
            case RIGHT: {
                return JoinRelType.RIGHT;
            }
        }
        throw Util.unexpected(joinType);
    }

    protected void convertAgg(Blackboard bb, SqlSelect select, List<SqlNode> orderExprList) {
        assert (bb.root != null) : "precondition: child != null";
        SqlNodeList groupList = select.getGroup();
        SqlNodeList selectList = select.getSelectList();
        SqlNode having = select.getHaving();
        AggConverter aggConverter = new AggConverter(bb, select);
        this.createAggImpl(bb, aggConverter, selectList, groupList, having, orderExprList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void createAggImpl(Blackboard bb, AggConverter aggConverter, SqlNodeList selectList, SqlNodeList groupList, SqlNode having, List<SqlNode> orderExprList) {
        AggregateFinder aggregateFinder = new AggregateFinder();
        selectList.accept(aggregateFinder);
        if (having != null) {
            having.accept(aggregateFinder);
        }
        this.replaceSubQueries(bb, aggregateFinder.list, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        if (groupList == null) {
            groupList = SqlNodeList.EMPTY;
        }
        this.replaceSubQueries(bb, groupList, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        AggregatingSelectScope scope = aggConverter.aggregatingSelectScope;
        AggregatingSelectScope.Resolved r = (AggregatingSelectScope.Resolved)scope.resolved.get();
        for (SqlNode groupExpr : r.groupExprList) {
            aggConverter.addGroupExpr(groupExpr);
        }
        RexNode havingExpr = null;
        ArrayList projects = Lists.newArrayList();
        try {
            ImmutableList preExprs;
            Preconditions.checkArgument((bb.agg == null ? 1 : 0) != 0, (Object)"already in agg mode");
            bb.agg = aggConverter;
            selectList.accept(aggConverter);
            assert (!aggConverter.inOver);
            for (SqlNode expr : orderExprList) {
                expr.accept(aggConverter);
                assert (!aggConverter.inOver);
            }
            if (having != null) {
                having.accept(aggConverter);
                assert (!aggConverter.inOver);
            }
            if ((preExprs = aggConverter.getPreExprs()).size() == 0) {
                RexLiteral zero = this.rexBuilder.makeExactLiteral(BigDecimal.ZERO);
                preExprs = ImmutableList.of(Pair.of(zero, null));
            }
            RelNode inputRel = bb.root;
            bb.setRoot(RelOptUtil.createProject(inputRel, preExprs, true), false);
            bb.mapRootRelToFieldProjection.put(bb.root, r.groupExprProjection);
            bb.columnMonotonicities.clear();
            for (SqlNode groupItem : groupList) {
                bb.columnMonotonicities.add(bb.scope.getMonotonicity(groupItem));
            }
            bb.setRoot(this.createAggregate(bb, r.indicator, r.groupSet, r.groupSets, aggConverter.getAggCalls()), false);
            Aggregate aggregate = (Aggregate)bb.root;
            if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
                assert (aggregate.indicator);
                ArrayList projects2 = Lists.newArrayList();
                int converted = 0;
                int groupCount = aggregate.getGroupSet().cardinality();
                for (RelDataTypeField field : aggregate.getRowType().getFieldList()) {
                    RexNode rex;
                    int i = field.getIndex();
                    if (i < groupCount && r.isNullable(i)) {
                        ++converted;
                        rex = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, this.rexBuilder.makeInputRef(aggregate, groupCount + i), this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(field.getType(), true), this.rexBuilder.constantNull()), this.rexBuilder.makeInputRef(aggregate, i));
                    } else {
                        rex = this.rexBuilder.makeInputRef(aggregate, i);
                    }
                    projects2.add(Pair.of(rex, field.getName()));
                }
                if (converted > 0) {
                    bb.setRoot(RelOptUtil.createProject(bb.root, projects2, true), false);
                }
            }
            bb.mapRootRelToFieldProjection.put(bb.root, r.groupExprProjection);
            if (having != null) {
                SqlNode newHaving = SqlToRelConverter.pushDownNotForIn(bb.scope, having);
                this.replaceSubQueries(bb, newHaving, RelOptUtil.Logic.UNKNOWN_AS_FALSE);
                havingExpr = bb.convertExpression(newHaving);
                if (havingExpr.isAlwaysTrue()) {
                    havingExpr = null;
                }
            }
            this.replaceSubQueries(bb, selectList, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
            int k = 0;
            SelectScope selectScope = SqlValidatorUtil.getEnclosingSelectScope(bb.scope);
            assert (selectScope != null);
            SqlValidatorNamespace selectNamespace = this.validator.getNamespace(selectScope.getNode());
            List<String> names = selectNamespace.getRowType().getFieldNames();
            int sysFieldCount = selectList.size() - names.size();
            for (SqlNode expr : selectList) {
                projects.add(Pair.of(bb.convertExpression(expr), k < sysFieldCount ? this.validator.deriveAlias(expr, k++) : names.get(k++ - sysFieldCount)));
            }
            for (SqlNode expr : orderExprList) {
                projects.add(Pair.of(bb.convertExpression(expr), this.validator.deriveAlias(expr, k++)));
            }
        }
        finally {
            bb.agg = null;
        }
        if (havingExpr != null) {
            RelFactories.FilterFactory factory = RelFactories.DEFAULT_FILTER_FACTORY;
            bb.setRoot(factory.createFilter(bb.root, havingExpr), false);
        }
        bb.setRoot(RelOptUtil.createProject(bb.root, projects, true), false);
        bb.columnMonotonicities.clear();
        for (SqlNode selectItem : selectList) {
            bb.columnMonotonicities.add(bb.scope.getMonotonicity(selectItem));
        }
    }

    protected RelNode createAggregate(Blackboard bb, boolean indicator, ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return LogicalAggregate.create(bb.root, indicator, groupSet, groupSets, aggCalls);
    }

    public RexDynamicParam convertDynamicParam(SqlDynamicParam dynamicParam) {
        while (dynamicParam.getIndex() >= this.dynamicParamSqlNodes.size()) {
            this.dynamicParamSqlNodes.add(null);
        }
        this.dynamicParamSqlNodes.set(dynamicParam.getIndex(), dynamicParam);
        return this.rexBuilder.makeDynamicParam(this.getDynamicParamType(dynamicParam.getIndex()), dynamicParam.getIndex());
    }

    protected void gatherOrderExprs(Blackboard bb, SqlSelect select, SqlNodeList orderList, List<SqlNode> extraOrderExprs, List<RelFieldCollation> collationList) {
        assert (bb.root != null) : "precondition: child != null";
        assert (select != null);
        if (orderList == null) {
            return;
        }
        for (SqlNode orderItem : orderList) {
            collationList.add(this.convertOrderItem(select, orderItem, extraOrderExprs, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.UNSPECIFIED));
        }
    }

    protected RelFieldCollation convertOrderItem(SqlSelect select, SqlNode orderItem, List<SqlNode> extraExprs, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection) {
        assert (select != null);
        switch (orderItem.getKind()) {
            case DESCENDING: {
                return this.convertOrderItem(select, (SqlNode)((SqlCall)orderItem).operand(0), extraExprs, RelFieldCollation.Direction.DESCENDING, nullDirection);
            }
            case NULLS_FIRST: {
                return this.convertOrderItem(select, (SqlNode)((SqlCall)orderItem).operand(0), extraExprs, direction, RelFieldCollation.NullDirection.FIRST);
            }
            case NULLS_LAST: {
                return this.convertOrderItem(select, (SqlNode)((SqlCall)orderItem).operand(0), extraExprs, direction, RelFieldCollation.NullDirection.LAST);
            }
        }
        SqlNode converted = this.validator.expandOrderExpr(select, orderItem);
        switch (nullDirection) {
            case UNSPECIFIED: {
                nullDirection = this.validator.getDefaultNullCollation().last(SqlToRelConverter.desc(direction)) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
            }
        }
        SelectScope selectScope = this.validator.getRawSelectScope(select);
        int ordinal = -1;
        for (SqlNode selectItem : selectScope.getExpandedSelectList()) {
            ++ordinal;
            if (!converted.equalsDeep(SqlUtil.stripAs(selectItem), Litmus.IGNORE)) continue;
            return new RelFieldCollation(ordinal, direction, nullDirection);
        }
        for (SqlNode extraExpr : extraExprs) {
            ++ordinal;
            if (!converted.equalsDeep(extraExpr, Litmus.IGNORE)) continue;
            return new RelFieldCollation(ordinal, direction, nullDirection);
        }
        extraExprs.add(converted);
        return new RelFieldCollation(ordinal + 1, direction, nullDirection);
    }

    private static boolean desc(RelFieldCollation.Direction direction) {
        switch (direction) {
            case DESCENDING: 
            case STRICTLY_DESCENDING: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    protected boolean enableDecorrelation() {
        return this.config.isDecorrelationEnabled();
    }

    protected RelNode decorrelateQuery(RelNode rootRel) {
        return RelDecorrelator.decorrelateQuery(rootRel);
    }

    @Deprecated
    public boolean isTrimUnusedFields() {
        return this.config.isTrimUnusedFields();
    }

    protected RelRoot convertQueryRecursive(SqlNode query, boolean top, RelDataType targetRowType) {
        SqlKind kind = query.getKind();
        switch (kind) {
            case SELECT: {
                return RelRoot.of(this.convertSelect((SqlSelect)query, top), kind);
            }
            case INSERT: {
                return RelRoot.of(this.convertInsert((SqlInsert)query), kind);
            }
            case DELETE: {
                return RelRoot.of(this.convertDelete((SqlDelete)query), kind);
            }
            case UPDATE: {
                return RelRoot.of(this.convertUpdate((SqlUpdate)query), kind);
            }
            case MERGE: {
                return RelRoot.of(this.convertMerge((SqlMerge)query), kind);
            }
            case INTERSECT: 
            case EXCEPT: 
            case UNION: {
                return RelRoot.of(this.convertSetOp((SqlCall)query), kind);
            }
            case WITH: {
                return this.convertWith((SqlWith)query, top);
            }
            case VALUES: {
                return RelRoot.of(this.convertValues((SqlCall)query, targetRowType), kind);
            }
        }
        throw new AssertionError((Object)("not a query: " + query));
    }

    protected RelNode convertSetOp(SqlCall call) {
        RelNode left = this.convertQueryRecursive((SqlNode)call.operand(0), false, null).project();
        RelNode right = this.convertQueryRecursive((SqlNode)call.operand(1), false, null).project();
        switch (call.getKind()) {
            case UNION: {
                return LogicalUnion.create((List<RelNode>)ImmutableList.of((Object)left, (Object)right), this.all(call));
            }
            case INTERSECT: {
                return LogicalIntersect.create((List<RelNode>)ImmutableList.of((Object)left, (Object)right), this.all(call));
            }
            case EXCEPT: {
                return LogicalMinus.create((List<RelNode>)ImmutableList.of((Object)left, (Object)right), this.all(call));
            }
        }
        throw Util.unexpected(call.getKind());
    }

    private boolean all(SqlCall call) {
        return ((SqlSetOperator)call.getOperator()).isAll();
    }

    protected RelNode convertInsert(SqlInsert call) {
        RelOptTable targetTable = this.getTargetTable(call);
        RelDataType targetRowType = this.validator.getValidatedNodeType(call);
        assert (targetRowType != null);
        RelNode sourceRel = this.convertQueryRecursive(call.getSource(), false, targetRowType).project();
        RelNode massagedRel = this.convertColumnList(call, sourceRel);
        return this.createModify(targetTable, massagedRel);
    }

    private RelNode createModify(RelOptTable targetTable, RelNode source) {
        ModifiableTable modifiableTable = targetTable.unwrap(ModifiableTable.class);
        if (modifiableTable != null) {
            return modifiableTable.toModificationRel(this.cluster, targetTable, this.catalogReader, source, TableModify.Operation.INSERT, null, null, false);
        }
        ModifiableView modifiableView = targetTable.unwrap(ModifiableView.class);
        if (modifiableView != null) {
            Table delegateTable = modifiableView.getTable();
            RelDataType delegateRowType = delegateTable.getRowType(this.typeFactory);
            RelOptTableImpl delegateRelOptTable = RelOptTableImpl.create(null, delegateRowType, delegateTable, modifiableView.getTablePath());
            RelNode newSource = this.createSource(targetTable, source, modifiableView, delegateRowType);
            return this.createModify(delegateRelOptTable, newSource);
        }
        return LogicalTableModify.create(targetTable, this.catalogReader, source, TableModify.Operation.INSERT, null, null, false);
    }

    private RelNode createSource(RelOptTable targetTable, RelNode source, ModifiableView modifiableView, RelDataType delegateRowType) {
        ImmutableIntList mapping = modifiableView.getColumnMapping();
        assert (mapping.size() == targetTable.getRowType().getFieldCount());
        HashMap<Integer, RexNode> projectMap = new HashMap<Integer, RexNode>();
        ArrayList<RexNode> filters = new ArrayList<RexNode>();
        for (int i = 0; i < mapping.size(); ++i) {
            int target = mapping.get(i);
            if (target < 0) continue;
            projectMap.put(target, RexInputRef.of(i, source.getRowType()));
        }
        RexNode constraint = modifiableView.getConstraint(this.rexBuilder, delegateRowType);
        RelOptUtil.inferViewPredicates(projectMap, filters, constraint);
        ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
        for (RelDataTypeField field : delegateRowType.getFieldList()) {
            RexNode node = (RexNode)projectMap.get(field.getIndex());
            if (node == null) {
                node = this.rexBuilder.makeNullLiteral(field.getType());
            }
            projects.add(Pair.of(this.rexBuilder.ensureType(field.getType(), node, false), field.getName()));
        }
        source = RelOptUtil.createProject(source, projects, true);
        if (filters.size() > 0) {
            source = RelOptUtil.createFilter(source, filters);
        }
        return source;
    }

    private RelOptTable.ToRelContext createToRelContext() {
        return new RelOptTable.ToRelContext(){

            @Override
            public RelOptCluster getCluster() {
                return SqlToRelConverter.this.cluster;
            }

            @Override
            public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, List<String> viewPath) {
                return SqlToRelConverter.this.viewExpander.expandView(rowType, queryString, schemaPath, viewPath);
            }
        };
    }

    public RelNode toRel(RelOptTable table) {
        return table.toRel(this.createToRelContext());
    }

    protected RelOptTable getTargetTable(SqlNode call) {
        SqlValidatorNamespace targetNs = this.validator.getNamespace(call);
        if (targetNs.isWrapperFor(SqlValidatorImpl.DmlNamespace.class)) {
            SqlValidatorImpl.DmlNamespace dmlNamespace = targetNs.unwrap(SqlValidatorImpl.DmlNamespace.class);
            return SqlValidatorUtil.getRelOptTable(dmlNamespace, this.catalogReader, null, null);
        }
        SqlValidatorNamespace resolvedNamespace = targetNs.resolve();
        return SqlValidatorUtil.getRelOptTable(resolvedNamespace, this.catalogReader, null, null);
    }

    protected RelNode convertColumnList(SqlInsert call, RelNode sourceRel) {
        RelDataType sourceRowType = sourceRel.getRowType();
        RexRangeRef sourceRef = this.rexBuilder.makeRangeReference(sourceRowType, 0, false);
        ArrayList<String> targetColumnNames = new ArrayList<String>();
        ArrayList<RexNode> columnExprs = new ArrayList<RexNode>();
        this.collectInsertTargets(call, sourceRef, targetColumnNames, columnExprs);
        RelOptTable targetTable = this.getTargetTable(call);
        RelDataType targetRowType = targetTable.getRowType();
        List<RelDataTypeField> targetFields = targetRowType.getFieldList();
        ArrayList<Object> sourceExps = new ArrayList<Object>(Collections.nCopies(targetFields.size(), null));
        ArrayList<Object> fieldNames = new ArrayList<Object>(Collections.nCopies(targetFields.size(), null));
        InitializerExpressionFactory initializerFactory = this.getInitializerFactory(this.validator.getNamespace(call).getTable());
        SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
        for (Pair<String, RexNode> p : Pair.zip(targetColumnNames, columnExprs)) {
            RelDataTypeField field = nameMatcher.field(targetRowType, (String)p.left);
            assert (field != null) : "column " + (String)p.left + " not found";
            sourceExps.set(field.getIndex(), p.right);
        }
        for (int i = 0; i < targetFields.size(); ++i) {
            RelDataTypeField field = targetFields.get(i);
            String fieldName = field.getName();
            fieldNames.set(i, fieldName);
            if (sourceExps.get(i) != null) {
                if (!initializerFactory.isGeneratedAlways(targetTable, i)) continue;
                throw Static.RESOURCE.insertIntoAlwaysGenerated(fieldName).ex();
            }
            sourceExps.set(i, initializerFactory.newColumnDefaultValue(targetTable, i, new InitializerContext(){

                @Override
                public RexBuilder getRexBuilder() {
                    return SqlToRelConverter.this.rexBuilder;
                }
            }));
            sourceExps.set(i, this.castNullLiteralIfNeeded((RexNode)sourceExps.get(i), field.getType()));
        }
        return RelOptUtil.createProject(sourceRel, sourceExps, fieldNames, true);
    }

    private InitializerExpressionFactory getInitializerFactory(SqlValidatorTable validatorTable) {
        InitializerExpressionFactory f;
        Table table = SqlToRelConverter.unwrap(validatorTable, Table.class);
        if (table != null && (f = SqlToRelConverter.unwrap(table, InitializerExpressionFactory.class)) != null) {
            return f;
        }
        return new NullInitializerExpressionFactory();
    }

    private static <T> T unwrap(Object o, Class<T> clazz) {
        if (o instanceof Wrapper) {
            return ((Wrapper)o).unwrap(clazz);
        }
        return null;
    }

    private RexNode castNullLiteralIfNeeded(RexNode node, RelDataType type) {
        if (!RexLiteral.isNullLiteral(node)) {
            return node;
        }
        return this.rexBuilder.makeCast(type, node);
    }

    protected void collectInsertTargets(SqlInsert call, RexNode sourceRef, List<String> targetColumnNames, List<RexNode> columnExprs) {
        RelOptTable targetTable = this.getTargetTable(call);
        RelDataType tableRowType = targetTable.getRowType();
        SqlNodeList targetColumnList = call.getTargetColumnList();
        if (targetColumnList == null) {
            if (this.validator.getConformance().isInsertSubsetColumnsAllowed()) {
                RelDataType targetRowType = this.typeFactory.createStructType(tableRowType.getFieldList().subList(0, sourceRef.getType().getFieldCount()));
                targetColumnNames.addAll(targetRowType.getFieldNames());
            } else {
                targetColumnNames.addAll(tableRowType.getFieldNames());
            }
        } else {
            for (int i = 0; i < targetColumnList.size(); ++i) {
                SqlIdentifier id = (SqlIdentifier)targetColumnList.get(i);
                RelDataTypeField field = SqlValidatorUtil.getTargetField(tableRowType, this.typeFactory, id, this.catalogReader, targetTable);
                assert (field != null) : "column " + id.toString() + " not found";
                targetColumnNames.add(field.getName());
            }
        }
        for (int i = 0; i < targetColumnNames.size(); ++i) {
            RexNode expr = this.rexBuilder.makeFieldAccess(sourceRef, i);
            columnExprs.add(expr);
        }
    }

    private RelNode convertDelete(SqlDelete call) {
        RelOptTable targetTable = this.getTargetTable(call);
        RelNode sourceRel = this.convertSelect(call.getSourceSelect(), false);
        return LogicalTableModify.create(targetTable, this.catalogReader, sourceRel, TableModify.Operation.DELETE, null, null, false);
    }

    private RelNode convertUpdate(SqlUpdate call) {
        SqlValidatorScope scope = this.validator.getWhereScope(call.getSourceSelect());
        Blackboard bb = this.createBlackboard(scope, null, false);
        ImmutableList.Builder rexNodeSourceExpressionListBuilder = ImmutableList.builder();
        for (SqlNode n : call.getSourceExpressionList()) {
            RexNode rn = bb.convertExpression(n);
            rexNodeSourceExpressionListBuilder.add((Object)rn);
        }
        RelOptTable targetTable = this.getTargetTable(call);
        ArrayList<String> targetColumnNameList = new ArrayList<String>();
        RelDataType targetRowType = targetTable.getRowType();
        for (SqlNode node : call.getTargetColumnList()) {
            SqlIdentifier id = (SqlIdentifier)node;
            RelDataTypeField field = SqlValidatorUtil.getTargetField(targetRowType, this.typeFactory, id, this.catalogReader, targetTable);
            assert (field != null) : "column " + id.toString() + " not found";
            targetColumnNameList.add(field.getName());
        }
        RelNode sourceRel = this.convertSelect(call.getSourceSelect(), false);
        return LogicalTableModify.create(targetTable, this.catalogReader, sourceRel, TableModify.Operation.UPDATE, targetColumnNameList, (List<RexNode>)rexNodeSourceExpressionListBuilder.build(), false);
    }

    private RelNode convertMerge(SqlMerge call) {
        RelOptTable targetTable = this.getTargetTable(call);
        ArrayList<String> targetColumnNameList = new ArrayList<String>();
        RelDataType targetRowType = targetTable.getRowType();
        SqlUpdate updateCall = call.getUpdateCall();
        if (updateCall != null) {
            for (SqlNode targetColumn : updateCall.getTargetColumnList()) {
                SqlIdentifier id = (SqlIdentifier)targetColumn;
                RelDataTypeField field = SqlValidatorUtil.getTargetField(targetRowType, this.typeFactory, id, this.catalogReader, targetTable);
                assert (field != null) : "column " + id.toString() + " not found";
                targetColumnNameList.add(field.getName());
            }
        }
        RelNode mergeSourceRel = this.convertSelect(call.getSourceSelect(), false);
        SqlInsert insertCall = call.getInsertCall();
        int nLevel1Exprs = 0;
        List<RexNode> level1InsertExprs = null;
        List<RexNode> level2InsertExprs = null;
        if (insertCall != null) {
            RelNode insertRel = this.convertInsert(insertCall);
            level1InsertExprs = ((LogicalProject)insertRel.getInput(0)).getProjects();
            if (insertRel.getInput(0).getInput(0) instanceof LogicalProject) {
                level2InsertExprs = ((LogicalProject)insertRel.getInput(0).getInput(0)).getProjects();
            }
            nLevel1Exprs = level1InsertExprs.size();
        }
        LogicalJoin join = (LogicalJoin)mergeSourceRel.getInput(0);
        int nSourceFields = join.getLeft().getRowType().getFieldCount();
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (int level1Idx = 0; level1Idx < nLevel1Exprs; ++level1Idx) {
            if (level2InsertExprs != null && level1InsertExprs.get(level1Idx) instanceof RexInputRef) {
                int level2Idx = ((RexInputRef)level1InsertExprs.get(level1Idx)).getIndex();
                projects.add(level2InsertExprs.get(level2Idx));
                continue;
            }
            projects.add(level1InsertExprs.get(level1Idx));
        }
        if (updateCall != null) {
            LogicalProject project = (LogicalProject)mergeSourceRel;
            projects.addAll(Util.skip(project.getProjects(), nSourceFields));
        }
        RelNode massagedRel = RelOptUtil.createProject(join, projects, null, true);
        return LogicalTableModify.create(targetTable, this.catalogReader, massagedRel, TableModify.Operation.MERGE, targetColumnNameList, null, false);
    }

    private RexNode convertIdentifier(Blackboard bb, SqlIdentifier identifier) {
        SqlCall call = SqlUtil.makeCall(this.opTab, identifier);
        if (call != null) {
            return bb.convertExpression(call);
        }
        String pv = null;
        if (bb.isPatternVarRef && identifier.names.size() > 1) {
            pv = (String)identifier.names.get(0);
        }
        SqlQualified qualified = bb.scope != null ? bb.scope.fullyQualify(identifier) : SqlQualified.create(null, 1, null, identifier);
        Pair<RexNode, Map<String, Integer>> e0 = bb.lookupExp(qualified);
        RexNode e = (RexNode)e0.left;
        for (String name : qualified.suffixTranslated()) {
            if (e == e0.left && e0.right != null) {
                int i = (Integer)((Map)e0.right).get(name);
                e = this.rexBuilder.makeFieldAccess(e, i);
                continue;
            }
            boolean caseSensitive = true;
            if (identifier.isStar() && bb.scope instanceof MatchRecognizeScope) {
                e = this.rexBuilder.makeFieldAccess(e, 0);
                continue;
            }
            e = this.rexBuilder.makeFieldAccess(e, name, true);
        }
        if (e instanceof RexInputRef) {
            e = this.adjustInputRef(bb, (RexInputRef)e);
            if (pv != null) {
                e = RexPatternFieldRef.of(pv, (RexInputRef)e);
            }
        }
        if (e0.left instanceof RexCorrelVariable) {
            assert (e instanceof RexFieldAccess);
            RexNode prev = bb.mapCorrelateToRex.put(((RexCorrelVariable)e0.left).id, (RexFieldAccess)e);
            assert (prev == null);
        }
        return e;
    }

    protected RexNode adjustInputRef(Blackboard bb, RexInputRef inputRef) {
        RelDataTypeField field = bb.getRootField(inputRef);
        if (field != null) {
            return this.rexBuilder.makeInputRef(field.getType(), inputRef.getIndex());
        }
        return inputRef;
    }

    private RelNode convertRowConstructor(Blackboard bb, SqlCall rowConstructor) {
        Preconditions.checkArgument((boolean)this.isRowConstructor(rowConstructor));
        List<SqlNode> operands = rowConstructor.getOperandList();
        return this.convertMultisets(operands, bb);
    }

    private RelNode convertCursor(Blackboard bb, SubQuery subQuery) {
        SqlCall cursorCall = (SqlCall)subQuery.node;
        assert (cursorCall.operandCount() == 1);
        Object query = cursorCall.operand(0);
        RelNode converted = this.convertQuery(query, (boolean)false, (boolean)false).rel;
        int iCursor = bb.cursors.size();
        bb.cursors.add(converted);
        subQuery.expr = new RexInputRef(iCursor, converted.getRowType());
        return converted;
    }

    private RelNode convertMultisets(List<SqlNode> operands, Blackboard bb) {
        int i;
        ArrayList<Cloneable> joinList = new ArrayList<Cloneable>();
        ArrayList<SqlNode> lastList = new ArrayList<SqlNode>();
        block4: for (i = 0; i < operands.size(); ++i) {
            RelNode input;
            SqlNode operand = operands.get(i);
            if (!(operand instanceof SqlCall)) {
                lastList.add(operand);
                continue;
            }
            final SqlCall call = (SqlCall)operand;
            switch (call.getKind()) {
                case MULTISET_VALUE_CONSTRUCTOR: 
                case ARRAY_VALUE_CONSTRUCTOR: {
                    SqlNodeList list = new SqlNodeList(call.getOperandList(), call.getParserPosition());
                    CollectNamespace nss = (CollectNamespace)this.validator.getNamespace(call);
                    Blackboard usedBb = null != nss ? this.createBlackboard(nss.getScope(), null, false) : this.createBlackboard(new ListScope(bb.scope){

                        @Override
                        public SqlNode getNode() {
                            return call;
                        }
                    }, null, false);
                    RelDataType multisetType = this.validator.getValidatedNodeType(call);
                    ((SqlValidatorImpl)this.validator).setValidatedNodeType(list, multisetType.getComponentType());
                    input = this.convertQueryOrInList(usedBb, list, null);
                    break;
                }
                case MULTISET_QUERY_CONSTRUCTOR: 
                case ARRAY_QUERY_CONSTRUCTOR: {
                    RelRoot root = this.convertQuery((SqlNode)call.operand(0), false, true);
                    input = root.rel;
                    break;
                }
                default: {
                    lastList.add(operand);
                    continue block4;
                }
            }
            if (lastList.size() > 0) {
                joinList.add(lastList);
            }
            lastList = new ArrayList();
            Collect collect = new Collect(this.cluster, this.cluster.traitSetOf((RelTrait)Convention.NONE), input, this.validator.deriveAlias(call, i));
            joinList.add(collect);
        }
        if (joinList.size() == 0) {
            joinList.add(lastList);
        }
        for (i = 0; i < joinList.size(); ++i) {
            Object o = joinList.get(i);
            if (!(o instanceof List)) continue;
            List projectList = (List)o;
            ArrayList<RexNode> selectList = new ArrayList<RexNode>();
            ArrayList<String> fieldNameList = new ArrayList<String>();
            for (int j = 0; j < projectList.size(); ++j) {
                SqlNode operand = (SqlNode)projectList.get(j);
                selectList.add(bb.convertExpression(operand));
                fieldNameList.add(SqlUtil.deriveAliasFromOrdinal(j));
            }
            RelNode projRel = RelOptUtil.createProject((RelNode)LogicalValues.createOneRow(this.cluster), selectList, fieldNameList);
            joinList.set(i, projRel);
        }
        RelNode ret = (RelNode)joinList.get(0);
        for (int i2 = 1; i2 < joinList.size(); ++i2) {
            RelNode relNode = (RelNode)joinList.get(i2);
            ret = RelFactories.DEFAULT_JOIN_FACTORY.createJoin(ret, relNode, (RexNode)this.rexBuilder.makeLiteral(true), (Set<CorrelationId>)ImmutableSet.of(), JoinRelType.INNER, false);
        }
        return ret;
    }

    private void convertSelectList(Blackboard bb, SqlSelect select, List<SqlNode> orderList) {
        SqlNodeList selectList = select.getSelectList();
        selectList = this.validator.expandStar(selectList, select, false);
        this.replaceSubQueries(bb, selectList, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        List<String> fieldNames = new ArrayList<String>();
        ArrayList<RexNode> exprs = new ArrayList<RexNode>();
        TreeSet<String> aliases = new TreeSet<String>();
        ArrayList<SqlMonotonicity> columnMonotonicityList = new ArrayList<SqlMonotonicity>();
        this.extraSelectItems(bb, select, exprs, fieldNames, aliases, columnMonotonicityList);
        int i = -1;
        for (SqlNode expr : selectList) {
            exprs.add(bb.convertExpression(expr));
            fieldNames.add(this.deriveAlias(expr, aliases, ++i));
        }
        for (SqlNode expr : orderList) {
            SqlNode expr2 = this.validator.expandOrderExpr(select, expr);
            exprs.add(bb.convertExpression(expr2));
            fieldNames.add(this.deriveAlias(expr, aliases, ++i));
        }
        fieldNames = SqlValidatorUtil.uniquify(fieldNames, this.catalogReader.nameMatcher().isCaseSensitive());
        bb.setRoot(RelOptUtil.createProject(bb.root, exprs, fieldNames), false);
        assert (bb.columnMonotonicities.isEmpty());
        bb.columnMonotonicities.addAll(columnMonotonicityList);
        for (SqlNode selectItem : selectList) {
            bb.columnMonotonicities.add(selectItem.getMonotonicity(bb.scope));
        }
    }

    protected void extraSelectItems(Blackboard bb, SqlSelect select, List<RexNode> exprList, List<String> nameList, Collection<String> aliasList, List<SqlMonotonicity> columnMonotonicityList) {
    }

    private String deriveAlias(SqlNode node, Collection<String> aliases, int ordinal) {
        String alias = this.validator.deriveAlias(node, ordinal);
        if (alias == null || aliases.contains(alias)) {
            String aliasBase = alias == null ? "EXPR$" : alias;
            int j = 0;
            while (aliases.contains(alias = aliasBase + j)) {
                ++j;
            }
        }
        aliases.add(alias);
        return alias;
    }

    public RelRoot convertWith(SqlWith with, boolean top) {
        return this.convertQuery(with.body, false, top);
    }

    public RelNode convertValues(SqlCall values, RelDataType targetRowType) {
        SqlValidatorScope scope = this.validator.getOverScope(values);
        assert (scope != null);
        Blackboard bb = this.createBlackboard(scope, null, false);
        this.convertValuesImpl(bb, values, targetRowType);
        return bb.root;
    }

    private void convertValuesImpl(Blackboard bb, SqlCall values, RelDataType targetRowType) {
        RelNode valuesRel = this.convertRowValues(bb, values, values.getOperandList(), true, targetRowType);
        if (valuesRel != null) {
            bb.setRoot(valuesRel, true);
            return;
        }
        ArrayList<RelNode> unionRels = new ArrayList<RelNode>();
        for (SqlNode rowConstructor1 : values.getOperandList()) {
            SqlCall rowConstructor = (SqlCall)rowConstructor1;
            Blackboard tmpBb = this.createBlackboard(bb.scope, null, false);
            this.replaceSubQueries(tmpBb, rowConstructor, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
            ArrayList<Pair<RexNode, String>> exps = new ArrayList<Pair<RexNode, String>>();
            for (Ord operand : Ord.zip(rowConstructor.getOperandList())) {
                exps.add(Pair.of(tmpBb.convertExpression((SqlNode)operand.e), this.validator.deriveAlias((SqlNode)operand.e, operand.i)));
            }
            RelNode in = null == tmpBb.root ? LogicalValues.createOneRow(this.cluster) : tmpBb.root;
            unionRels.add(RelOptUtil.createProject(in, Pair.left(exps), Pair.right(exps), true));
        }
        if (unionRels.size() == 0) {
            throw new AssertionError((Object)"empty values clause");
        }
        if (unionRels.size() == 1) {
            bb.setRoot((RelNode)unionRels.get(0), true);
        } else {
            bb.setRoot(LogicalUnion.create(unionRels, true), true);
        }
    }

    public static ConfigBuilder configBuilder() {
        return new ConfigBuilder();
    }

    private static class ConfigImpl
    implements Config {
        private final boolean convertTableAccess;
        private final boolean decorrelationEnabled;
        private final boolean trimUnusedFields;
        private final boolean createValuesRel;
        private final boolean explain;
        private final int inSubQueryThreshold;
        private final boolean expand;

        private ConfigImpl(boolean convertTableAccess, boolean decorrelationEnabled, boolean trimUnusedFields, boolean createValuesRel, boolean explain, boolean expand, int inSubQueryThreshold) {
            this.convertTableAccess = convertTableAccess;
            this.decorrelationEnabled = decorrelationEnabled;
            this.trimUnusedFields = trimUnusedFields;
            this.createValuesRel = createValuesRel;
            this.explain = explain;
            this.expand = expand;
            this.inSubQueryThreshold = inSubQueryThreshold;
        }

        @Override
        public boolean isConvertTableAccess() {
            return this.convertTableAccess;
        }

        @Override
        public boolean isDecorrelationEnabled() {
            return this.decorrelationEnabled;
        }

        @Override
        public boolean isTrimUnusedFields() {
            return this.trimUnusedFields;
        }

        @Override
        public boolean isCreateValuesRel() {
            return this.createValuesRel;
        }

        @Override
        public boolean isExplain() {
            return this.explain;
        }

        @Override
        public boolean isExpand() {
            return this.expand;
        }

        @Override
        public int getInSubQueryThreshold() {
            return this.inSubQueryThreshold;
        }
    }

    public static class ConfigBuilder {
        private boolean convertTableAccess = true;
        private boolean decorrelationEnabled = true;
        private boolean trimUnusedFields = false;
        private boolean createValuesRel = true;
        private boolean explain;
        private boolean expand = true;
        private int inSubQueryThreshold = 20;

        private ConfigBuilder() {
        }

        public ConfigBuilder withConfig(Config config) {
            this.convertTableAccess = config.isConvertTableAccess();
            this.decorrelationEnabled = config.isDecorrelationEnabled();
            this.trimUnusedFields = config.isTrimUnusedFields();
            this.createValuesRel = config.isCreateValuesRel();
            this.explain = config.isExplain();
            this.expand = config.isExpand();
            this.inSubQueryThreshold = config.getInSubQueryThreshold();
            return this;
        }

        public ConfigBuilder withConvertTableAccess(boolean convertTableAccess) {
            this.convertTableAccess = convertTableAccess;
            return this;
        }

        public ConfigBuilder withDecorrelationEnabled(boolean enabled) {
            this.decorrelationEnabled = enabled;
            return this;
        }

        public ConfigBuilder withTrimUnusedFields(boolean trimUnusedFields) {
            this.trimUnusedFields = trimUnusedFields;
            return this;
        }

        public ConfigBuilder withCreateValuesRel(boolean createValuesRel) {
            this.createValuesRel = createValuesRel;
            return this;
        }

        public ConfigBuilder withExplain(boolean explain) {
            this.explain = explain;
            return this;
        }

        public ConfigBuilder withExpand(boolean expand) {
            this.expand = expand;
            return this;
        }

        @Deprecated
        public ConfigBuilder withInSubqueryThreshold(int inSubQueryThreshold) {
            return this.withInSubQueryThreshold(inSubQueryThreshold);
        }

        public ConfigBuilder withInSubQueryThreshold(int inSubQueryThreshold) {
            this.inSubQueryThreshold = inSubQueryThreshold;
            return this;
        }

        public Config build() {
            return new ConfigImpl(this.convertTableAccess, this.decorrelationEnabled, this.trimUnusedFields, this.createValuesRel, this.explain, this.expand, this.inSubQueryThreshold);
        }
    }

    public static interface Config {
        public static final Config DEFAULT = SqlToRelConverter.configBuilder().build();

        public boolean isConvertTableAccess();

        public boolean isDecorrelationEnabled();

        public boolean isTrimUnusedFields();

        public boolean isCreateValuesRel();

        public boolean isExplain();

        public boolean isExpand();

        public int getInSubQueryThreshold();
    }

    private static class CorrelationUse {
        private final CorrelationId id;
        private final ImmutableBitSet requiredColumns;
        private final RelNode r;

        CorrelationUse(CorrelationId id, ImmutableBitSet requiredColumns, RelNode r) {
            this.id = id;
            this.requiredColumns = requiredColumns;
            this.r = r;
        }
    }

    private static class AggregateFinder
    extends SqlBasicVisitor<Void> {
        final SqlNodeList list = new SqlNodeList(SqlParserPos.ZERO);

        private AggregateFinder() {
        }

        @Override
        public Void visit(SqlCall call) {
            if (call.getOperator().getKind() == SqlKind.OVER) {
                return null;
            }
            if (call.getOperator().isAggregator()) {
                this.list.add(call);
                return null;
            }
            if (call instanceof SqlSelect) {
                return null;
            }
            return call.getOperator().acceptCall(this, call);
        }
    }

    private static class SubQuery {
        final SqlNode node;
        final RelOptUtil.Logic logic;
        RexNode expr;

        private SubQuery(SqlNode node, RelOptUtil.Logic logic) {
            this.node = node;
            this.logic = logic;
        }
    }

    private class HistogramShuttle
    extends RexShuttle {
        static final boolean ENABLE_HISTOGRAM_AGG = false;
        private final List<RexNode> partitionKeys;
        private final ImmutableList<RexFieldCollation> orderKeys;
        private final RexWindowBound lowerBound;
        private final RexWindowBound upperBound;
        private final SqlWindow window;
        private final boolean distinct;

        HistogramShuttle(List<RexNode> partitionKeys, ImmutableList<RexFieldCollation> orderKeys, RexWindowBound lowerBound, RexWindowBound upperBound, SqlWindow window, boolean distinct) {
            this.partitionKeys = partitionKeys;
            this.orderKeys = orderKeys;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.window = window;
            this.distinct = distinct;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            SqlOperator op = call.getOperator();
            if (!(op instanceof SqlAggFunction)) {
                return super.visitCall(call);
            }
            SqlAggFunction aggOp = (SqlAggFunction)op;
            RelDataType type = call.getType();
            List<RexNode> exprs = call.getOperands();
            SqlOperator histogramOp = null;
            if (histogramOp != null) {
                boolean reinterpretCast;
                RelDataType histogramType = this.computeHistogramType(type);
                boolean bl = reinterpretCast = type.getSqlTypeName() == SqlTypeName.DECIMAL;
                if (histogramType != type) {
                    exprs = new ArrayList<RexNode>(exprs);
                    exprs.set(0, reinterpretCast ? SqlToRelConverter.this.rexBuilder.makeReinterpretCast(histogramType, exprs.get(0), SqlToRelConverter.this.rexBuilder.makeLiteral(false)) : SqlToRelConverter.this.rexBuilder.makeCast(histogramType, exprs.get(0)));
                }
                RexCallBinding bind = new RexCallBinding(SqlToRelConverter.this.rexBuilder.getTypeFactory(), SqlStdOperatorTable.HISTOGRAM_AGG, exprs, (List<RelCollation>)ImmutableList.of());
                RexNode over = SqlToRelConverter.this.rexBuilder.makeOver(SqlStdOperatorTable.HISTOGRAM_AGG.inferReturnType(bind), SqlStdOperatorTable.HISTOGRAM_AGG, exprs, this.partitionKeys, this.orderKeys, this.lowerBound, this.upperBound, this.window.isRows(), this.window.isAllowPartial(), false, this.distinct);
                RexNode histogramCall = SqlToRelConverter.this.rexBuilder.makeCall(histogramType, histogramOp, (List<RexNode>)ImmutableList.of((Object)over));
                if (histogramType != type) {
                    histogramCall = reinterpretCast ? SqlToRelConverter.this.rexBuilder.makeReinterpretCast(type, histogramCall, SqlToRelConverter.this.rexBuilder.makeLiteral(false)) : SqlToRelConverter.this.rexBuilder.makeCast(type, histogramCall);
                }
                return histogramCall;
            }
            boolean needSum0 = aggOp == SqlStdOperatorTable.SUM && type.isNullable();
            SqlAggFunction aggOpToUse = needSum0 ? SqlStdOperatorTable.SUM0 : aggOp;
            return SqlToRelConverter.this.rexBuilder.makeOver(type, aggOpToUse, exprs, this.partitionKeys, this.orderKeys, this.lowerBound, this.upperBound, this.window.isRows(), this.window.isAllowPartial(), needSum0, this.distinct);
        }

        SqlFunction getHistogramOp(SqlAggFunction aggFunction) {
            if (aggFunction == SqlStdOperatorTable.MIN) {
                return SqlStdOperatorTable.HISTOGRAM_MIN;
            }
            if (aggFunction == SqlStdOperatorTable.MAX) {
                return SqlStdOperatorTable.HISTOGRAM_MAX;
            }
            if (aggFunction == SqlStdOperatorTable.FIRST_VALUE) {
                return SqlStdOperatorTable.HISTOGRAM_FIRST_VALUE;
            }
            if (aggFunction == SqlStdOperatorTable.LAST_VALUE) {
                return SqlStdOperatorTable.HISTOGRAM_LAST_VALUE;
            }
            return null;
        }

        private RelDataType computeHistogramType(RelDataType type) {
            if (SqlTypeUtil.isExactNumeric(type) && type.getSqlTypeName() != SqlTypeName.BIGINT) {
                return SqlToRelConverter.this.typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
            if (SqlTypeUtil.isApproximateNumeric(type) && type.getSqlTypeName() != SqlTypeName.DOUBLE) {
                return SqlToRelConverter.this.typeFactory.createSqlType(SqlTypeName.DOUBLE);
            }
            return type;
        }
    }

    private static class LookupContext {
        private final List<Pair<RelNode, Integer>> relOffsetList = new ArrayList<Pair<RelNode, Integer>>();

        LookupContext(Blackboard bb, List<RelNode> rels, int systemFieldCount) {
            bb.flatten(rels, systemFieldCount, new int[]{0}, this.relOffsetList);
        }

        Pair<RelNode, Integer> findRel(int offset) {
            return this.relOffsetList.get(offset);
        }
    }

    protected class AggConverter
    implements SqlVisitor<Void> {
        private final Blackboard bb;
        public final AggregatingSelectScope aggregatingSelectScope;
        private final Map<String, String> nameMap = Maps.newHashMap();
        private final SqlNodeList groupExprs = new SqlNodeList(SqlParserPos.ZERO);
        private final Map<SqlNode, Ord<AuxiliaryConverter>> auxiliaryGroupExprs = new HashMap<SqlNode, Ord<AuxiliaryConverter>>();
        private final List<Pair<RexNode, String>> convertedInputExprs = new ArrayList<Pair<RexNode, String>>();
        private final List<RexNode> midExprs = new ArrayList<RexNode>();
        private final List<AggregateCall> aggCalls = new ArrayList<AggregateCall>();
        private final Map<SqlNode, RexNode> aggMapping = new HashMap<SqlNode, RexNode>();
        private final Map<AggregateCall, RexNode> aggCallMapping = new HashMap<AggregateCall, RexNode>();
        private boolean inOver = false;

        public AggConverter(Blackboard bb, SqlSelect select) {
            this.bb = bb;
            this.aggregatingSelectScope = (AggregatingSelectScope)bb.getValidator().getSelectScope(select);
            SqlNodeList selectList = select.getSelectList();
            for (int i = 0; i < selectList.size(); ++i) {
                SqlNode selectItem = selectList.get(i);
                String name = null;
                if (SqlUtil.isCallTo(selectItem, SqlStdOperatorTable.AS)) {
                    SqlCall call = (SqlCall)selectItem;
                    selectItem = call.operand(0);
                    name = ((SqlNode)call.operand(1)).toString();
                }
                if (name == null) {
                    name = SqlToRelConverter.this.validator.deriveAlias(selectItem, i);
                }
                this.nameMap.put(selectItem.toString(), name);
            }
        }

        public int addGroupExpr(SqlNode expr) {
            int ref = this.lookupGroupExpr(expr);
            if (ref >= 0) {
                return ref;
            }
            int index = this.groupExprs.size();
            this.groupExprs.add(expr);
            String name = this.nameMap.get(expr.toString());
            RexNode convExpr = this.bb.convertExpression(expr);
            this.addExpr(convExpr, name);
            if (expr instanceof SqlCall) {
                SqlCall call = (SqlCall)expr;
                for (Pair<SqlNode, AuxiliaryConverter> p : SqlStdOperatorTable.convertGroupToAuxiliaryCalls(call)) {
                    this.addAuxiliaryGroupExpr((SqlNode)p.left, index, (AuxiliaryConverter)p.right);
                }
            }
            return index;
        }

        void addAuxiliaryGroupExpr(SqlNode node, int index, AuxiliaryConverter converter) {
            for (SqlNode node2 : this.auxiliaryGroupExprs.keySet()) {
                if (!node2.equalsDeep(node, Litmus.IGNORE)) continue;
                return;
            }
            this.auxiliaryGroupExprs.put(node, (Ord<AuxiliaryConverter>)Ord.of((int)index, (Object)converter));
        }

        private void addExpr(RexNode expr, String name) {
            if (name == null && expr instanceof RexInputRef) {
                int i = ((RexInputRef)expr).getIndex();
                name = this.bb.root.getRowType().getFieldList().get(i).getName();
            }
            if (Pair.right(this.convertedInputExprs).contains(name)) {
                name = null;
            }
            this.convertedInputExprs.add(Pair.of(expr, name));
        }

        @Override
        public Void visit(SqlIdentifier id) {
            return null;
        }

        @Override
        public Void visit(SqlNodeList nodeList) {
            for (int i = 0; i < nodeList.size(); ++i) {
                nodeList.get(i).accept(this);
            }
            return null;
        }

        @Override
        public Void visit(SqlLiteral lit) {
            return null;
        }

        @Override
        public Void visit(SqlDataTypeSpec type) {
            return null;
        }

        @Override
        public Void visit(SqlDynamicParam param) {
            return null;
        }

        @Override
        public Void visit(SqlIntervalQualifier intervalQualifier) {
            return null;
        }

        @Override
        public Void visit(SqlCall call) {
            switch (call.getKind()) {
                case FILTER: {
                    this.translateAgg((SqlCall)call.operand(0), (SqlNode)call.operand(1), call);
                    return null;
                }
                case SELECT: {
                    return null;
                }
            }
            boolean prevInOver = this.inOver;
            if (call.getOperator().getKind() == SqlKind.OVER) {
                this.inOver = true;
            }
            if (call.getOperator().isAggregator()) {
                if (this.inOver) {
                    this.inOver = false;
                } else {
                    this.translateAgg(call, null, call);
                    return null;
                }
            }
            for (SqlNode operand : call.getOperandList()) {
                if (operand == null) continue;
                operand.accept(this);
            }
            this.inOver = prevInOver;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void translateAgg(SqlCall call, SqlNode filter, SqlCall outerCall) {
            assert (this.bb.agg == this);
            ArrayList<Integer> args = new ArrayList<Integer>();
            int filterArg = -1;
            ArrayList<RelDataType> argTypes = call.getOperator() instanceof SqlCountAggFunction ? new ArrayList<RelDataType>(call.getOperandList().size()) : null;
            try {
                this.bb.agg = null;
                for (SqlNode operand : call.getOperandList()) {
                    SqlIdentifier id;
                    if (operand instanceof SqlIdentifier && (id = (SqlIdentifier)operand).isStar()) {
                        assert (call.operandCount() == 1);
                        assert (args.isEmpty());
                        break;
                    }
                    RexNode convertedExpr = this.bb.convertExpression(operand);
                    assert (convertedExpr != null);
                    if (argTypes != null) {
                        argTypes.add(convertedExpr.getType());
                    }
                    args.add(this.lookupOrCreateGroupExpr(convertedExpr));
                }
                if (filter != null) {
                    RexNode convertedExpr = this.bb.convertExpression(filter);
                    assert (convertedExpr != null);
                    if (convertedExpr.getType().isNullable()) {
                        convertedExpr = SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, convertedExpr);
                    }
                    filterArg = this.lookupOrCreateGroupExpr(convertedExpr);
                }
            }
            finally {
                this.bb.agg = this;
            }
            SqlAggFunction aggFunction = (SqlAggFunction)call.getOperator();
            RelDataType type = SqlToRelConverter.this.validator.deriveType(this.bb.scope, call);
            boolean distinct = false;
            SqlLiteral quantifier = call.getFunctionQuantifier();
            if (null != quantifier && quantifier.getValue() == SqlSelectKeyword.DISTINCT) {
                distinct = true;
            }
            AggregateCall aggCall = AggregateCall.create(aggFunction, distinct, args, filterArg, type, this.nameMap.get(outerCall.toString()));
            AggregatingSelectScope.Resolved r = (AggregatingSelectScope.Resolved)this.aggregatingSelectScope.resolved.get();
            RexNode rex = SqlToRelConverter.this.rexBuilder.addAggCall(aggCall, this.groupExprs.size(), r.indicator, this.aggCalls, this.aggCallMapping, argTypes);
            this.aggMapping.put(outerCall, rex);
        }

        private int lookupOrCreateGroupExpr(RexNode expr) {
            int index = 0;
            for (RexNode convertedInputExpr : Pair.left(this.convertedInputExprs)) {
                if (expr.toString().equals(convertedInputExpr.toString())) {
                    return index;
                }
                ++index;
            }
            this.addExpr(expr, null);
            return index;
        }

        public int lookupGroupExpr(SqlNode expr) {
            for (int i = 0; i < this.groupExprs.size(); ++i) {
                SqlNode groupExpr = this.groupExprs.get(i);
                if (!expr.equalsDeep(groupExpr, Litmus.IGNORE)) continue;
                return i;
            }
            return -1;
        }

        public RexNode lookupAggregates(SqlCall call) {
            assert (this.bb.agg == this);
            switch (call.getKind()) {
                case GROUP_ID: 
                case GROUPING: {
                    List<Object> operands;
                    RelDataType type = SqlToRelConverter.this.validator.getValidatedNodeType(call);
                    if (!((AggregatingSelectScope.Resolved)this.aggregatingSelectScope.resolved.get()).indicator) {
                        return SqlToRelConverter.this.rexBuilder.makeExactLiteral(TWO.pow(this.effectiveArgCount(call)).subtract(BigDecimal.ONE), type);
                    }
                    switch (call.getKind()) {
                        case GROUP_ID: {
                            operands = ImmutableIntList.range(0, this.groupExprs.size());
                            break;
                        }
                        default: {
                            operands = Lists.newArrayList();
                            for (SqlNode operand : call.getOperandList()) {
                                int x = this.lookupGroupExpr(operand);
                                assert (x >= 0);
                                operands.add(x);
                            }
                        }
                    }
                    RexNode node = null;
                    int shift = operands.size();
                    Iterator<Object> iterator = operands.iterator();
                    while (iterator.hasNext()) {
                        int operand = (Integer)iterator.next();
                        node = this.bitValue(node, type, operand, --shift);
                    }
                    return node;
                }
            }
            for (Map.Entry<SqlNode, Ord<AuxiliaryConverter>> e : this.auxiliaryGroupExprs.entrySet()) {
                if (!call.equalsDeep(e.getKey(), Litmus.IGNORE)) continue;
                AuxiliaryConverter converter = (AuxiliaryConverter)e.getValue().e;
                int groupOrdinal = e.getValue().i;
                return converter.convert(SqlToRelConverter.this.rexBuilder, (RexNode)this.convertedInputExprs.get((int)groupOrdinal).left, SqlToRelConverter.this.rexBuilder.makeInputRef(this.bb.root, groupOrdinal));
            }
            return this.aggMapping.get(call);
        }

        private int effectiveArgCount(SqlCall call) {
            switch (call.getKind()) {
                case GROUPING: {
                    return call.operandCount();
                }
                case GROUP_ID: {
                    return this.groupExprs.size();
                }
            }
            throw new AssertionError((Object)call.getKind());
        }

        private RexNode bitValue(RexNode previous, RelDataType type, int x, int shift) {
            AggregatingSelectScope.Resolved r = (AggregatingSelectScope.Resolved)this.aggregatingSelectScope.resolved.get();
            RexNode node = SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, SqlToRelConverter.this.rexBuilder.makeInputRef(this.bb.root, r.groupExprList.size() + x), SqlToRelConverter.this.rexBuilder.makeExactLiteral(BigDecimal.ONE, type), SqlToRelConverter.this.rexBuilder.makeExactLiteral(BigDecimal.ZERO, type));
            if (shift > 0) {
                node = SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, node, SqlToRelConverter.this.rexBuilder.makeExactLiteral(TWO.pow(shift), type));
            }
            if (previous != null) {
                node = SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, previous, node);
            }
            return node;
        }

        public List<Pair<RexNode, String>> getPreExprs() {
            return this.convertedInputExprs;
        }

        public List<AggregateCall> getAggCalls() {
            return this.aggCalls;
        }

        public RelDataTypeFactory getTypeFactory() {
            return SqlToRelConverter.this.typeFactory;
        }
    }

    private class NoOpSubQueryConverter
    implements SubQueryConverter {
        private NoOpSubQueryConverter() {
        }

        @Override
        public boolean canConvertSubQuery() {
            return false;
        }

        @Override
        public RexNode convertSubQuery(SqlCall subQuery, SqlToRelConverter parentConverter, boolean isExists, boolean isExplain) {
            throw new IllegalArgumentException();
        }
    }

    private static class DeferredLookup {
        Blackboard bb;
        String originalRelName;

        DeferredLookup(Blackboard bb, String originalRelName) {
            this.bb = bb;
            this.originalRelName = originalRelName;
        }

        public RexFieldAccess getFieldAccess(CorrelationId name) {
            return (RexFieldAccess)this.bb.mapCorrelateToRex.get(name);
        }

        public String getOriginalRelName() {
            return this.originalRelName;
        }
    }

    protected class Blackboard
    implements SqlRexContext,
    SqlVisitor<RexNode> {
        public final SqlValidatorScope scope;
        private final Map<String, RexNode> nameToNodeMap;
        public RelNode root;
        private List<RelNode> inputs;
        private final Map<CorrelationId, RexFieldAccess> mapCorrelateToRex = new HashMap<CorrelationId, RexFieldAccess>();
        private boolean isPatternVarRef = false;
        final List<RelNode> cursors = new ArrayList<RelNode>();
        private final Set<SubQuery> subQueryList = new LinkedHashSet<SubQuery>();
        AggConverter agg;
        SqlWindow window;
        private final Map<RelNode, Map<Integer, Integer>> mapRootRelToFieldProjection = new HashMap<RelNode, Map<Integer, Integer>>();
        private final List<SqlMonotonicity> columnMonotonicities = new ArrayList<SqlMonotonicity>();
        private final List<RelDataTypeField> systemFieldList = new ArrayList<RelDataTypeField>();
        final boolean top;
        private final InitializerExpressionFactory initializerExpressionFactory = new NullInitializerExpressionFactory();

        protected Blackboard(SqlValidatorScope scope, Map<String, RexNode> nameToNodeMap, boolean top) {
            this.scope = scope;
            this.nameToNodeMap = nameToNodeMap;
            this.top = top;
        }

        public void setPatternVarRef(boolean isVarRef) {
            this.isPatternVarRef = isVarRef;
        }

        public RexNode register(RelNode rel, JoinRelType joinType) {
            return this.register(rel, joinType, null);
        }

        public RexNode register(RelNode rel, JoinRelType joinType, List<RexNode> leftKeys) {
            RexNode joinCond;
            assert (joinType != null);
            if (this.root == null) {
                assert (leftKeys == null);
                this.setRoot(rel, false);
                return SqlToRelConverter.this.rexBuilder.makeRangeReference(this.root.getRowType(), 0, false);
            }
            final int origLeftInputCount = this.root.getRowType().getFieldCount();
            if (leftKeys != null) {
                ArrayList newLeftInputExpr = Lists.newArrayList();
                for (int i = 0; i < origLeftInputCount; ++i) {
                    newLeftInputExpr.add(SqlToRelConverter.this.rexBuilder.makeInputRef(this.root, i));
                }
                ArrayList leftJoinKeys = Lists.newArrayList();
                for (RexNode leftKey : leftKeys) {
                    int index = newLeftInputExpr.indexOf(leftKey);
                    if (index < 0 || joinType == JoinRelType.LEFT) {
                        index = newLeftInputExpr.size();
                        newLeftInputExpr.add(leftKey);
                    }
                    leftJoinKeys.add(index);
                }
                RelNode newLeftInput = RelOptUtil.createProject(this.root, newLeftInputExpr, null, true);
                if (this.mapRootRelToFieldProjection.containsKey(this.root)) {
                    this.mapRootRelToFieldProjection.put(newLeftInput, this.mapRootRelToFieldProjection.get(this.root));
                }
                this.setRoot(newLeftInput, false);
                int rightOffset = this.root.getRowType().getFieldCount() - newLeftInput.getRowType().getFieldCount();
                List<Integer> rightKeys = Util.range(rightOffset, rightOffset + leftKeys.size());
                joinCond = RelOptUtil.createEquiJoinCondition(newLeftInput, leftJoinKeys, rel, rightKeys, SqlToRelConverter.this.rexBuilder);
            } else {
                joinCond = SqlToRelConverter.this.rexBuilder.makeLiteral(true);
            }
            int leftFieldCount = this.root.getRowType().getFieldCount();
            final RelNode join = SqlToRelConverter.this.createJoin(this, this.root, rel, joinCond, joinType);
            this.setRoot(join, false);
            if (leftKeys != null && joinType == JoinRelType.LEFT) {
                int leftKeyCount = leftKeys.size();
                int rightFieldLength = rel.getRowType().getFieldCount();
                assert (leftKeyCount == rightFieldLength - 1);
                final int rexRangeRefLength = leftKeyCount + rightFieldLength;
                RelDataType returnType = SqlToRelConverter.this.typeFactory.createStructType((List<? extends Map.Entry<String, RelDataType>>)new AbstractList<Map.Entry<String, RelDataType>>(){

                    @Override
                    public Map.Entry<String, RelDataType> get(int index) {
                        return join.getRowType().getFieldList().get(origLeftInputCount + index);
                    }

                    @Override
                    public int size() {
                        return rexRangeRefLength;
                    }
                });
                return SqlToRelConverter.this.rexBuilder.makeRangeReference(returnType, origLeftInputCount, false);
            }
            return SqlToRelConverter.this.rexBuilder.makeRangeReference(rel.getRowType(), leftFieldCount, joinType.generatesNullsOnRight());
        }

        public void setRoot(RelNode root, boolean leaf) {
            this.setRoot(Collections.singletonList(root), root, root instanceof LogicalJoin);
            if (leaf) {
                SqlToRelConverter.this.leaves.add(root);
            }
            this.columnMonotonicities.clear();
        }

        private void setRoot(List<RelNode> inputs, RelNode root, boolean hasSystemFields) {
            this.inputs = inputs;
            this.root = root;
            this.systemFieldList.clear();
            if (hasSystemFields) {
                this.systemFieldList.addAll(SqlToRelConverter.this.getSystemFields());
            }
        }

        public void setDataset(String datasetName) {
        }

        void setRoot(List<RelNode> inputs) {
            this.setRoot(inputs, null, false);
        }

        Pair<RexNode, Map<String, Integer>> lookupExp(SqlQualified qualified) {
            boolean isParent;
            if (this.nameToNodeMap != null && qualified.prefixLength == 1) {
                RexNode node = this.nameToNodeMap.get(qualified.identifier.names.get(0));
                if (node == null) {
                    throw new AssertionError((Object)("Unknown identifier '" + qualified.identifier + "' encountered while expanding expression"));
                }
                return Pair.of(node, null);
            }
            SqlNameMatcher nameMatcher = this.scope.getValidator().getCatalogReader().nameMatcher();
            SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
            this.scope.resolve(qualified.prefix(), nameMatcher, false, resolved);
            if (resolved.count() != 1) {
                return null;
            }
            SqlValidatorScope.Resolve resolve = resolved.only();
            RelDataType rowType = resolve.rowType();
            SqlValidatorScope ancestorScope = resolve.scope;
            boolean bl = isParent = ancestorScope != this.scope;
            if (this.inputs != null && !isParent) {
                LookupContext rels = new LookupContext(this, this.inputs, this.systemFieldList.size());
                RexNode node = this.lookup(resolve.path.steps().get((int)0).i, rels);
                if (node == null) {
                    return null;
                }
                return Pair.of(node, null);
            }
            DeferredLookup lookup = new DeferredLookup(this, (String)qualified.identifier.names.get(0));
            CorrelationId correlId = SqlToRelConverter.this.cluster.createCorrel();
            SqlToRelConverter.this.mapCorrelToDeferred.put(correlId, lookup);
            if (resolve.path.steps().get((int)0).i < 0) {
                return Pair.of(SqlToRelConverter.this.rexBuilder.makeCorrel(rowType, correlId), null);
            }
            RelDataTypeFactory.FieldInfoBuilder builder = SqlToRelConverter.this.typeFactory.builder();
            ListScope ancestorScope1 = (ListScope)resolve.scope;
            ImmutableMap.Builder fields = ImmutableMap.builder();
            int i = 0;
            int offset = 0;
            for (SqlValidatorNamespace c : ancestorScope1.getChildren()) {
                builder.addAll(c.getRowType().getFieldList());
                if (i == resolve.path.steps().get((int)0).i) {
                    for (RelDataTypeField field : c.getRowType().getFieldList()) {
                        fields.put((Object)c.translate(field.getName()), (Object)(field.getIndex() + offset));
                    }
                }
                ++i;
                offset += c.getRowType().getFieldCount();
            }
            RexNode c = SqlToRelConverter.this.rexBuilder.makeCorrel(builder.uniquify().build(), correlId);
            return Pair.of(c, fields.build());
        }

        RexNode lookup(int offset, LookupContext lookupContext) {
            Pair<RelNode, Integer> pair = lookupContext.findRel(offset);
            return SqlToRelConverter.this.rexBuilder.makeRangeReference(((RelNode)pair.left).getRowType(), (Integer)pair.right, false);
        }

        RelDataTypeField getRootField(RexInputRef inputRef) {
            int fieldOffset = inputRef.getIndex();
            for (RelNode input : this.inputs) {
                RelDataType rowType = input.getRowType();
                if (rowType == null) {
                    return null;
                }
                if (fieldOffset < rowType.getFieldCount()) {
                    return rowType.getFieldList().get(fieldOffset);
                }
                fieldOffset -= rowType.getFieldCount();
            }
            throw new AssertionError();
        }

        public void flatten(List<RelNode> rels, int systemFieldCount, int[] start, List<Pair<RelNode, Integer>> relOffsetList) {
            for (RelNode rel : rels) {
                if (SqlToRelConverter.this.leaves.contains(rel) || rel instanceof LogicalMatch) {
                    relOffsetList.add(Pair.of(rel, start[0]));
                    start[0] = start[0] + rel.getRowType().getFieldCount();
                    continue;
                }
                if (rel instanceof LogicalJoin || rel instanceof LogicalAggregate) {
                    start[0] = start[0] + systemFieldCount;
                }
                this.flatten(rel.getInputs(), systemFieldCount, start, relOffsetList);
            }
        }

        void registerSubQuery(SqlNode node, RelOptUtil.Logic logic) {
            for (SubQuery subQuery : this.subQueryList) {
                if (!node.equalsDeep(subQuery.node, Litmus.IGNORE)) continue;
                return;
            }
            this.subQueryList.add(new SubQuery(node, logic));
        }

        SubQuery getSubQuery(SqlNode expr) {
            for (SubQuery subQuery : this.subQueryList) {
                if (!expr.equalsDeep(subQuery.node, Litmus.IGNORE)) continue;
                return subQuery;
            }
            return null;
        }

        ImmutableList<RelNode> retrieveCursors() {
            try {
                ImmutableList immutableList = ImmutableList.copyOf(this.cursors);
                return immutableList;
            }
            finally {
                this.cursors.clear();
            }
        }

        @Override
        public RexNode convertExpression(SqlNode expr) {
            RexNode rex;
            if (this.agg != null) {
                RexNode rex2;
                SqlNode expandedGroupExpr = SqlToRelConverter.this.validator.expand(expr, this.scope);
                int ref = this.agg.lookupGroupExpr(expandedGroupExpr);
                if (ref >= 0) {
                    return SqlToRelConverter.this.rexBuilder.makeInputRef(this.root, ref);
                }
                if (expr instanceof SqlCall && (rex2 = this.agg.lookupAggregates((SqlCall)expr)) != null) {
                    return rex2;
                }
            }
            if ((rex = SqlToRelConverter.this.convertExtendedExpression(expr, this)) != null) {
                return rex;
            }
            SqlKind kind = expr.getKind();
            if (!SqlToRelConverter.this.config.isExpand()) {
                switch (kind) {
                    case IN: {
                        Object nodes;
                        SqlCall call = (SqlCall)expr;
                        Object query = call.operand(1);
                        if (query instanceof SqlNodeList) break;
                        SqlInOperator op = (SqlInOperator)call.getOperator();
                        RelRoot root = SqlToRelConverter.this.convertQueryRecursive((SqlNode)query, false, null);
                        Object operand = call.operand(0);
                        switch (((SqlNode)operand).getKind()) {
                            case ROW: {
                                nodes = ((SqlCall)operand).getOperandList();
                                break;
                            }
                            default: {
                                nodes = ImmutableList.of(operand);
                            }
                        }
                        ImmutableList.Builder builder = ImmutableList.builder();
                        Iterator iterator = nodes.iterator();
                        while (iterator.hasNext()) {
                            SqlNode node = (SqlNode)iterator.next();
                            builder.add((Object)this.convertExpression(node));
                        }
                        RexSubQuery in = RexSubQuery.in(root.rel, (ImmutableList<RexNode>)builder.build());
                        return op.isNotIn() ? SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, in) : in;
                    }
                    case EXISTS: {
                        SqlCall call = (SqlCall)expr;
                        SqlNode query = (SqlNode)Iterables.getOnlyElement(call.getOperandList());
                        RelRoot root = SqlToRelConverter.this.convertQueryRecursive(query, false, null);
                        RelNode rel = root.rel;
                        while (rel instanceof Project || rel instanceof Sort && ((Sort)rel).fetch == null && ((Sort)rel).offset == null) {
                            rel = ((SingleRel)rel).getInput();
                        }
                        return RexSubQuery.exists(rel);
                    }
                    case SCALAR_QUERY: {
                        SqlCall call = (SqlCall)expr;
                        SqlNode query = (SqlNode)Iterables.getOnlyElement(call.getOperandList());
                        RelRoot root = SqlToRelConverter.this.convertQueryRecursive(query, false, null);
                        return RexSubQuery.scalar(root.rel);
                    }
                }
            }
            switch (kind) {
                case CURSOR: 
                case IN: {
                    SubQuery subQuery = (SubQuery)Preconditions.checkNotNull((Object)this.getSubQuery(expr));
                    rex = (RexNode)Preconditions.checkNotNull((Object)subQuery.expr);
                    return StandardConvertletTable.castToValidatedType(expr, rex, SqlToRelConverter.this.validator, SqlToRelConverter.this.rexBuilder);
                }
                case SELECT: 
                case EXISTS: 
                case SCALAR_QUERY: {
                    SubQuery subQuery = this.getSubQuery(expr);
                    assert (subQuery != null);
                    rex = subQuery.expr;
                    assert (rex != null) : "rex != null";
                    if ((kind == SqlKind.SCALAR_QUERY || kind == SqlKind.EXISTS) && this.isConvertedSubq(rex)) {
                        return rex;
                    }
                    RexNode fieldAccess = SqlToRelConverter.this.rexBuilder.makeFieldAccess(rex, rex.getType().getFieldCount() - 1);
                    if (fieldAccess.getType().isNullable() && kind == SqlKind.EXISTS) {
                        fieldAccess = SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, fieldAccess);
                    }
                    return fieldAccess;
                }
                case OVER: {
                    return SqlToRelConverter.this.convertOver(this, expr);
                }
            }
            rex = expr.accept(this);
            return (RexNode)Preconditions.checkNotNull((Object)rex);
        }

        public RexNode convertSortExpression(SqlNode expr, Set<SqlKind> flags) {
            switch (expr.getKind()) {
                case DESCENDING: 
                case NULLS_FIRST: 
                case NULLS_LAST: {
                    flags.add(expr.getKind());
                    Object operand = ((SqlCall)expr).operand(0);
                    return this.convertSortExpression((SqlNode)operand, flags);
                }
            }
            return this.convertExpression(expr);
        }

        private boolean isConvertedSubq(RexNode rex) {
            RexNode operand;
            RexCall call;
            if (rex instanceof RexLiteral || rex instanceof RexDynamicParam) {
                return true;
            }
            return rex instanceof RexCall && (call = (RexCall)rex).getOperator() == SqlStdOperatorTable.CAST && (operand = call.getOperands().get(0)) instanceof RexLiteral;
        }

        @Override
        public int getGroupCount() {
            if (this.agg != null) {
                return this.agg.groupExprs.size();
            }
            if (this.window != null) {
                return this.window.isAlwaysNonEmpty() ? 1 : 0;
            }
            return -1;
        }

        @Override
        public RexBuilder getRexBuilder() {
            return SqlToRelConverter.this.rexBuilder;
        }

        @Override
        public RexRangeRef getSubQueryExpr(SqlCall call) {
            SubQuery subQuery = this.getSubQuery(call);
            assert (subQuery != null);
            return (RexRangeRef)subQuery.expr;
        }

        @Override
        public RelDataTypeFactory getTypeFactory() {
            return SqlToRelConverter.this.typeFactory;
        }

        @Override
        public InitializerExpressionFactory getInitializerExpressionFactory() {
            return this.initializerExpressionFactory;
        }

        @Override
        public SqlValidator getValidator() {
            return SqlToRelConverter.this.validator;
        }

        @Override
        public RexNode convertLiteral(SqlLiteral literal) {
            return SqlToRelConverter.this.exprConverter.convertLiteral(this, literal);
        }

        public RexNode convertInterval(SqlIntervalQualifier intervalQualifier) {
            return SqlToRelConverter.this.exprConverter.convertInterval(this, intervalQualifier);
        }

        @Override
        public RexNode visit(SqlLiteral literal) {
            return SqlToRelConverter.this.exprConverter.convertLiteral(this, literal);
        }

        @Override
        public RexNode visit(SqlCall call) {
            if (this.agg != null) {
                SqlOperator op = call.getOperator();
                if (this.window == null && (op.isAggregator() || op.getKind() == SqlKind.FILTER)) {
                    return this.agg.lookupAggregates(call);
                }
            }
            return SqlToRelConverter.this.exprConverter.convertCall(this, new SqlCallBinding(SqlToRelConverter.this.validator, this.scope, call).permutedCall());
        }

        @Override
        public RexNode visit(SqlNodeList nodeList) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RexNode visit(SqlIdentifier id) {
            return SqlToRelConverter.this.convertIdentifier(this, id);
        }

        @Override
        public RexNode visit(SqlDataTypeSpec type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RexNode visit(SqlDynamicParam param) {
            return SqlToRelConverter.this.convertDynamicParam(param);
        }

        @Override
        public RexNode visit(SqlIntervalQualifier intervalQualifier) {
            return this.convertInterval(intervalQualifier);
        }

        public List<SqlMonotonicity> getColumnMonotonicities() {
            return this.columnMonotonicities;
        }
    }
}

