/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Optional;
import java.io.IOException;

public class GuavaOptionalDeserializer
extends StdDeserializer<Optional<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _fullType;
    protected final JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public GuavaOptionalDeserializer(JavaType fullType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        super(fullType);
        this._fullType = fullType;
        this._valueTypeDeserializer = typeDeser;
        this._valueDeserializer = valueDeser;
    }

    public JavaType getValueType() {
        return this._fullType;
    }

    public Optional<?> getNullValue(DeserializationContext ctxt) {
        return Optional.absent();
    }

    @Deprecated
    public Optional<?> getNullValue() {
        return Optional.absent();
    }

    protected GuavaOptionalDeserializer withResolved(JavaType fullType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        if (this._fullType == fullType && valueDeser == this._valueDeserializer && typeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return new GuavaOptionalDeserializer(this._fullType, typeDeser, valueDeser);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        JavaType fullType = this._fullType;
        if (deser == null) {
            JavaType refdType;
            if (property != null) {
                AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
                AnnotatedMember member = property.getMember();
                if (intr != null && member != null) {
                    fullType = intr.refineDeserializationType((MapperConfig)ctxt.getConfig(), (Annotated)member, fullType);
                }
            }
            if ((refdType = fullType.getContentType()) == null) {
                refdType = TypeFactory.unknownType();
            }
            deser = ctxt.findContextualValueDeserializer(refdType, property);
        } else {
            JavaType refdType = fullType.getContentType();
            if (refdType == null) {
                refdType = TypeFactory.unknownType();
            }
            deser = ctxt.handleSecondaryContextualization(deser, property, refdType);
        }
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        return this.withResolved(fullType, typeDeser, deser);
    }

    public Optional<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object refd = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(p, ctxt) : this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        return Optional.fromNullable((Object)refd);
    }

    public Optional<?> deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return this.getNullValue();
        }
        if (t != null && t.isScalarValue()) {
            return this.deserialize(p, ctxt);
        }
        return (Optional)typeDeserializer.deserializeTypedFromAny(p, ctxt);
    }
}

