/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file.synset;

import edu.smu.tspell.wordnet.AdjectiveSatelliteSynset;
import edu.smu.tspell.wordnet.AdjectiveSynset;
import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.WordNetException;
import edu.smu.tspell.wordnet.impl.file.RelationshipPointers;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SenseIndexEntry;
import edu.smu.tspell.wordnet.impl.file.SenseIndexReader;
import edu.smu.tspell.wordnet.impl.file.SenseKey;
import edu.smu.tspell.wordnet.impl.file.SynsetFactory;
import edu.smu.tspell.wordnet.impl.file.WordPositions;
import edu.smu.tspell.wordnet.impl.file.synset.AdjectiveReferenceSynset;

public class AdjectiveSatelliteReferenceSynset
extends AdjectiveReferenceSynset
implements AdjectiveSatelliteSynset {
    private AdjectiveSynset headSynset;

    public AdjectiveSatelliteReferenceSynset(String definition, String[] examples, SenseKey[] senseKeys, RelationshipPointers pointers, int lexFile, int offset, WordPositions positions) {
        super(SynsetType.ADJECTIVE_SATELLITE, definition, examples, senseKeys, pointers, lexFile, offset, positions);
    }

    public synchronized AdjectiveSynset getHeadSynset() throws WordNetException {
        if (this.headSynset == null) {
            this.headSynset = this.retrieveHeadSynset();
        }
        return this.headSynset;
    }

    private AdjectiveSynset retrieveHeadSynset() {
        SenseKey headKey;
        Synset synset = null;
        SenseKey senseKey = this.getSenseKey(0);
        SenseIndexEntry indexEntry = this.getIndexEntry(senseKey);
        if (indexEntry != null && (headKey = indexEntry.getSenseKey().getHeadWord()) != null) {
            SenseIndexReader reader = SenseIndexReader.getInstance();
            indexEntry = reader.getEntry(headKey.getFullSenseKeyText());
            if (indexEntry != null) {
                SynsetFactory factory = SynsetFactory.getInstance();
                synset = factory.getSynset(indexEntry.getSynsetPointer());
            } else {
                throw new RetrievalException("Unable to locate head word entry for " + headKey + " referenced by " + this);
            }
        }
        return (AdjectiveSynset)synset;
    }

    public boolean isHeadSynset() throws WordNetException {
        return false;
    }
}

