/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file.synset;

import edu.smu.tspell.wordnet.AdjectiveSynset;
import edu.smu.tspell.wordnet.NounSynset;
import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.WordNetException;
import edu.smu.tspell.wordnet.WordSense;
import edu.smu.tspell.wordnet.impl.file.ReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.RelationshipPointers;
import edu.smu.tspell.wordnet.impl.file.RelationshipType;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SenseKey;
import edu.smu.tspell.wordnet.impl.file.WordPositions;

public class AdjectiveReferenceSynset
extends ReferenceSynset
implements AdjectiveSynset {
    private WordPositions wordPositions;

    public AdjectiveReferenceSynset(String definition, String[] examples, SenseKey[] senseKeys, RelationshipPointers pointers, int lexFile, int offset, WordPositions positions) {
        this(SynsetType.ADJECTIVE, definition, examples, senseKeys, pointers, lexFile, offset, positions);
    }

    AdjectiveReferenceSynset(SynsetType type, String definition, String[] examples, SenseKey[] senseKeys, RelationshipPointers pointers, int lexFile, int offset, WordPositions positions) {
        super(type, definition, examples, senseKeys, pointers, lexFile, offset);
        this.wordPositions = positions;
    }

    public AdjectiveSynset[] getSimilar() throws RetrievalException {
        return this.getAdjectiveSynsets(RelationshipType.SIMILAR);
    }

    public WordSense getParticiple(String wordForm) throws RetrievalException {
        return this.getSingletonSense(RelationshipType.PARTICIPLE, wordForm);
    }

    public WordSense[] getPertainyms(String wordForm) throws RetrievalException {
        return this.getReferences(RelationshipType.PERTAINYM, wordForm);
    }

    public NounSynset[] getAttributes() throws RetrievalException {
        return this.getNounSynsets(RelationshipType.ATTRIBUTE);
    }

    public AdjectiveSynset[] getRelated() throws RetrievalException {
        return this.getRelatedConcepts();
    }

    public AdjectiveSynset[] getRelatedConcepts() throws RetrievalException {
        return this.getAdjectiveSynsets(RelationshipType.ALSO_SEE);
    }

    public String getRequiredPosition(String wordForm) {
        return this.wordPositions.getRequiredPosition(wordForm);
    }

    public boolean isHeadSynset() throws WordNetException {
        return true;
    }
}

