/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.impl.ExampleSentences;
import edu.smu.tspell.wordnet.impl.file.ParseException;
import edu.smu.tspell.wordnet.impl.file.ReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.RelationshipPointers;
import edu.smu.tspell.wordnet.impl.file.RelationshipType;
import edu.smu.tspell.wordnet.impl.file.SampleFrameFactory;
import edu.smu.tspell.wordnet.impl.file.SampleIndexFactory;
import edu.smu.tspell.wordnet.impl.file.SampleTemplateFactory;
import edu.smu.tspell.wordnet.impl.file.SenseKey;
import edu.smu.tspell.wordnet.impl.file.SynsetPointer;
import edu.smu.tspell.wordnet.impl.file.SynsetTypeConverter;
import edu.smu.tspell.wordnet.impl.file.TextTranslator;
import edu.smu.tspell.wordnet.impl.file.WordPositions;
import edu.smu.tspell.wordnet.impl.file.WordSensePointer;
import edu.smu.tspell.wordnet.impl.file.synset.AdjectiveReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.synset.AdjectiveSatelliteReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.synset.AdverbReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.synset.NounReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.synset.VerbReferenceSynset;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class SynsetParser {
    private static final String FIELD_DELIMITER = " ";
    private static final String FRAME_TERMINATOR = "|";
    private static final String FRAME_HEADER = "+";
    private static final String GLOSS_DELIMITERS = "; ";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String MARKER_START = "(";
    private static final String MARKER_END = ")";
    private static final int HEX = 16;

    public Synset createSynset(String data) {
        ReferenceSynset synset;
        int sourceWord;
        String wordForm;
        StringTokenizer tokenizer = new StringTokenizer(data, FIELD_DELIMITER);
        int offset = Integer.parseInt(tokenizer.nextToken());
        int lexicalFile = Integer.parseInt(tokenizer.nextToken());
        char synsetTypeCode = tokenizer.nextToken().charAt(0);
        SynsetType synsetType = SynsetTypeConverter.getType(synsetTypeCode);
        int wordCount = Integer.parseInt(tokenizer.nextToken(), 16);
        SenseKey[] senseKeys = new SenseKey[wordCount];
        SampleIndexFactory indexFactory = SampleIndexFactory.getInstance();
        SampleTemplateFactory templateFactory = SampleTemplateFactory.getInstance();
        ExampleSentences sentences = new ExampleSentences();
        WordPositions positions = null;
        for (int i = 0; i < wordCount; ++i) {
            wordForm = TextTranslator.translateToExternalFormat(tokenizer.nextToken());
            int markerStart = wordForm.indexOf(MARKER_START);
            if (markerStart != -1) {
                int markerEnd = wordForm.indexOf(MARKER_END, markerStart);
                if (markerEnd == -1) {
                    throw new ParseException("Marker start embedded in form '" + wordForm + "' but no marker end text found.");
                }
                String position = wordForm.substring(markerStart + 1, markerEnd);
                wordForm = wordForm.substring(0, markerStart);
                if (positions == null) {
                    positions = new WordPositions();
                }
                positions.setPosition(wordForm, position);
            }
            int lexicalID = Integer.parseInt(tokenizer.nextToken(), 16);
            senseKeys[i] = new SenseKey(wordForm, synsetType, lexicalFile, lexicalID);
            String[] keyText = indexFactory.getSampleKeys(senseKeys[i]);
            String[] templates = new String[keyText.length];
            for (int j = 0; j < keyText.length; ++j) {
                templates[j] = templateFactory.getSample(synsetType, keyText[j]);
            }
            sentences.setTemplates(senseKeys[i].getLemma(), templates);
        }
        int pointerCount = Integer.parseInt(tokenizer.nextToken());
        RelationshipPointers pointers = new RelationshipPointers();
        for (int i = 0; i < pointerCount; ++i) {
            RelationshipType relationship = RelationshipType.getRelationshipType(tokenizer.nextToken());
            int targetOffset = Integer.parseInt(tokenizer.nextToken());
            char typeCode = tokenizer.nextToken().charAt(0);
            SynsetType type = SynsetTypeConverter.getType(typeCode);
            String sourceTarget = tokenizer.nextToken();
            sourceWord = Integer.parseInt(sourceTarget.substring(0, 2), 16);
            int targetWord = Integer.parseInt(sourceTarget.substring(2, 4), 16);
            if (sourceWord == 0 && targetWord == 0) {
                SynsetPointer pointer = new SynsetPointer(type, targetOffset);
                pointers.addSemanticRelationship(relationship, pointer);
                continue;
            }
            wordForm = senseKeys[sourceWord - 1].getLemma();
            WordSensePointer sensePointer = new WordSensePointer(type, targetOffset, targetWord);
            pointers.addLexicalRelationship(wordForm, relationship, sensePointer);
        }
        String nextToken = tokenizer.nextToken();
        if (!nextToken.equals(FRAME_TERMINATOR)) {
            int frameCount = Integer.parseInt(nextToken);
            SampleFrameFactory factory = SampleFrameFactory.getInstance();
            for (int i = 0; i < frameCount; ++i) {
                nextToken = tokenizer.nextToken();
                if (!nextToken.equals(FRAME_HEADER)) {
                    throw new ParseException("Expected frame header text '+' but found '" + nextToken + "' instead: " + data);
                }
                nextToken = tokenizer.nextToken();
                String frameText = factory.getSample(synsetType, nextToken);
                sourceWord = Integer.parseInt(tokenizer.nextToken(), 16);
                if (sourceWord == 0) {
                    sentences.addCommonFrame(frameText);
                    continue;
                }
                wordForm = senseKeys[sourceWord - 1].getLemma();
                sentences.addFrame(frameText, wordForm);
            }
            nextToken = tokenizer.nextToken();
        }
        if (!nextToken.equals(FRAME_TERMINATOR)) {
            throw new ParseException("Expected frame terminator text '|' but found '" + nextToken + "' instead: " + data);
        }
        String delimiterText = " | ";
        int index = data.indexOf(delimiterText);
        String glossText = data.substring(index + delimiterText.length());
        GlossContent gloss = this.parseGloss(glossText);
        String definition = gloss.getDefinition();
        String[] examples = gloss.getExamples();
        switch (synsetTypeCode) {
            case 'n': {
                synset = new NounReferenceSynset(definition, examples, senseKeys, pointers, lexicalFile, offset);
                break;
            }
            case 'v': {
                synset = new VerbReferenceSynset(definition, examples, senseKeys, pointers, sentences, lexicalFile, offset);
                break;
            }
            case 'a': {
                synset = new AdjectiveReferenceSynset(definition, examples, senseKeys, pointers, lexicalFile, offset, positions);
                break;
            }
            case 'r': {
                synset = new AdverbReferenceSynset(definition, examples, senseKeys, pointers, lexicalFile, offset);
                break;
            }
            case 's': {
                synset = new AdjectiveSatelliteReferenceSynset(definition, examples, senseKeys, pointers, lexicalFile, offset, positions);
                break;
            }
            default: {
                throw new ParseException("The synset type code '" + synsetTypeCode + "' is invalid");
            }
        }
        return synset;
    }

    private GlossContent parseGloss(String glossText) {
        String definition = null;
        ArrayList<String> exampleList = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer(glossText.trim());
        if (buffer.length() > 0) {
            int quoteIndex;
            if (!DOUBLE_QUOTE.equals(buffer.substring(0, 1))) {
                int textEnd;
                quoteIndex = buffer.indexOf(DOUBLE_QUOTE);
                if (quoteIndex == -1) {
                    quoteIndex = buffer.length();
                }
                for (textEnd = quoteIndex - 1; textEnd >= 0 && GLOSS_DELIMITERS.indexOf(buffer.charAt(textEnd)) != -1; --textEnd) {
                }
                definition = buffer.substring(0, textEnd + 1);
                buffer.delete(0, quoteIndex);
            }
            while (buffer.length() > 0) {
                String example;
                quoteIndex = buffer.indexOf(DOUBLE_QUOTE, 1);
                if (quoteIndex == -1) {
                    quoteIndex = buffer.length() - 1;
                }
                if ((example = buffer.substring(0, quoteIndex + 1)).length() > 0) {
                    exampleList.add(buffer.substring(0, quoteIndex + 1));
                }
                buffer.delete(0, quoteIndex + 1);
                while (buffer.length() > 0 && GLOSS_DELIMITERS.indexOf(buffer.charAt(0)) != -1) {
                    buffer.delete(0, 1);
                }
            }
        }
        String[] exampleArray = new String[exampleList.size()];
        exampleList.toArray(exampleArray);
        return new GlossContent(definition, exampleArray);
    }

    private static class GlossContent {
        private String definition;
        private String[] examples;

        public GlossContent(String definition, String[] examples) {
            this.definition = definition;
            this.examples = examples;
        }

        public String getDefinition() {
            return this.definition;
        }

        public String[] getExamples() {
            return this.examples;
        }
    }
}

