/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.impl.file.SenseKey;
import edu.smu.tspell.wordnet.impl.file.SynsetTypeConverter;
import edu.smu.tspell.wordnet.impl.file.TextTranslator;
import java.util.StringTokenizer;

public class SenseKeyParser {
    public SenseKey parse(String keyText) {
        int index = keyText.indexOf("%");
        String lemma = TextTranslator.translateToExternalFormat(keyText.substring(0, index));
        String lexicalSense = keyText.substring(index + 1);
        StringTokenizer tokenizer = new StringTokenizer(lexicalSense, ":");
        int synsetType = Integer.parseInt(tokenizer.nextToken());
        SynsetType type = SynsetTypeConverter.getType(synsetType);
        int lexFileNum = Integer.parseInt(tokenizer.nextToken());
        int lexID = Integer.parseInt(tokenizer.nextToken());
        String headLemma = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
        int headID = tokenizer.hasMoreTokens() ? Integer.parseInt(tokenizer.nextToken()) : -1;
        SenseKey headKey = headLemma != null ? new SenseKey(headLemma, SynsetType.ADJECTIVE, lexFileNum, headID) : null;
        return new SenseKey(lemma, type, lexFileNum, lexID, headKey);
    }
}

