/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.impl.MultipleLineLocator;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SenseIndexEntry;
import edu.smu.tspell.wordnet.impl.file.SenseIndexParser;
import edu.smu.tspell.wordnet.impl.file.TextTranslator;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class SenseIndexReader
extends MultipleLineLocator {
    private static final String SENSE_INDEX_FILE = "index.sense";
    private static final String LEMMA_TERMINATOR = "%";
    private static WeakReference reference;
    private SenseIndexParser parser = new SenseIndexParser();

    public static synchronized SenseIndexReader getInstance() throws RetrievalException {
        SenseIndexReader instance = null;
        if (reference != null) {
            instance = (SenseIndexReader)reference.get();
        }
        if (instance == null) {
            try {
                instance = new SenseIndexReader();
                reference = new WeakReference<SenseIndexReader>(instance);
            }
            catch (IOException ioe) {
                throw new RetrievalException("Error opening index file: " + ioe.getMessage(), ioe);
            }
        }
        return instance;
    }

    private SenseIndexReader() throws IOException {
        super(System.getProperty("wordnet.database.dir", "."), SENSE_INDEX_FILE);
    }

    public SenseIndexEntry getEntry(String prefix) throws RetrievalException {
        SenseIndexEntry[] entries = this.getAllEntries(prefix);
        if (entries.length != 1) {
            throw new RetrievalException("Expected to find exactly one line that begins with '" + prefix + "' but found + " + entries.length);
        }
        return entries[0];
    }

    public SenseIndexEntry[] getLemmaEntries(String lemma) throws RetrievalException {
        return this.getAllEntries(TextTranslator.translateToDatabaseFormat(lemma) + LEMMA_TERMINATOR);
    }

    public SenseIndexEntry[] getAllEntries(String prefix) throws RetrievalException {
        SenseIndexEntry[] entries;
        try {
            String[] lines = super.getLines(prefix);
            entries = new SenseIndexEntry[lines.length];
            for (int i = 0; i < entries.length; ++i) {
                entries[i] = this.parser.parse(lines[i]);
            }
        }
        catch (IOException ioe) {
            throw new RetrievalException("Error reading index file: " + ioe.getMessage(), ioe);
        }
        return entries;
    }
}

