/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.impl.file.SenseKey;
import edu.smu.tspell.wordnet.impl.file.SynsetPointer;

public class SenseIndexEntry
implements Comparable {
    private static final String FIELD_DELIMITER = " ";
    private SenseKey senseKey;
    private int synsetOffset;
    private int senseNumber;
    private int tagCount;

    public SenseIndexEntry(SenseKey senseKey, int synsetOffset, int senseNumber, int tagCount) {
        this.senseKey = senseKey;
        this.synsetOffset = synsetOffset;
        this.senseNumber = senseNumber;
        this.tagCount = tagCount;
    }

    public SynsetPointer getSynsetPointer() {
        return new SynsetPointer(this.senseKey.getType(), this.synsetOffset);
    }

    public SenseKey getSenseKey() {
        return this.senseKey;
    }

    public int getSynsetOffset() {
        return this.synsetOffset;
    }

    public int getSenseNumber() {
        return this.senseNumber;
    }

    public int getTagCount() {
        return this.tagCount;
    }

    public int compareTo(Object o) {
        int relativeValue = 1;
        if (o != null) {
            SenseIndexEntry target = (SenseIndexEntry)o;
            relativeValue = this.senseKey.getType().compareTo(target.getSenseKey().getType());
            if (relativeValue == 0 && (relativeValue = target.getTagCount() - this.getTagCount()) == 0 && (relativeValue = this.getSenseNumber() - target.getSenseNumber()) == 0) {
                relativeValue = this.getSenseKey().compareTo(target.getSenseKey());
            }
        }
        return relativeValue;
    }

    public String toString() {
        return this.senseKey.toString() + FIELD_DELIMITER + this.pad(this.getSynsetOffset(), 8) + FIELD_DELIMITER + this.getSenseNumber() + FIELD_DELIMITER + this.getTagCount();
    }

    private String pad(int value, int digits) {
        StringBuffer buffer = new StringBuffer(Integer.toString(value));
        while (buffer.length() < digits) {
            buffer.insert(0, '0');
        }
        return buffer.toString();
    }
}

