/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.impl.file.RelationshipType;
import edu.smu.tspell.wordnet.impl.file.SynsetPointer;
import edu.smu.tspell.wordnet.impl.file.WordSensePointer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelationshipPointers {
    private static final String SYNSET_KEY = "*";
    private Map sourceMaps = new HashMap();

    public void addSemanticRelationship(RelationshipType type, SynsetPointer pointer) {
        this.add(SYNSET_KEY, type, pointer);
    }

    public void addLexicalRelationship(String wordForm, RelationshipType type, WordSensePointer pointer) {
        this.add(wordForm, type, pointer);
    }

    private void add(Object key, RelationshipType type, Object value) {
        Map subMap = this.getSubMap(key, true);
        ArrayList<Object> list = (ArrayList<Object>)subMap.get(type);
        if (list == null) {
            list = new ArrayList<Object>();
            subMap.put(type, list);
        }
        list.add(value);
    }

    public SynsetPointer[] getSemanticRelationships(RelationshipType type) {
        List list;
        SynsetPointer[] pointers = null;
        Map subMap = this.getSubMap(SYNSET_KEY, false);
        if (subMap != null && (list = (List)subMap.get(type)) != null) {
            pointers = new SynsetPointer[list.size()];
            list.toArray(pointers);
        }
        return pointers != null ? pointers : new SynsetPointer[]{};
    }

    public WordSensePointer[] getLexicalRelationships(String wordForm, RelationshipType type) {
        List list;
        WordSensePointer[] pointers = null;
        Map subMap = this.getSubMap(wordForm, false);
        if (subMap != null && (list = (List)subMap.get(type)) != null) {
            pointers = new WordSensePointer[list.size()];
            list.toArray(pointers);
        }
        return pointers != null ? pointers : new WordSensePointer[]{};
    }

    public boolean removeAllSemanticRelationships(RelationshipType type) {
        return this.removeAll(SYNSET_KEY, type);
    }

    public boolean removeAllLexicalRelationships(String wordForm, RelationshipType type) {
        return this.removeAll(wordForm, type);
    }

    private boolean removeAll(Object key, RelationshipType type) {
        boolean removed = false;
        Map subMap = this.getSubMap(key, false);
        if (subMap != null) {
            removed = subMap.remove(key) != null;
        }
        return removed;
    }

    private Map getSubMap(Object sourceKey, boolean shouldCreate) {
        HashMap subMap = (HashMap)this.sourceMaps.get(sourceKey);
        if (subMap == null && shouldCreate) {
            subMap = new HashMap();
            this.sourceMaps.put(sourceKey, subMap);
        }
        return subMap;
    }
}

