/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.AdjectiveSynset;
import edu.smu.tspell.wordnet.NounSynset;
import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.VerbSynset;
import edu.smu.tspell.wordnet.WordNetException;
import edu.smu.tspell.wordnet.WordSense;
import edu.smu.tspell.wordnet.impl.AbstractSynset;
import edu.smu.tspell.wordnet.impl.file.RelationshipPointers;
import edu.smu.tspell.wordnet.impl.file.RelationshipReferences;
import edu.smu.tspell.wordnet.impl.file.RelationshipType;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SenseIndexEntry;
import edu.smu.tspell.wordnet.impl.file.SenseIndexReader;
import edu.smu.tspell.wordnet.impl.file.SenseKey;
import edu.smu.tspell.wordnet.impl.file.SynsetFactory;
import edu.smu.tspell.wordnet.impl.file.SynsetPointer;
import edu.smu.tspell.wordnet.impl.file.TextTranslator;
import edu.smu.tspell.wordnet.impl.file.WordSensePointer;

public abstract class ReferenceSynset
extends AbstractSynset {
    private SenseKey[] senseKeys;
    private int[] tagCounts;
    private RelationshipPointers pointers;
    private int lexicalFileNumber;
    private int offset;
    private RelationshipReferences references = new RelationshipReferences();

    protected ReferenceSynset(SynsetType type, String definition, String[] examples, SenseKey[] senseKeys, RelationshipPointers pointers, int lexicalFile, int offset) {
        super(type, definition, examples);
        this.senseKeys = senseKeys;
        this.pointers = pointers;
        this.lexicalFileNumber = lexicalFile;
        this.offset = offset;
        this.tagCounts = new int[senseKeys.length];
        for (int i = 0; i < this.tagCounts.length; ++i) {
            this.tagCounts[i] = -1;
        }
    }

    public String[] getWordForms() {
        String[] wordForms = new String[this.senseKeys.length];
        for (int i = 0; i < wordForms.length; ++i) {
            wordForms[i] = this.senseKeys[i].getLemma();
        }
        return wordForms;
    }

    public synchronized int getTagCount(String wordForm) throws WordNetException {
        int index = this.getWordIndex(TextTranslator.translateToExternalFormat(wordForm));
        if (index < 0) {
            throw new WordNetException("Attempted to get the tag count for '" + wordForm + "' from a synset that does not contain it.");
        }
        if (this.tagCounts[index] < 0) {
            SenseIndexEntry entry = this.getIndexEntry(this.senseKeys[index]);
            this.tagCounts[index] = entry.getTagCount();
        }
        return this.tagCounts[index];
    }

    private int getWordIndex(String wordForm) {
        int index = -1;
        for (int i = 0; i < this.senseKeys.length; ++i) {
            if (!wordForm.equalsIgnoreCase(this.senseKeys[i].getLemma())) continue;
            index = i;
            break;
        }
        return index;
    }

    public int getLexicalFileNumber() {
        return this.lexicalFileNumber;
    }

    public int getOffset() {
        return this.offset;
    }

    public WordSense[] getAntonyms(String wordForm) throws WordNetException {
        return this.getReferences(RelationshipType.ANTONYM, wordForm);
    }

    public WordSense[] getDerivationallyRelatedForms(String wordForm) throws RetrievalException {
        return this.getReferences(RelationshipType.RELATED_FORM, wordForm);
    }

    protected synchronized Synset[] getSynsets(RelationshipType type) throws WordNetException {
        Synset[] synsets = this.getReferences(type);
        if (synsets == null) {
            synsets = this.resolvePointers(type);
        }
        return synsets;
    }

    protected synchronized NounSynset[] getNounSynsets(RelationshipType type) throws WordNetException {
        Synset[] nounSynsets = (NounSynset[])this.getReferences(type);
        if (nounSynsets == null) {
            Synset[] synsets = this.resolvePointers(type);
            nounSynsets = new NounSynset[synsets.length];
            System.arraycopy(synsets, 0, nounSynsets, 0, synsets.length);
            this.putReferences(type, nounSynsets);
        }
        return nounSynsets;
    }

    protected synchronized VerbSynset[] getVerbSynsets(RelationshipType type) throws WordNetException {
        Synset[] verbSynsets = (VerbSynset[])this.getReferences(type);
        if (verbSynsets == null) {
            Synset[] synsets = this.resolvePointers(type);
            verbSynsets = new VerbSynset[synsets.length];
            System.arraycopy(synsets, 0, verbSynsets, 0, synsets.length);
            this.putReferences(type, verbSynsets);
        }
        return verbSynsets;
    }

    protected synchronized AdjectiveSynset[] getAdjectiveSynsets(RelationshipType type) throws WordNetException {
        Synset[] nounSynsets = (AdjectiveSynset[])this.getReferences(type);
        if (nounSynsets == null) {
            Synset[] synsets = this.resolvePointers(type);
            nounSynsets = new AdjectiveSynset[synsets.length];
            System.arraycopy(synsets, 0, nounSynsets, 0, synsets.length);
            this.putReferences(type, nounSynsets);
        }
        return nounSynsets;
    }

    private Synset[] getReferences(RelationshipType type) {
        return this.references.getSemanticRelationships(type);
    }

    private void putReferences(RelationshipType type, Synset[] synsets) {
        this.references.putSemanticRelationships(type, synsets);
    }

    private Synset[] resolvePointers(RelationshipType type) throws WordNetException {
        Synset[] synsets = null;
        SynsetPointer[] pointers = this.getPointers(type);
        if (pointers != null) {
            SynsetFactory factory = SynsetFactory.getInstance();
            synsets = new Synset[pointers.length];
            for (int i = 0; i < synsets.length; ++i) {
                synsets[i] = factory.getSynset(pointers[i]);
            }
            this.clearPointers(type);
        }
        return synsets;
    }

    private SynsetPointer[] getPointers(RelationshipType type) {
        return this.pointers.getSemanticRelationships(type);
    }

    private void clearPointers(RelationshipType type) {
        this.pointers.removeAllSemanticRelationships(type);
    }

    public NounSynset[] getTopics() throws WordNetException {
        return this.getNounSynsets(RelationshipType.DOMAIN_TOPIC);
    }

    public NounSynset[] getRegions() throws WordNetException {
        return this.getNounSynsets(RelationshipType.DOMAIN_REGION);
    }

    public NounSynset[] getUsages() throws WordNetException {
        return this.getNounSynsets(RelationshipType.DOMAIN_USAGE);
    }

    protected WordSense getSingletonSense(RelationshipType type, String wordForm) throws WordNetException {
        WordSense sense;
        WordSense[] references = this.getReferences(RelationshipType.PARTICIPLE, wordForm);
        switch (references.length) {
            case 0: {
                sense = null;
                break;
            }
            case 1: {
                sense = references[0];
                break;
            }
            default: {
                throw new WordNetException("Can't resolve to a exactly one reference of type " + type + ": " + this);
            }
        }
        return sense;
    }

    protected synchronized WordSense[] getReferences(RelationshipType type, String wordForm) throws WordNetException {
        WordSense[] senses = this.references.getLexicalRelationships(wordForm = TextTranslator.translateToExternalFormat(wordForm), type);
        if (senses == null) {
            WordSensePointer[] sensePtrs = this.pointers.getLexicalRelationships(wordForm, type);
            senses = new WordSense[sensePtrs.length];
            SynsetFactory factory = SynsetFactory.getInstance();
            for (int i = 0; i < senses.length; ++i) {
                Synset synset = factory.getSynset(sensePtrs[i]);
                String[] wordForms = synset.getWordForms();
                senses[i] = new WordSense(wordForms[sensePtrs[i].getWordNumber() - 1], synset);
            }
            this.references.putLexicalRelationships(wordForm, type, senses);
        }
        return senses;
    }

    protected SenseKey getSenseKey(int wordIndex) {
        return this.senseKeys[wordIndex];
    }

    protected SenseIndexEntry getIndexEntry(SenseKey senseKey) {
        SenseIndexEntry match = null;
        SenseIndexReader reader = SenseIndexReader.getInstance();
        SenseIndexEntry[] entries = reader.getAllEntries(senseKey.getPartialSenseKeyText());
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getSynsetOffset() != this.getOffset()) continue;
            match = entries[i];
            break;
        }
        return match;
    }

    public int hashCode() {
        return this.getOffset();
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o != null) {
            ReferenceSynset target = (ReferenceSynset)o;
            isEqual = this.getType().equals(target.getType()) && this.getOffset() == target.getOffset();
        }
        return isEqual;
    }

    public String toString() {
        String[] typeNames = new String[]{"Noun", "Verb", "Adjective", "Adverb", "AdjectiveSatellite"};
        StringBuffer buffer = new StringBuffer(typeNames[this.getType().getCode() - 1] + "@" + this.getOffset() + "[");
        String[] wordForms = this.getWordForms();
        for (int i = 0; i < wordForms.length; ++i) {
            buffer.append((i > 0 ? "," : "") + wordForms[i]);
        }
        buffer.append("] - ");
        buffer.append(this.getDefinition());
        return buffer.toString();
    }
}

