/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.SynsetType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DetachmentRules {
    private static final RuleOfDetachment[] NOUN_RULES_OF_DETACHMENT = new RuleOfDetachment[]{new RuleOfDetachment("s", ""), new RuleOfDetachment("ses", "s"), new RuleOfDetachment("xes", "x"), new RuleOfDetachment("zes", "z"), new RuleOfDetachment("ches", "ch"), new RuleOfDetachment("shes", "sh"), new RuleOfDetachment("men", "man"), new RuleOfDetachment("ies", "y")};
    private static final RuleOfDetachment[] VERB_RULES_OF_DETACHMENT = new RuleOfDetachment[]{new RuleOfDetachment("s", ""), new RuleOfDetachment("ies", "y"), new RuleOfDetachment("es", "e"), new RuleOfDetachment("es", ""), new RuleOfDetachment("ed", "e"), new RuleOfDetachment("ed", ""), new RuleOfDetachment("ing", "e"), new RuleOfDetachment("ing", "")};
    private static final RuleOfDetachment[] ADJECTIVE_RULES_OF_DETACHMENT = new RuleOfDetachment[]{new RuleOfDetachment("er", ""), new RuleOfDetachment("est", ""), new RuleOfDetachment("er", ""), new RuleOfDetachment("er", "")};
    private static final RuleOfDetachment[] ADVERB_RULES_OF_DETACHMENT = new RuleOfDetachment[0];
    private static final Map CATEGORY_RULES = new HashMap();
    private static DetachmentRules instance;

    public static synchronized DetachmentRules getInstance() {
        if (instance == null) {
            instance = new DetachmentRules();
        }
        return instance;
    }

    private DetachmentRules() {
    }

    public String[] getCandidateForms(String inflection, SynsetType type) {
        ArrayList<String> candidateList = new ArrayList<String>();
        RuleOfDetachment[] rules = this.getRulesOfDetachment(type);
        for (int i = 0; i < rules.length; ++i) {
            String suffix = rules[i].getSuffix();
            if (!inflection.endsWith(suffix)) continue;
            String candidate = inflection.substring(0, inflection.length() - suffix.length()) + rules[i].getEnding();
            candidateList.add(candidate);
        }
        String[] candidateArray = new String[candidateList.size()];
        candidateList.toArray(candidateArray);
        return candidateArray;
    }

    private RuleOfDetachment[] getRulesOfDetachment(SynsetType type) {
        RuleOfDetachment[] rules = (RuleOfDetachment[])CATEGORY_RULES.get(type);
        return rules != null ? rules : new RuleOfDetachment[]{};
    }

    static {
        CATEGORY_RULES.put(SynsetType.NOUN, NOUN_RULES_OF_DETACHMENT);
        CATEGORY_RULES.put(SynsetType.VERB, VERB_RULES_OF_DETACHMENT);
        CATEGORY_RULES.put(SynsetType.ADJECTIVE, ADJECTIVE_RULES_OF_DETACHMENT);
        CATEGORY_RULES.put(SynsetType.ADVERB, ADVERB_RULES_OF_DETACHMENT);
        CATEGORY_RULES.put(SynsetType.ADJECTIVE_SATELLITE, ADJECTIVE_RULES_OF_DETACHMENT);
    }

    private static class RuleOfDetachment {
        private String suffix;
        private String ending;

        public RuleOfDetachment(String suffix, String ending) {
            this.suffix = suffix;
            this.ending = ending;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getEnding() {
            return this.ending;
        }
    }
}

