/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class RandomAccessReader {
    protected static final char LINE_SEPARATOR = '\n';
    protected static final String ACCESS_MODE = "r";
    protected RandomAccessFile accessor;
    private long fileSize;
    private long filePointer;

    protected RandomAccessReader(File file) throws IOException {
        this.accessor = new RandomAccessFile(file, ACCESS_MODE);
        this.fileSize = file.length();
        this.filePointer = this.accessor.getFilePointer();
    }

    protected synchronized void seek(long newPosition) throws IOException {
        if (newPosition != this.filePointer) {
            RandomAccessFile reader = this.getAccessor();
            reader.seek(newPosition);
            this.filePointer = newPosition;
        }
    }

    protected synchronized String readToNextEndOfLine() throws IOException {
        char nextChar;
        StringBuffer buffer = new StringBuffer();
        while (this.filePointer < this.fileSize && (nextChar = this.readNextCharacter()) != '\n') {
            buffer.append(nextChar);
        }
        return buffer.toString();
    }

    protected synchronized char readNextCharacter() throws IOException {
        char nextChar = '\uffff';
        if (this.filePointer < this.fileSize) {
            nextChar = (char)this.accessor.read();
            ++this.filePointer;
        }
        return nextChar;
    }

    protected RandomAccessFile getAccessor() {
        return this.accessor;
    }

    protected long getFileSize() {
        return this.fileSize;
    }

    protected long getFilePointer() {
        return this.filePointer;
    }

    protected void finalize() throws Throwable {
        try {
            RandomAccessFile accessor = this.getAccessor();
            if (accessor != null) {
                accessor.close();
            }
        }
        catch (IOException ioe) {
            System.err.println("Error closing file: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }
}

