/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.template;

import com.sforce.ws.template.JspParser;
import com.sforce.ws.template.TemplateException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Template {
    private HashMap<String, Object> properties = new HashMap();

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(String in, String out) throws IOException, TemplateException {
        InputStream fio = this.createInputStream(in);
        PrintStream os = null;
        try {
            if (out != null) {
                File o = new File(out);
                if (o.exists()) {
                    throw new TemplateException("Output file already exists: " + out);
                }
                os = new PrintStream(new BufferedOutputStream(new FileOutputStream(o)));
            } else {
                os = System.out;
            }
            this.generate(fio, os);
        }
        finally {
            if (out != null && os != null) {
                os.close();
            }
            if (fio != null) {
                fio.close();
            }
        }
    }

    private InputStream createInputStream(String in) throws FileNotFoundException {
        InputStream is;
        File ifile = new File(in);
        if (ifile.exists()) {
            is = new FileInputStream(in);
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            if ((is = cl.getResourceAsStream(in)) == null) {
                throw new FileNotFoundException("Unable to find file: " + in);
            }
        }
        return is;
    }

    private void generate(InputStream in, PrintStream out) throws IOException, TemplateException {
        JspParser parser = new JspParser(in);
        String js = parser.toJavaScript();
        try {
            Context context = Context.enter();
            ScriptableObject scope = context.initStandardObjects();
            scope.put("out", (Scriptable)scope, (Object)out);
            this.addProperties((Scriptable)scope);
            context.evaluateString((Scriptable)scope, js, "<template>", 1, null);
        }
        catch (RuntimeException th) {
            this.report(js, th);
            throw th;
        }
        finally {
            Context.exit();
        }
    }

    private void addProperties(Scriptable scope) {
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            scope.put(entry.getKey(), scope, entry.getValue());
        }
    }

    private void report(String js, RuntimeException th) {
        System.out.println("JavaScript evaluation failed.");
        System.out.println("---------------- Java Script Source ---------------");
        this.print(js);
        System.out.println("---------------------------------------------------");
        System.out.println("Due to:" + th);
    }

    private void print(String js) {
        String[] jsArray = js.split("\r\n");
        for (int i = 0; i < jsArray.length; ++i) {
            System.out.print(this.lineNo(i + 1));
            System.out.println(jsArray[i]);
        }
    }

    private String lineNo(int i) {
        if (i < 10) {
            return "   " + i + ":  ";
        }
        if (i < 100) {
            return "  " + i + ":  ";
        }
        if (i < 1000) {
            return " " + i + ":  ";
        }
        return i + ":  ";
    }
}

