/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.rest;

import com.google.gson.Gson;
import com.sforce.rest.ContentType;
import com.sforce.rest.DescribeGlobal;
import com.sforce.rest.DescribeLayout;
import com.sforce.rest.DescribeSobject;
import com.sforce.rest.QueryResult;
import com.sforce.rest.RestApiException;
import com.sforce.rest.RestConnection;
import com.sforce.rest.RestExceptionCode;
import com.sforce.rest.SObjectResult;
import com.sforce.rest.SearchResult;
import com.sforce.rest.pojo.SObject;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.transport.JdkHttpTransport;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;

public class RestConnectionImpl
implements RestConnection {
    private final ConnectorConfig config;
    private final String baseEndpoint;
    private final Gson parser;
    private HashMap<String, String> headers;
    private static final String AUTH_HEADER = "Authorization";
    private static final String AUTH_VALUE_PREFIX = "OAuth ";
    private static final String CHARSET_HEADER = "Accept-Charset";
    private static final String CHARSET_VALUE = "UTF-8";
    private static final String CONTENT_HEADER = "Content-Type";
    private static final String PRETTY_HEADER = "X-Pretty-Print";
    private static final String SEPARATOR = "/";
    private static final String SOBJECTS_ENDPOINT = "sobjects/";
    private static final String QUERY_ENDPOINT = "query?q=";
    private static final String SEARCH_ENDPOINT = "search?q=";
    private static final String RECENT_ENDPOINT = "recent/";
    private static final String DESCRIBE_SUBENDPOINT = "describe/";
    private static final String PATCH_PARAMETER = "?_HttpMethod=PATCH";

    public RestConnectionImpl(ConnectorConfig config) throws RestApiException {
        if (config == null) {
            throw new RestApiException("config can not be null", RestExceptionCode.ClientInputError);
        }
        if (config.getRestEndpoint() == null) {
            throw new RestApiException("rest endpoint cannot be null", RestExceptionCode.ClientInputError);
        }
        if (config.getSessionId() == null) {
            throw new RestApiException("session ID not found", RestExceptionCode.ClientInputError);
        }
        this.config = config;
        this.baseEndpoint = config.getRestEndpoint();
        this.parser = new Gson();
        this.headers = new HashMap();
        this.headers.put(AUTH_HEADER, AUTH_VALUE_PREFIX + config.getSessionId());
        this.headers.put(CHARSET_HEADER, CHARSET_VALUE);
        this.headers.put(CONTENT_HEADER, ContentType.JSON.toString());
        this.headers.put(PRETTY_HEADER, "1");
    }

    public ConnectorConfig getConfig() {
        return this.config;
    }

    @Override
    public DescribeGlobal describeGlobal() throws IOException, RestApiException {
        String endpoint = this.baseEndpoint + SOBJECTS_ENDPOINT;
        URL url = new URL(endpoint);
        String json = this.doHttpGet(url);
        return (DescribeGlobal)this.parser.fromJson(json, DescribeGlobal.class);
    }

    @Override
    public DescribeSobject describeSobject(String sobjectName) throws IOException, RestApiException {
        String endpoint = this.baseEndpoint + SOBJECTS_ENDPOINT + sobjectName + SEPARATOR;
        URL url = new URL(endpoint);
        String json = this.doHttpGet(url);
        return (DescribeSobject)this.parser.fromJson(json, DescribeSobject.class);
    }

    @Override
    public DescribeLayout describeLayout(String sobjectName) throws IOException, RestApiException {
        String endpoint = this.baseEndpoint + SOBJECTS_ENDPOINT + sobjectName + SEPARATOR + DESCRIBE_SUBENDPOINT;
        URL url = new URL(endpoint);
        String json = this.doHttpGet(url);
        return (DescribeLayout)this.parser.fromJson(json, DescribeLayout.class);
    }

    @Override
    public <T extends SObject> T get(Class<T> clazz, String id) throws IOException, RestApiException {
        String endpoint = this.baseEndpoint + SOBJECTS_ENDPOINT + clazz.getSimpleName() + SEPARATOR + id.toString() + SEPARATOR;
        URL url = new URL(endpoint);
        String json = this.doHttpGet(url);
        return (T)((SObject)this.parser.fromJson(json, clazz));
    }

    @Override
    public SObjectResult create(SObject sobject) throws IOException, RestApiException {
        String endpoint = this.baseEndpoint + SOBJECTS_ENDPOINT + sobject.getClass().getSimpleName() + SEPARATOR;
        URL url = new URL(endpoint);
        String json = this.doHttpPost(url, this.parser.toJson((Object)sobject));
        return (SObjectResult)this.parser.fromJson(json, SObjectResult.class);
    }

    @Override
    public SObjectResult update(SObject sobject, String id) throws IOException {
        String endpoint = this.baseEndpoint + SOBJECTS_ENDPOINT + sobject.getClass().getSimpleName() + SEPARATOR + id + SEPARATOR;
        URL url = new URL(endpoint);
        String json = this.doHttpPatch(url, sobject.toString());
        return (SObjectResult)this.parser.fromJson(json, SObjectResult.class);
    }

    @Override
    public SObjectResult delete(Class<? extends SObject> clazz, String id) throws IOException, RestApiException {
        String endpoint = this.baseEndpoint + SOBJECTS_ENDPOINT + clazz.getSimpleName() + SEPARATOR + id + SEPARATOR;
        URL url = new URL(endpoint);
        String json = this.doHttpGet(url);
        return (SObjectResult)this.parser.fromJson(json, SObjectResult.class);
    }

    @Override
    public QueryResult query(String query) throws IOException, RestApiException {
        assert (query != null);
        if (!query.contains("SELECT") || !query.contains("FROM")) {
            throw new IllegalStateException("Query must be in the form: SELECT+id+FROM+sobject+WHERE+something=else");
        }
        String endpoint = this.baseEndpoint + QUERY_ENDPOINT + query;
        URL url = new URL(endpoint);
        String json = this.doHttpGet(url);
        return (QueryResult)this.parser.fromJson(json, QueryResult.class);
    }

    @Override
    public SearchResult search(String search) throws IOException, RestApiException {
        assert (search != null);
        if (!(search.contains("{") && search.contains("}") && search.startsWith("FIND"))) {
            throw new IllegalStateException("Search must be in the form: FIND+{myTerm}");
        }
        String endpoint = this.baseEndpoint + SEARCH_ENDPOINT + search;
        URL url = new URL(endpoint);
        String json = this.doHttpGet(url);
        return (SearchResult)this.parser.fromJson(json, SearchResult.class);
    }

    @Override
    public SearchResult recent() throws IOException, RestApiException {
        String endpoint = this.baseEndpoint + RECENT_ENDPOINT;
        URL url = new URL(endpoint);
        String json = this.doHttpGet(url);
        return (SearchResult)this.parser.fromJson(json, SearchResult.class);
    }

    private String doHttpGet(URL url) throws IOException, RestApiException {
        BufferedInputStream bin;
        System.out.println("GET " + url.toString());
        HttpURLConnection connection = JdkHttpTransport.createConnection(this.config, url, this.headers, false);
        connection.setInstanceFollowRedirects(true);
        System.out.println("HTTP " + connection.getResponseCode());
        InputStream in = connection.getResponseCode() >= 400 ? connection.getErrorStream() : connection.getInputStream();
        String encoding = connection.getHeaderField(CONTENT_HEADER);
        StringBuilder responseBuilder = new StringBuilder();
        if (encoding.startsWith(ContentType.JSON.toString())) {
            bin = new BufferedInputStream(in);
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = bin.read(buffer)) != -1) {
                responseBuilder.append(new String(buffer, 0, bytesRead));
            }
        } else {
            throw new IllegalStateException("Unknown content type on HTTP GET.");
        }
        bin.close();
        in.close();
        return responseBuilder.toString();
    }

    private String doHttpPost(URL url, String body) throws IOException {
        System.out.println("POST " + url.toString() + " " + body);
        HttpURLConnection connection = JdkHttpTransport.createConnection(this.config, url, this.headers, false);
        connection.setInstanceFollowRedirects(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        OutputStream out = connection.getOutputStream();
        out.write(body.getBytes());
        out.flush();
        out.close();
        System.out.print("HTTP " + connection.getResponseCode());
        InputStream in = connection.getResponseCode() >= 400 ? connection.getErrorStream() : connection.getInputStream();
        BufferedInputStream bin = new BufferedInputStream(in);
        StringBuilder responseBuilder = new StringBuilder();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = bin.read(buffer)) != -1) {
            responseBuilder.append(new String(buffer, 0, bytesRead));
        }
        bin.close();
        String serverResponse = responseBuilder.toString();
        System.out.print(serverResponse + "\r\n");
        if (connection.getResponseCode() >= 400) {
            throw new IllegalStateException(serverResponse);
        }
        return serverResponse;
    }

    private String doHttpPatch(URL url, String body) throws IOException {
        URL patchUrl = new URL(url.toString() + PATCH_PARAMETER);
        return this.doHttpPost(patchUrl, body);
    }
}

