/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.ResponseList;
import facebook4j.Tab;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TabJSONImpl
extends FacebookResponseImpl
implements Tab,
Serializable {
    private static final long serialVersionUID = -7967769244971110725L;
    private String id;
    private String name;
    private URL link;
    private IdNameEntity application;
    private String customName;
    private Boolean isPermanent;
    private Integer position;
    private Boolean isNonConnectionLandingTab;
    private URL imageURL;
    private URL customImageURL;

    TabJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    TabJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            this.link = z_F4JInternalParseUtil.getURL("link", json);
            if (!json.isNull("application")) {
                this.application = new IdNameEntityJSONImpl(json.getJSONObject("application"));
            }
            this.customName = z_F4JInternalParseUtil.getRawString("custom_name", json);
            this.isPermanent = z_F4JInternalParseUtil.getBoolean("is_permanent", json);
            this.position = z_F4JInternalParseUtil.getInt("position", json);
            this.isNonConnectionLandingTab = z_F4JInternalParseUtil.getBoolean("is_non_connection_landing_tab", json);
            this.imageURL = z_F4JInternalParseUtil.getURL("image_url", json);
            this.customImageURL = z_F4JInternalParseUtil.getURL("custom_image_url", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public IdNameEntity getApplication() {
        return this.application;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public Boolean isPermanent() {
        return this.isPermanent;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public Boolean isNonConnectionLandingTab() {
        return this.isNonConnectionLandingTab;
    }

    @Override
    public URL getImageURL() {
        return this.imageURL;
    }

    @Override
    public URL getCustomImageURL() {
        return this.customImageURL;
    }

    static ResponseList<Tab> createTabList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Tab> tabs = new ResponseListImpl<Tab>(size, json, new Tab[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject tabJSONObject = list.getJSONObject(i);
                TabJSONImpl tab = new TabJSONImpl(tabJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(tab, tabJSONObject);
                }
                tabs.add(tab);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(tabs, list);
            }
            return tabs;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TabJSONImpl)) {
            return false;
        }
        TabJSONImpl tabJSON = (TabJSONImpl)o;
        return !(this.id != null ? !this.id.equals(tabJSON.id) : tabJSON.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "TabJSONImpl{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", link=" + this.link + ", application=" + this.application + ", customName='" + this.customName + '\'' + ", isPermanent=" + this.isPermanent + ", position=" + this.position + ", isNonConnectionLandingTab=" + this.isNonConnectionLandingTab + ", imageURL=" + this.imageURL + ", customImageURL=" + this.customImageURL + '}';
    }
}

