/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Insight;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InsightJSONImpl
extends FacebookResponseImpl
implements Insight,
Serializable {
    private static final long serialVersionUID = 5220288371199505577L;
    private String id;
    private String name;
    private String period;
    private List<Insight.Value> values;
    private String title;
    private String description;

    InsightJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    InsightJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        this.id = z_F4JInternalParseUtil.getRawString("id", json);
        this.name = z_F4JInternalParseUtil.getRawString("name", json);
        this.period = z_F4JInternalParseUtil.getRawString("period", json);
        this.values = this.createValueList(json);
        this.title = z_F4JInternalParseUtil.getRawString("title", json);
        this.description = z_F4JInternalParseUtil.getRawString("description", json);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPeriod() {
        return this.period;
    }

    @Override
    public List<Insight.Value> getValues() {
        return this.values;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static ResponseList<Insight> createInsightList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Insight> insights = new ResponseListImpl<Insight>(size, json, new Insight[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject insightJSONObject = list.getJSONObject(i);
                InsightJSONImpl insight = new InsightJSONImpl(insightJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(insight, insightJSONObject);
                }
                insights.add(insight);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(insights, list);
            }
            return insights;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InsightJSONImpl other = (InsightJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "InsightJSONImpl [id=" + this.id + ", name=" + this.name + ", period=" + this.period + ", values=" + this.values + ", title=" + this.title + ", description=" + this.description + "]";
    }

    private List<Insight.Value> createValueList(JSONObject json) throws FacebookException {
        try {
            JSONArray list = json.getJSONArray("values");
            int size = list.length();
            ArrayList<Insight.Value> values = new ArrayList<Insight.Value>(size);
            for (int i = 0; i < size; ++i) {
                ValueJSONImpl value = new ValueJSONImpl(list.getJSONObject(i));
                values.add(value);
            }
            return values;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    private final class ValueJSONImpl
    implements Insight.Value,
    Serializable {
        private static final long serialVersionUID = 764579592511865193L;
        private Insight.Value.Entry value;
        private Date endTime;

        ValueJSONImpl(JSONObject json) throws FacebookException {
            this.value = new ValueEntryJSONImpl(json);
            this.endTime = z_F4JInternalParseUtil.getISO8601Datetime("end_time", json);
        }

        public Insight.Value.Entry getValue() {
            return this.value;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public String toString() {
            return "ValueJSONImpl [value=" + this.value + ", endTime=" + this.endTime + "]";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ValueEntryJSONImpl
        implements Insight.Value.Entry,
        Serializable {
            private Map<String, Long> value;

            ValueEntryJSONImpl(JSONObject json) throws FacebookException {
                String valueRawString = z_F4JInternalParseUtil.getRawString("value", json);
                if (valueRawString.startsWith("{")) {
                    this.value = z_F4JInternalParseUtil.getLongMap("value", json);
                } else {
                    this.value = new HashMap<String, Long>();
                    this.value.put("", z_F4JInternalParseUtil.getLong("value", json));
                }
            }

            @Override
            public Long get() {
                return this.value.values().iterator().next();
            }

            @Override
            public Long get(String key) {
                return this.value.get(key);
            }

            @Override
            public Iterator<String> keys() {
                return this.value.keySet().iterator();
            }

            @Override
            public int size() {
                return this.value.size();
            }
        }
    }
}

