/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Domain;
import facebook4j.FacebookException;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.IdNameJSONImpl;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DomainJSONImpl
extends IdNameJSONImpl
implements Domain,
Serializable {
    private static final long serialVersionUID = 3035743532170128485L;

    DomainJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res, conf);
    }

    DomainJSONImpl(JSONObject json) throws FacebookException {
        super(json);
    }

    static List<Domain> createDomainArray(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            ArrayList<Domain> domains = new ArrayList<Domain>();
            Iterator ids = json.keys();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                JSONObject domainJSONObject = (JSONObject)json.get(id);
                DomainJSONImpl domain = new DomainJSONImpl(domainJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(domain, domainJSONObject);
                }
                domains.add(domain);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(domains, json);
            }
            return domains;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public String toString() {
        return "DomainJSONImpl [id=" + this.id + ", name=" + this.name + "]";
    }
}

