/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Category;
import facebook4j.Comment;
import facebook4j.FacebookException;
import facebook4j.Image;
import facebook4j.PagableList;
import facebook4j.ResponseList;
import facebook4j.Tag;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.ImageJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.json.TagJSONImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CommentJSONImpl
extends FacebookResponseImpl
implements Comment,
Serializable {
    private static final long serialVersionUID = -4004859844463425632L;
    private String id;
    private Category from;
    private String message;
    private List<Tag> messageTags;
    private Boolean canComment;
    private Boolean canRemove;
    private Boolean canHide;
    private Boolean canLike;
    private Date createdTime;
    private Integer likeCount;
    private Integer commentCount;
    private Boolean isUserLikes;
    private Boolean isHidden;
    private Comment.Attachment attachment;
    private Comment parent;
    private PagableList<Comment> comments;

    CommentJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    CommentJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new CategoryJSONImpl(fromJSONObject);
            } else {
                this.from = null;
            }
            this.message = z_F4JInternalParseUtil.getRawString("message", json);
            if (!json.isNull("message_tags")) {
                JSONArray tagsJSONArray = json.getJSONArray("message_tags");
                int size = tagsJSONArray.length();
                this.messageTags = new ArrayList<Tag>(size);
                for (int i = 0; i < size; ++i) {
                    this.messageTags.add(new TagJSONImpl(tagsJSONArray.getJSONObject(i)));
                }
            } else {
                this.messageTags = Collections.emptyList();
            }
            this.canComment = z_F4JInternalParseUtil.getBoolean("can_comment", json);
            this.canRemove = z_F4JInternalParseUtil.getBoolean("can_remove", json);
            this.canHide = z_F4JInternalParseUtil.getBoolean("can_hide", json);
            this.canLike = z_F4JInternalParseUtil.getBoolean("can_like", json);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.likeCount = z_F4JInternalParseUtil.getInt("like_count", json);
            this.commentCount = z_F4JInternalParseUtil.getInt("comment_count", json);
            this.isUserLikes = z_F4JInternalParseUtil.getBoolean("user_likes", json);
            this.isHidden = z_F4JInternalParseUtil.getBoolean("is_hidden", json);
            if (!json.isNull("attachment")) {
                this.attachment = new AttachmentJSONImpl(json.getJSONObject("attachment"));
            }
            if (!json.isNull("parent")) {
                this.parent = new CommentJSONImpl(json.getJSONObject("parent"));
            }
            if (!json.isNull("comments")) {
                JSONObject commentsJSONObject = json.getJSONObject("comments");
                if (!commentsJSONObject.isNull("data")) {
                    JSONArray list = commentsJSONObject.getJSONArray("data");
                    int size = list.length();
                    this.comments = new PagableListImpl<Comment>(size, commentsJSONObject, new Comment[0]);
                    for (int i = 0; i < size; ++i) {
                        CommentJSONImpl comment = new CommentJSONImpl(list.getJSONObject(i));
                        this.comments.add(comment);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, commentsJSONObject, new Comment[0]);
                }
            } else {
                this.comments = new PagableListImpl<Comment>(0);
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<Tag> getMessageTags() {
        return this.messageTags;
    }

    @Override
    public Boolean canComment() {
        return this.canComment;
    }

    @Override
    public Boolean canRemove() {
        return this.canRemove;
    }

    @Override
    public Boolean canHide() {
        return this.canHide;
    }

    @Override
    public Boolean canLike() {
        return this.canLike;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Integer getLikeCount() {
        return this.likeCount;
    }

    @Override
    public Integer getCommentCount() {
        return this.commentCount;
    }

    @Override
    public Boolean isUserLikes() {
        return this.isUserLikes;
    }

    @Override
    public Boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public Comment.Attachment getAttachment() {
        return this.attachment;
    }

    @Override
    public Comment getParent() {
        return this.parent;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    static ResponseList<Comment> createCommentList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Comment> comments = new ResponseListImpl<Comment>(size, json, new Comment[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject commentJSONObject = list.getJSONObject(i);
                CommentJSONImpl comment = new CommentJSONImpl(commentJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(comment, commentJSONObject);
                }
                comments.add(comment);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(comments, list);
            }
            return comments;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommentJSONImpl other = (CommentJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "CommentJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", message='" + this.message + '\'' + ", messageTags=" + this.messageTags + ", canComment=" + this.canComment + ", canRemove=" + this.canRemove + ", canHide=" + this.canHide + ", canLike=" + this.canLike + ", createdTime=" + this.createdTime + ", likeCount=" + this.likeCount + ", commentCount=" + this.commentCount + ", isUserLikes=" + this.isUserLikes + ", isHidden=" + this.isHidden + ", attachment=" + this.attachment + ", parent=" + this.parent + ", comments=" + this.comments + '}';
    }

    private final class AttachmentJSONImpl
    implements Comment.Attachment,
    Serializable {
        private static final long serialVersionUID = 5515482060929228129L;
        private String description;
        private Comment.Attachment.AttachmentMedia media;
        private Comment.Attachment.AttachmentTarget target;
        private String title;
        private String type;
        private String url;

        AttachmentJSONImpl(JSONObject json) throws FacebookException {
            try {
                this.description = z_F4JInternalParseUtil.getRawString("description", json);
                if (!json.isNull("media")) {
                    this.media = new AttachmentMediaJSONImpl(json.getJSONObject("media"));
                }
                if (!json.isNull("target")) {
                    this.target = new AttachmentTargetJSONImpl(json.getJSONObject("target"));
                }
                this.title = z_F4JInternalParseUtil.getRawString("title", json);
                this.type = z_F4JInternalParseUtil.getRawString("type", json);
                this.url = z_F4JInternalParseUtil.getRawString("url", json);
            }
            catch (JSONException jsone) {
                throw new FacebookException(jsone.getMessage(), jsone);
            }
        }

        public String getDescription() {
            return this.description;
        }

        public Comment.Attachment.AttachmentMedia getMedia() {
            return this.media;
        }

        public Comment.Attachment.AttachmentTarget getTarget() {
            return this.target;
        }

        public String getTitle() {
            return this.title;
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AttachmentJSONImpl)) {
                return false;
            }
            AttachmentJSONImpl that = (AttachmentJSONImpl)o;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            if (this.media != null ? !this.media.equals(that.media) : that.media != null) {
                return false;
            }
            if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
                return false;
            }
            if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
        }

        public int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.media != null ? this.media.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "AttachmentJSONImpl{description='" + this.description + '\'' + ", media=" + this.media + ", target=" + this.target + ", title='" + this.title + '\'' + ", type='" + this.type + '\'' + ", url='" + this.url + '\'' + '}';
        }

        private final class AttachmentTargetJSONImpl
        implements Comment.Attachment.AttachmentTarget,
        Serializable {
            private String id;
            private String url;

            AttachmentTargetJSONImpl(JSONObject json) {
                this.id = z_F4JInternalParseUtil.getRawString("id", json);
                this.url = z_F4JInternalParseUtil.getRawString("url", json);
            }

            public String getId() {
                return this.id;
            }

            public String getUrl() {
                return this.url;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof AttachmentTargetJSONImpl)) {
                    return false;
                }
                AttachmentTargetJSONImpl that = (AttachmentTargetJSONImpl)o;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                    return false;
                }
                return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
            }

            public int hashCode() {
                int result = this.id != null ? this.id.hashCode() : 0;
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }

            public String toString() {
                return "AttachmentTargetJSONImpl{id='" + this.id + '\'' + ", url='" + this.url + '\'' + '}';
            }
        }

        private final class AttachmentMediaJSONImpl
        implements Comment.Attachment.AttachmentMedia,
        Serializable {
            private static final long serialVersionUID = -4030126370782822645L;
            private final Image image;

            AttachmentMediaJSONImpl(JSONObject json) throws FacebookException {
                try {
                    this.image = new ImageJSONImpl(json.getJSONObject("image"));
                }
                catch (JSONException jsone) {
                    throw new FacebookException(jsone.getMessage(), jsone);
                }
            }

            public Image getImage() {
                return this.image;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof AttachmentMediaJSONImpl)) {
                    return false;
                }
                AttachmentMediaJSONImpl that = (AttachmentMediaJSONImpl)o;
                return this.image.equals(that.image);
            }

            public int hashCode() {
                return this.image.hashCode();
            }

            public String toString() {
                return "AttachmentMediaJSONImpl{image=" + this.image + '}';
            }
        }
    }
}

