/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.http;

import facebook4j.auth.AccessToken;
import facebook4j.auth.Authorization;
import facebook4j.auth.OAuthAuthorization;
import facebook4j.internal.http.HttpParameter;
import facebook4j.internal.http.RequestMethod;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpRequest
implements Serializable {
    private final RequestMethod method;
    private final String url;
    private final HttpParameter[] parameters;
    private final Authorization authorization;
    private Map<String, String> requestHeaders;
    private static final long serialVersionUID = -3463594029098858381L;
    private static final HttpParameter[] NULL_PARAMETERS = new HttpParameter[0];

    public HttpRequest(RequestMethod method, String url, HttpParameter[] parameters, Authorization authorization, Map<String, String> requestHeaders) {
        this.method = method;
        parameters = this.setAccessTokenParameter(parameters, authorization);
        parameters = this.setAppSecretProofParameter(parameters, authorization);
        if (method != RequestMethod.POST && parameters != null && parameters.length != 0) {
            this.url = url.contains("?") ? url + "&" + HttpParameter.encodeParameters(parameters) : url + "?" + HttpParameter.encodeParameters(parameters);
            this.parameters = NULL_PARAMETERS;
        } else {
            this.url = url;
            this.parameters = parameters == null ? NULL_PARAMETERS : parameters;
        }
        this.authorization = authorization;
        this.requestHeaders = requestHeaders;
    }

    private HttpParameter[] setAccessTokenParameter(HttpParameter[] parameters, Authorization authorization) {
        if (authorization == null) {
            return parameters;
        }
        if (!(authorization instanceof OAuthAuthorization)) {
            return parameters;
        }
        AccessToken accessToken = ((OAuthAuthorization)authorization).getOAuthAccessToken();
        if (accessToken == null) {
            return parameters;
        }
        return HttpParameter.merge(parameters, new HttpParameter("access_token", accessToken.getToken()));
    }

    private HttpParameter[] setAppSecretProofParameter(HttpParameter[] parameters, Authorization authorization) {
        if (authorization == null) {
            return parameters;
        }
        if (!(authorization instanceof OAuthAuthorization)) {
            return parameters;
        }
        OAuthAuthorization oAuthAuthorization = (OAuthAuthorization)authorization;
        if (!oAuthAuthorization.isAppSecretProofEnabled()) {
            return parameters;
        }
        String appSecretProof = oAuthAuthorization.generateAppSecretProof();
        return HttpParameter.merge(parameters, new HttpParameter("appsecret_proof", appSecretProof));
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public HttpParameter[] getParameters() {
        return this.parameters;
    }

    public String getURL() {
        return this.url;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        if (this.authorization != null ? !this.authorization.equals(that.authorization) : that.authorization != null) {
            return false;
        }
        if (!Arrays.equals(this.parameters, that.parameters)) {
            return false;
        }
        if (this.requestHeaders != null ? !this.requestHeaders.equals(that.requestHeaders) : that.requestHeaders != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? Arrays.hashCode(this.parameters) : 0);
        result = 31 * result + (this.authorization != null ? this.authorization.hashCode() : 0);
        result = 31 * result + (this.requestHeaders != null ? this.requestHeaders.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HttpRequest{requestMethod=" + this.method + ", url='" + this.url + '\'' + ", postParams=" + (this.parameters == null ? null : Arrays.asList(this.parameters)) + ", authentication=" + this.authorization + ", requestHeaders=" + this.requestHeaders + '}';
    }
}

