/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.auth;

import facebook4j.FacebookException;
import facebook4j.auth.AuthType;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Arrays;

public class AccessToken
implements Serializable {
    private static final long serialVersionUID = -569157870319118047L;
    private String token;
    private String type;
    private Long expires;
    private AuthType authType;
    private String authNonce;
    String[] responseStr = null;

    public AccessToken(HttpResponse res) throws FacebookException {
        String version = res.getResponseHeader("facebook-api-version");
        if (Double.parseDouble(version.substring(1)) < 2.3 && !res.asString().startsWith("{")) {
            this.parseQueryString(res.asString());
            return;
        }
        JSONObject json = res.asJSONObject();
        this.token = z_F4JInternalParseUtil.getRawString("access_token", json);
        this.type = z_F4JInternalParseUtil.getRawString("token_type", json);
        this.expires = z_F4JInternalParseUtil.getLong("expires_in", json);
        this.authType = AuthType.of(z_F4JInternalParseUtil.getRawString("auth_type", json));
        this.authNonce = z_F4JInternalParseUtil.getRawString("auth_nonce", json);
    }

    public AccessToken(String string) {
        this.parseQueryString(string);
    }

    public AccessToken(String token, Long expires) {
        this.token = token;
        this.expires = expires;
    }

    private void parseQueryString(String string) {
        if (string.contains("access_token=")) {
            this.responseStr = string.split("&");
            this.token = this.getParameter("access_token");
            if (this.responseStr.length > 1) {
                this.expires = Long.valueOf(this.getParameter("expires"));
            }
        } else {
            this.token = string;
            this.expires = null;
        }
    }

    public String getParameter(String parameter) {
        String value = null;
        for (String str : this.responseStr) {
            if (!str.startsWith(parameter + '=')) continue;
            value = str.split("=")[1].trim();
            break;
        }
        return value;
    }

    public String getToken() {
        return this.token;
    }

    public String getType() {
        return this.type;
    }

    public Long getExpires() {
        return this.expires;
    }

    public String getAuthNonce() {
        return this.authNonce;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessToken)) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        return !(this.token != null ? !this.token.equals(that.token) : that.token != null);
    }

    public int hashCode() {
        return this.token != null ? this.token.hashCode() : 0;
    }

    public String toString() {
        return "AccessToken{token='" + this.token + '\'' + ", type='" + this.type + '\'' + ", expires=" + this.expires + ", authType=" + (Object)((Object)this.authType) + ", authNonce=" + this.authNonce + ", responseStr=" + Arrays.toString(this.responseStr) + '}';
    }
}

