/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.Facebook;
import facebook4j.auth.AccessToken;
import facebook4j.auth.Authorization;
import facebook4j.auth.AuthorizationFactory;
import facebook4j.auth.OAuthAuthorization;
import facebook4j.conf.Configuration;
import facebook4j.conf.ConfigurationContext;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class FacebookFactory
implements Serializable {
    private static final Constructor<Facebook> FACEBOOK_CONSTRUCTOR;
    static final Authorization DEFAULT_AUTHORIZATION;
    private static final Facebook SINGLETON;
    private static final long serialVersionUID = 5193900138477709155L;
    private final Configuration conf;

    public FacebookFactory() {
        this(ConfigurationContext.getInstance());
    }

    public FacebookFactory(Configuration conf) {
        if (conf == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = conf;
    }

    public FacebookFactory(String configTreePath) {
        this(ConfigurationContext.getInstance(configTreePath));
    }

    public Facebook getInstance() {
        return this.getInstance(AuthorizationFactory.getInstance(this.conf));
    }

    public Facebook getInstance(AccessToken accessToken) {
        String appId = this.conf.getOAuthAppId();
        String appSecret = this.conf.getOAuthAppSecret();
        if (null == appId && null == appSecret) {
            throw new IllegalStateException("App id and App secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf);
        oauth.setOAuthAccessToken(accessToken);
        return this.getInstance(oauth);
    }

    public Facebook getInstance(Authorization auth) {
        try {
            return FACEBOOK_CONSTRUCTOR.newInstance(this.conf, auth);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Facebook getSingleton() {
        return SINGLETON;
    }

    static {
        Constructor<?> constructor;
        DEFAULT_AUTHORIZATION = AuthorizationFactory.getInstance(ConfigurationContext.getInstance());
        String className = null;
        if (ConfigurationContext.getInstance().isGAE()) {
            String APP_ENGINE_TWITTER_IMPL = "facebook4j.AppEngineFacebookImpl";
            try {
                Class.forName("facebook4j.AppEngineFacebookImpl");
                className = "facebook4j.AppEngineFacebookImpl";
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (className == null) {
            className = "facebook4j.FacebookImpl";
        }
        try {
            Class<?> clazz = Class.forName(className);
            constructor = clazz.getDeclaredConstructor(Configuration.class, Authorization.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        FACEBOOK_CONSTRUCTOR = constructor;
        try {
            SINGLETON = FACEBOOK_CONSTRUCTOR.newInstance(ConfigurationContext.getInstance(), DEFAULT_AUTHORIZATION);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }
}

