/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.EventPrivacyType;
import facebook4j.internal.http.HttpParameter;
import facebook4j.internal.util.z_F4JInternalStringUtil;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;

public class EventUpdate
implements Serializable {
    private static final long serialVersionUID = -6106165246149864606L;
    private String name;
    private Calendar startTime;
    private Calendar endTime;
    private String description;
    private String location;
    private String locationId;
    private EventPrivacyType privacyType;
    private URI ticketURI;
    private Boolean noFeedStory;

    public EventUpdate() {
    }

    public EventUpdate(String name, Calendar startTime) {
        this.name = name;
        this.startTime = startTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EventUpdate name(String name) {
        this.setName(name);
        return this;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Calendar startTime) {
        this.startTime = startTime;
    }

    public EventUpdate startTime(Calendar startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime;
    }

    public EventUpdate endTime(Calendar endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EventUpdate description(String description) {
        this.setDescription(description);
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public EventUpdate location(String location) {
        this.setLocation(location);
        return this;
    }

    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public EventUpdate locationId(String locationId) {
        this.setLocationId(locationId);
        return this;
    }

    public EventPrivacyType getPrivacyType() {
        return this.privacyType;
    }

    public void setPrivacyType(EventPrivacyType privacyType) {
        this.privacyType = privacyType;
    }

    public EventUpdate privacyType(EventPrivacyType privacyType) {
        this.setPrivacyType(privacyType);
        return this;
    }

    public URI getTicketURI() {
        return this.ticketURI;
    }

    public void setTicketURI(URI ticketURI) {
        this.ticketURI = ticketURI;
    }

    public void setTicketURI(String ticketURI) throws URISyntaxException {
        this.ticketURI = new URI(ticketURI);
    }

    public EventUpdate ticketURI(URI ticketURI) {
        this.setTicketURI(ticketURI);
        return this;
    }

    public EventUpdate ticketURI(String ticketURI) throws URISyntaxException {
        this.setTicketURI(ticketURI);
        return this;
    }

    public Boolean getNoFeedStory() {
        return this.noFeedStory;
    }

    public void setNoFeedStory(Boolean noFeedStory) {
        this.noFeedStory = noFeedStory;
    }

    public EventUpdate noFeedStory(Boolean noFeedStory) {
        this.setNoFeedStory(noFeedStory);
        return this;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (this.name != null) {
            params.add(new HttpParameter("name", this.name));
        }
        if (this.startTime != null) {
            params.add(new HttpParameter("start_time", z_F4JInternalStringUtil.formatISO8601Datetime(this.startTime)));
        }
        if (this.endTime != null) {
            params.add(new HttpParameter("end_time", z_F4JInternalStringUtil.formatISO8601Datetime(this.endTime)));
        }
        if (this.description != null) {
            params.add(new HttpParameter("description", this.description));
        }
        if (this.location != null) {
            params.add(new HttpParameter("location", this.location));
        }
        if (this.locationId != null) {
            params.add(new HttpParameter("location_id", this.locationId));
        }
        if (this.privacyType != null) {
            params.add(new HttpParameter("privacy_type", this.privacyType.toString()));
        }
        if (this.ticketURI != null) {
            params.add(new HttpParameter("ticket_uri", this.ticketURI.toString()));
        }
        if (this.noFeedStory != null) {
            params.add(new HttpParameter("no_feed_story", this.noFeedStory));
        }
        return params.toArray(new HttpParameter[params.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventUpdate)) {
            return false;
        }
        EventUpdate that = (EventUpdate)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        if (this.locationId != null ? !this.locationId.equals(that.locationId) : that.locationId != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.noFeedStory != null ? !this.noFeedStory.equals(that.noFeedStory) : that.noFeedStory != null) {
            return false;
        }
        if (this.privacyType != that.privacyType) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        return !(this.ticketURI != null ? !this.ticketURI.equals(that.ticketURI) : that.ticketURI != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.locationId != null ? this.locationId.hashCode() : 0);
        result = 31 * result + (this.privacyType != null ? this.privacyType.hashCode() : 0);
        result = 31 * result + (this.ticketURI != null ? this.ticketURI.hashCode() : 0);
        result = 31 * result + (this.noFeedStory != null ? this.noFeedStory.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EventUpdate{name='" + this.name + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", description='" + this.description + '\'' + ", location='" + this.location + '\'' + ", locationId='" + this.locationId + '\'' + ", privacyType=" + (Object)((Object)this.privacyType) + ", ticketURI=" + this.ticketURI + ", noFeedStory=" + this.noFeedStory + '}';
    }
}

