/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.solr.SolrComponent;
import org.apache.camel.component.solr.SolrProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;

@UriEndpoint(firstVersion="2.9.0", scheme="solr,solrs,solrCloud", title="Solr", syntax="solr:url", producerOnly=true, label="monitoring,search")
public class SolrEndpoint
extends DefaultEndpoint {
    private String scheme = "http://";
    @UriPath(description="Hostname and port for the solr server")
    @Metadata(required="true")
    private String url;
    @UriParam(defaultValue="10")
    private int streamingQueueSize = 10;
    @UriParam(defaultValue="2")
    private int streamingThreadCount = 2;
    @UriParam
    private Integer maxRetries;
    @UriParam
    private Integer soTimeout;
    @UriParam
    private Integer connectionTimeout;
    @UriParam
    private Integer defaultMaxConnectionsPerHost;
    @UriParam
    private Integer maxTotalConnections;
    @UriParam
    private Boolean followRedirects;
    @UriParam
    private Boolean allowCompression;
    @UriParam(label="solrCloud")
    private String zkHost;
    @UriParam(label="solrCloud")
    private String collection;
    @UriParam
    private String requestHandler;

    public SolrEndpoint(String endpointUri, SolrComponent component, String address) throws Exception {
        super(endpointUri, (Component)component);
        if (endpointUri.startsWith("solrs")) {
            this.scheme = "https://";
        }
        URL url = new URL(this.scheme + address);
        this.url = url.toString();
    }

    public void setZkHost(String zkHost) throws UnsupportedEncodingException {
        String decoded;
        this.zkHost = decoded = URLDecoder.decode(zkHost, "UTF-8");
    }

    public String getZkHost() {
        return this.zkHost;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getCollection() {
        return this.collection;
    }

    public SolrComponent getComponent() {
        return (SolrComponent)super.getComponent();
    }

    private CloudSolrClient getCloudServer() {
        CloudSolrClient rVal = null;
        if (this.getZkHost() != null && this.getCollection() != null) {
            rVal = new CloudSolrClient.Builder().withZkHost(this.zkHost).build();
            rVal.setDefaultCollection(this.getCollection());
        }
        return rVal;
    }

    public Producer createProducer() throws Exception {
        SolrComponent.SolrServerReference ref = this.getComponent().getSolrServers(this);
        if (ref == null) {
            ref = new SolrComponent.SolrServerReference();
            CloudSolrClient cloudServer = this.getCloudServer();
            if (cloudServer == null) {
                HttpSolrClient solrServer = new HttpSolrClient.Builder(this.url).build();
                ConcurrentUpdateSolrClient solrStreamingServer = new ConcurrentUpdateSolrClient.Builder(this.url).withQueueSize(this.streamingQueueSize).withThreadCount(this.streamingThreadCount).build();
                if (this.soTimeout != null) {
                    solrServer.setSoTimeout(this.soTimeout.intValue());
                }
                if (this.connectionTimeout != null) {
                    solrServer.setConnectionTimeout(this.connectionTimeout.intValue());
                }
                if (this.followRedirects != null) {
                    solrServer.setFollowRedirects(this.followRedirects.booleanValue());
                }
                ref.setSolrServer(solrServer);
                ref.setUpdateSolrServer(solrStreamingServer);
            }
            ref.setCloudSolrServer(cloudServer);
            this.getComponent().addSolrServers(this, ref);
        }
        ref.addReference();
        return new SolrProducer(this, (SolrClient)ref.getSolrServer(), (SolrClient)ref.getUpdateSolrServer(), (SolrClient)ref.getCloudSolrServer());
    }

    protected void onProducerShutdown(SolrProducer producer) {
        int counter;
        SolrComponent.SolrServerReference ref = this.getComponent().getSolrServers(this);
        if (ref != null && (counter = ref.decReference()) <= 0) {
            this.getComponent().shutdownServers(ref, true);
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for Solr endpoint.");
    }

    public boolean isSingleton() {
        return true;
    }

    public void setRequestHandler(String requestHandler) {
        this.requestHandler = requestHandler;
    }

    public String getRequestHandler() {
        return this.requestHandler;
    }

    public int getStreamingThreadCount() {
        return this.streamingThreadCount;
    }

    public void setStreamingThreadCount(int streamingThreadCount) {
        this.streamingThreadCount = streamingThreadCount;
    }

    public int getStreamingQueueSize() {
        return this.streamingQueueSize;
    }

    public void setStreamingQueueSize(int streamingQueueSize) {
        this.streamingQueueSize = streamingQueueSize;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getDefaultMaxConnectionsPerHost() {
        return this.defaultMaxConnectionsPerHost;
    }

    public void setDefaultMaxConnectionsPerHost(Integer defaultMaxConnectionsPerHost) {
        this.defaultMaxConnectionsPerHost = defaultMaxConnectionsPerHost;
    }

    public Integer getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public Boolean getAllowCompression() {
        return this.allowCompression;
    }

    public void setAllowCompression(Boolean allowCompression) {
        this.allowCompression = allowCompression;
    }
}

