-- restart an interrupted Oracle Data Pump job
DECLARE
  jobName    VARCHAR2(200) := ?;      -- Oracle job name
  userName  VARCHAR2(200) := ?;       -- user name, or use current user if either NULL or empty
  waitForJob VARCHAR2(20) := ?;                -- wait for job to finish if not NULL and not empty
 
  handle   NUMBER;
  tmpUser  VARCHAR2(200);
  status   VARCHAR2(20);
BEGIN
 
  -- attach to job, which must exist
  IF userName IS NOT NULL THEN
    handle := DBMS_DATAPUMP.ATTACH(jobName, userName);
  ELSE
    SELECT USER INTO tmpUser FROM DUAL;
    handle := DBMS_DATAPUMP.ATTACH(jobName, tmpUser);
  END IF;

  -- start the job
  DBMS_DATAPUMP.START_JOB(handle);

  -- optionally, wait for the job to finish
  if waitForJob IS NOT NULL THEN
    DBMS_DATAPUMP.WAIT_FOR_JOB(handle, status);
  END IF;

END;
