<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<fmt:bundle basename="localization.restore">
<!-- showVM will be true when we get destination servers..If users doesn't have access to servers then we will only allow user to choose Vm name and do retsore -->
<div class="setup-content" data-ng-show="!showVM">
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<form name="vmFullRestoreForm" novalidate
		class='vm-full-restore-form' data-cv-submit="restoreVms()"
		autocomplete="off">
		<label for="displayName" class="data-store-label"> <!-- !!! STYLE -->
			<cv:msg key="label.changeVmDisplayName" bundle="restore" /> <input
			type="text" name="displayName"
			data-ng-model="restoreData.vmOptions.displayName"
			data-ng-required="true" /> <span class="help-block"
			data-ng-show="vmFullRestoreForm.displayName.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
				<fmt:message key="error.displayName" />
		</span>
		</label>
		<div class="button-container">
			<fmt:bundle basename="localization.messages">
				<button id="vmFullRestoreVcloud_button_#1911" type="button" class="btn btn-default setup-btn--hidden" 
					data-ng-click="cancel()">
					<fmt:message key="Cancel" />
				</button>
				<button id="vmFullRestoreVcloud_button_#8003" type="submit" class="btn btn-primary"> 
					<fmt:message key="Submit" />
				</button>
			</fmt:bundle>
		</div>
	</form>
	<label data-ng-click="restoreData.globalOptions.powerOn = !restoreData.globalOptions.powerOn" >
		<toggle-control  id="vmFullRestoreVmware_toggle_powerOn_endUser" status="restoreData.globalOptions.powerOn ? 'enabled-activity' : 'disabled-activity'">
		</toggle-control><span><cv:msg key="label.powerOn" bundle="restore"/></span>
	</label>
	<label data-ng-click="restoreData.globalOptions.overwrite = !restoreData.globalOptions.overwrite; overwriteOptionChanged()"  >
		<toggle-control  id="vmFullRestoreVmware_toggle_overwrite_endUser" status="restoreData.globalOptions.overwrite ? 'enabled-activity' : 'disabled-activity'">
		</toggle-control><span><cv:msg key="warning.overwrite" bundle="restore" /></span>
	</label>
</div>
<div class="setup-content padding-top-0" data-ng-show="showVM">
  <span class="{{serverMessageTop.type}} serverMessage">{{serverMessageTop.message}}</span>
    <div class="global-options padding-bottom-0">
    	<div>
					<div data-ng-if="true">
							<label for="serverId" >
								<cv:msg key="label.fsServer" bundle="restore"></cv:msg>
								<div class="company-multi-select" data-ng-if="!isOutOfPlaceRestore">
									<p class="no-margin">{{restoreData.globalOptions.serverDetails.name}}</p>
								</div>
								<input type="text" id="serverId" readonly name="serverName" data-ng-if="restoreOpt.restoreTypeSelector === 'outOfPlace'" data-ng-model="restoreData.globalOptions.serverDetails.name" />
							</label>
							</div>
					</div>
					<div data-ng-if="showProxy">
							<label for="destinationProxy" class="select-label restorePathLabel">
								<cv:msg key="label.proxy" bundle="restore"></cv:msg>
								<select
									id="destinationProxy" name="destinationProxy"
									data-ng-required="true"
									data-ng-model="restoreData.globalOptions.proxy"
									data-ng-options="ds as ds.clientName for ds in restoreData.globalOptions.proxyList track by (ds.clientName|lowercase)">
								</select>
							</label>
				</div>
    </div>
				<div class="local-options">
				<div class="error"
					data-ng-show="cv.vmFullRestoreForm.getAttempted() && showSomeVmsInvalidWarning()">
					<fmt:message key="error.allVmOptions" />
				</div>
				<div class="{{isRestoreInPlace() ? 'in-place-restore' : ''}}">
					<ul class="vm-full-restore-list">
						<li data-ng-show="multipleVmsSelected()"><a class="btn"
							data-ng-click="displayAllVmOptions()"
							data-ng-class="{'selected-value': restoreData.isAll()}"><fmt:message
									key="label.allvms" /></a></li>
						<li data-ng-repeat="vmOptions in restoreData.vmOptionsList">
							<a class="btn" data-ng-click="displayVmOptions(vmOptions)" title="{{vmOptions.browseData.displayName}}"
							data-ng-class="{'selected-value': restoreData.vmOptions == vmOptions}">{{vmOptions.browseData.displayName}}</a>
							<span class="error"
							data-ng-show="cv.vmFullRestoreForm.getAttempted() && !isVcloudOptionValid(vmOptions)">*</span>
						</li>
					</ul>
				</div>
				<form name="vmFullRestoreForm" novalidate
					class='vm-full-restore-form form-horizontal bootstrap-wrapper padding-bottom-0' data-cv-submit="restoreVms()"
					autocomplete="off">
					<div class="{{isRestoreInPlace() ? 'in-place-restore' : ''}}">
						<div id="perVmOptions" class="mainFormContent hyperv-restore-form-content">
						<div class="{{serverMessage.type}}"
							data-ng-bind="serverMessage.message"></div>
							<div class="form-group" data-ng-if="!restoreData.isAll()">
							<div class="col-xs-12">
							<label for="displayName" class="data-store-label">
							<cv:msg	key="label.changeVmDisplayName" bundle="restore" />
							<input type="text"
								name="displayName"
								data-ng-model="restoreData.vmOptions.displayName"
								data-ng-required="!restoreData.isAll() && !isRestoreInPlace()"
								data-ng-disabled="isRestoreInPlace()"/>
								<span class="help-block"
								data-ng-show="!isRestoreInPlace() && vmFullRestoreForm.displayName.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
									<fmt:message key="error.displayName" />
							</span>
							</label>
							</div>
							</div>
							<!-- prefix/suffix for vm display names on the all vms tab -->
							<div class="form-group col-xs-12" data-ng-show="restoreData.isAll()" data-ng-disabled="!isOutOfPlaceRestore">
							<input name="enablePrefixSuffix" id="enablePrefixSuffix" type="checkbox"
								data-ng-model="restoreData.globalOptions.enablePrefixSuffix" data-ng-change="prefixSuffixSelectorChanged()">
								<label for="enablePrefixSuffix" class="label-only restore-options-label"><cv:msg key="label.dispayNamePrefixSuffixTitle" bundle="restore"/></label>
								<label class="label-only restore-options-label">
									<input id="displayNamePrefix" type="radio" name="displayNamePrefixSuffix" value="prefix" data-ng-model="restoreData.prefixSuffixSelector"
										data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix" data-ng-change="prefixSuffixNameChanged()"/><span class="restore-settings-right-padding"><cv:msg key="label.prefix" bundle="restore"/></span>
									<input id="displayNameSuffix" type="radio" name="displayNamePrefixSuffix" value="suffix" data-ng-model="restoreData.prefixSuffixSelector"
										data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix" data-ng-change="prefixSuffixNameChanged()"/><span class="restore-settings-right-padding"><cv:msg key="label.suffix" bundle="restore"/></span>
									<input type="text" name="displayNamePrefixSuffix" placeholder="<cv:msg key="placeholder.prefixSuffixDisplayName" bundle="restore"/>" data-ng-model="restoreData.displayNamePrefixSuffix"
										data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix" data-ng-blur="prefixSuffixNameChanged()"/>
								</label>
							</div>
                         <div class="form-group" data-ng-if="!isRestoreInPlace()">
                         	<div class="col-xs-12">
							<label for="destinationOrg" class="destination-vm">
							<fmt:message key="label.organization" />
							<input type="text" readonly name="destinationOrg" id="destinationOrg"
								value="{{restoreData.getCurrentOrgDisplayName()}}"
								data-ng-required="true && !restoreData.isAll()" />
								<span class="help-block"
								data-ng-show="!restoreData.isAll() && restoreData.vmOptions.vcloudOrgName === null && cv.vmFullRestoreForm.getAttempted()">
									<fmt:message key="error.org" />
							</span>
							</label>
							<div data-ng-show="browseOrg">
							<span class="input-group-btn">
							<button id="vmFullRestoreVcloud_button_#9481" type="button" 
								data-ng-click="openSelectDestinationOrgDialog(restoreData.subClientEntity)"
								class="btn btn-default browse-btn" >
								<fmt:message key="label.browse" />
							</button>
							</span>
                            </div>
							<label class="label-only restore-options-label"><fmt:message
										key="label.orgvDC" /></label> <label for="orgvDC"
									class="data-store-label"> <select
									id="orgvDC" name="orgvDC" data-ng-required="true && !restoreData.isAll()"
									data-ng-model="restoreData.vmOptions.vcloudOrgVdcName"
									data-ng-options="vDC.name as vDC.name for vDC in restoreData.vmOptions.orgvDCList"
									data-ng-change="orgvDCChanged()">
										<option value=''><fmt:message
												key="placeholder.selectorgVdc" /></option>
								</select> <span class="help-block"
									data-ng-show="!restoreData.isAll() && vmFullRestoreForm.orgvDC.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.orgvDC)">
										<fmt:message key="error.orgvDC" />
								</span>
								</label>
                           
		        
							<label class="label-only restore-options-label"><fmt:message
							      key="label.vAppName" /> <cv-help-component help-text="<fmt:message key="info.vApp" />"></cv-help-component> <label for="VAppName"
							         class="data-store-label">
							     <input type="text" id="VAppName" name="VAppName" 
									data-ng-model="restoreData.vmOptions.vcloudVappName"
									data-ng-required="!restoreData.isAll()"
									data-ng-disabled="!isVDCAvailable()"									
									data-uib-typeahead="vApp.name as vApp.name for vApp in restoreData.vmOptions.orgvDCList[restoreData.vmOptions.orgvDCindex].inventoryInfo"	
									data-typeahead-min-length="0"
									data-typeahead-on-select="vAppNameChanged()"
									required
							      />
							<span class="help-block"
							  data-ng-show="!restoreData.isAll() && vmFullRestoreForm.vAppName.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.vAppName)">
							<fmt:message key="error.vAppName" />
							</span>			
							</label></label>

							<!---- Storage profile list for selected vdc ----->
							<label class="label-only restore-options-label"><cv:msg key="label.storageProfile" bundle="restore"/></label>
						 	<label for="storageProfile"
									class="data-store-label"> <select
									id="storageProfile" name="storageProfile" data-ng-required="!restoreData.isAll()"
									data-ng-model="restoreData.vmOptions.storageProfile"
									data-ng-options="storageProfile.name for storageProfile in restoreData.vmOptions.storageProfileList"
									data-ng-change="storageProfileChanged()">
										<option value=''><fmt:message
												key="placeholder.selectedStorageProfile" /></option>
								</select> <span class="help-block"
									data-ng-show="!restoreData.isAll() && vmFullRestoreForm.storageProfile.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.storageProfile)">
										<fmt:message key="error.storageProfile" />
								</span>
							</label>

	                          <label class="label-only restore-options-label"><fmt:message
										key="label.vAppOwner" /></label> <label for="vAppOwner"
									class="data-store-label"> <select
									id="vAppOwner" name="vAppOwner" data-ng-required="true && !restoreData.isAll()"
									data-ng-model="restoreData.vmOptions.vcloudOwner"
									data-ng-options="vAppOwner.name as vAppOwner.name for vAppOwner in restoreData.vmOptions.vAppOwnerList"
									data-ng-change="vAppOwnerChanged()">
										<option value=''><fmt:message
												key="placeholder.selectvAppOwner" /></option>
								</select> <span class="help-block"
									data-ng-show="!restoreData.isAll() && vmFullRestoreForm.vAppOwner.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.vAppOwner)">
										<fmt:message key="error.vAppOwner" />
								</span>
								</label>
                         </div>
						 </div>	
                           
							<!-- Network and IP Settings -->
							<uib-accordion id="vmFullRestoreVcloud_network_#2074" data-ng-if="!isRestoreInPlace()" close-others="true" style="text-align: left" class="restore-network-settings">
								<div uib-accordion-group is-open="restoreData.vmOptions.settings.networkOpen">
									<uib-accordion-heading>
		        						<cv:msg key="label.networkSettingsVMWare" bundle="restore"/><i class="pull-right glyphicon" data-ng-class="{'glyphicon-chevron-down': restoreData.vmOptions.settings.networkOpen, 'glyphicon-chevron-right': !restoreData.vmOptions.settings.networkOpen}"></i>
		      						</uib-accordion-heading>
									<div class="horizontal-button-container">
	 									<ul>
											<li class="horizontal-link-button" data-ng-attr-title="{{getTooltipForSettingsGrid()}}">
												<a href="" data-ng-click="openAddNetworkSettingsDialog()" data-ng-class="{true : 'disabled', false : ''}[$scope.restoreData.vmOptions.vcloudNics === null]"><cv:msg key="label.add" bundle="restore" /></a>
											</li>
										</ul>
									</div>
		      						<!-- grid and add option -->
		      						<cv-grid data-ng-if="restoreData.vmOptions.settings.networkSettingsLoaded" cv-grid-options="networkSettingsGridOptions"></cv-grid>
								</div>
							</uib-accordion>
						</div>
					</div>
					<div class="button-container">
						<fmt:bundle basename="localization.messages">
							<button id="vmFullRestoreVcloud_button_#2075" type="button" class="btn btn-default setup-btn--hidden" 
								data-ng-click="cancel()">
								<fmt:message key="Cancel" />
							</button>
							<button id="vmFullRestoreVcloud_button_#1007" type="submit"
								class="btn btn-primary">
								<fmt:message key="Submit" />
							</button>
						</fmt:bundle>
					</div>
				</form>
			</div>
				<label id="vmFullRestoreVcloud_label_powerOn" data-ng-click="restoreData.globalOptions.powerOn = !restoreData.globalOptions.powerOn" for="powerOn" class="overwriteLabel" >
					<toggle-control id="vmFullRestoreVcloud_toggle_powerOn"status="restoreData.globalOptions.powerOn ? 'enabled-activity' : 'disabled-activity'">
					</toggle-control><span><cv:msg key="label.powerOn" bundle="restore"/></span>
				</label>
				<label id="vmFullRestoreVcloud_label_overwrite" data-ng-click="restoreData.globalOptions.overwrite = !restoreData.globalOptions.overwrite; overwriteOptionChanged()">
					<toggle-control id="vmFullRestoreVcloud_toggle_overwrite" status="restoreData.globalOptions.overwrite ? 'enabled-activity' : 'disabled-activity'">
						</toggle-control><span><cv:msg key="warning.overwrite" bundle="restore" /></span>
				</label>
				<label id="vmFullRestoreVcloud_label_vAppConfiguration" data-ng-click="restoreData.globalOptions.vAppConfiguration = !restoreData.globalOptions.vAppConfiguration" ng-init="restoreData.globalOptions.vAppConfiguration=true">
					<toggle-control id="vmFullRestoreVcloud_toggle_vAppConfiguration" status="restoreData.globalOptions.vAppConfiguration ? 'enabled-activity' : 'disabled-activity'">
						</toggle-control><span><cv:msg key="label.restoreVApp" bundle="restore" /></span>
				</label>
				<label>
					<div class="global-options remove-border-padding padding-top-10 padding-left-10">
						<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
					</div>
				</label>
		</div>
		</fmt:bundle>
