<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
 <fmt:bundle basename="localization.restore">
		<!-- <div class="setup-title">
			<h1><fmt:message key="label.restoreOpts" /></h1>
		</div> -->
		<!-- showVM will be true when we get destination servers..If users doesn't have access to servers then we will only allow user to choose Vm name and do retsore -->
		<span class="setup-content">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
		</span>
		<div class="setup-content" data-ng-show="!showVM">
			<!-- <span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>-->
			<form name="vmFullRestoreFormNoServer" novalidate class='vm-full-restore-form' data-cv-submit="restoreVms()" autocomplete ="off" >
				<label  for="displayName" class="data-store-label"><!-- !!! STYLE --><cv:msg key="label.changeVmDisplayName" bundle="restore"/>
					<input  type="text" name="displayName" data-ng-model="restoreData.vmOptions.displayName" required/>
					<span class="help-block" data-ng-show="cv.vmFullRestoreFormNoServer.needsAttention(vmFullRestoreFormNoServer.displayName)"><fmt:message key="error.displayName" /></span>
				</label>
			
				<div class="button-container" >
					<fmt:bundle basename="localization.messages">
						<button id="vmFullRestoreOracleCloud_button_#4275" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
						<button id="vmFullRestoreOracleCloud_button_#8001" type="submit"  class="btn btn-primary cvBusyOnAjax"><fmt:message key="Submit" /></button> 
					</fmt:bundle>
				</div>
			</form>
		</div>
		<div class="setup-content" data-ng-show="showVM">			
				<div class="global-options">
					<div>
						<label for="serverId" class="select-label restorePathLabel"><cv:msg key="label.fsServer" bundle="restore"></cv:msg>
							<select data-ng-model="server.serverDetails"
									data-ng-options="server.name for server in servers" required
									data-ng-change="destinationServerChanged()">
							</select>							
						</label>
						<div  style="clear:both;"></div>
					</div>
					
					<div data-ng-if="showProxy">
						<label for="destinationProxy" class="select-label restorePathLabel" ><!-- !!! STYLE --><cv:msg key="label.proxy" bundle="restore"></cv:msg>
							<select id="destinationProxy" name="destinationProxy"  data-ng-required="true"
									data-ng-model="restoreData.globalOptions.proxy"
									data-ng-options="ds as ds.clientName for ds in restoreData.globalOptions.proxyList track by (ds.clientName|lowercase)"
									data-ng-change="proxyServerChanged()">
									 
							</select>
						</label>
					</div>
				</div>
				<div class="local-options">
					<div class="error" data-ng-show="cv.vmFullRestoreForm.getAttempted() && showSomeVmsInvalidWarning()" ><fmt:message key="error.allInstanceOptions" /></div>
					
					<ul class="vm-full-restore-list">
						<li data-ng-show="multipleVmsSelected()">
							<a class="btn" data-ng-click="displayAllVmOptions()" data-ng-class="{'selected-value': restoreData.isAll()}"><fmt:message key="label.allInstances" /></a>
						</li>
						<li data-ng-repeat="vmOptions in restoreData.vmOptionsList">
							<a class="btn" data-ng-click="displayVmOptions(vmOptions)"
								title="{{vmOptions.browseData.displayName}}"
								data-ng-class="{'selected-value': restoreData.vmOptions == vmOptions}">{{vmOptions.browseData.displayName}}</a>
							<span  class="error" data-ng-show="cv.vmFullRestoreForm.getAttempted() && !isVmOptionValid(vmOptions)">*</span>
						</li>
					</ul>
				
					<form name="vmFullRestoreForm" novalidate class='vm-full-restore-form' data-cv-submit="restoreVms()" autocomplete ="off" >
						
						<div id="perVmOptions" class="mainFormContent hyperv-restore-form-content">
							<label data-ng-show="!restoreData.isAll()" for="displayName"
									class="data-store-label"><!-- !!! STYLE --><cv:msg key="label.changeInstanceDisplayName" bundle="restore"/>
								<input data-ng-disabled="isRestoreInPlace()" type="text" name="displayName"
									data-ng-model="restoreData.vmOptions.displayName" data-ng-required="!restoreData.isAll() && !isRestoreInPlace()" data-ng-pattern="instanceNamePattern" required/>
								<span class="help-block cv-help-block"
									data-ng-show="!isRestoreInPlace() && vmFullRestoreForm.displayName.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
									<fmt:message key="error.displayName" />
								</span>
								<span class="help-block cv-help-block"
									data-ng-show="vmFullRestoreForm.displayName.$error.pattern && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
									<fmt:message key="error.displayName.pattern.oraclecloud" />
								</span>
								<br/>
							</label>
					
												
						<div class="input-group">
							
							<!-- open a new modal to show user account information -->
							<label for="userAccount" class="destination-vm"><cv:msg key="label.selectUserAccount" bundle="restore"></cv:msg>
								<input type="text"
									readonly name="userAccount" id="userAccount"
									value="{{restoreData.getCurrentUserAccountDisplayName()}}"
									data-ng-required="true && !restoreData.isAll()" />
								<span class="help-block cv-help-block" data-ng-show="!restoreData.isAll() && restoreData.vmOptions.userAccount=== null && cv.vmFullRestoreForm.getAttempted()">
									<cv:msg key="error.userAccount" bundle="restore"></cv:msg>
								</span>
							</label>
							<span class="input-group-btn">
							
							<!-- don't let the user browse through for user accounts, use only the one populated by default -->
							<button id="vmFullRestoreOracleCloud_button_#5032" type="button" data-ng-click="openOracleUserAccountDialog(restoreData.subClientEntity)" 
								class="btn btn-default browse-btn"><cv:msg key="label.browse" bundle="restore"></cv:msg>
							</button>
							</span>
							</div>
							
							<!-- this looks like instance type needs some sort of dropdown -->
							<label class="label-only restore-options-label"><cv:msg key="label.instanceShape" bundle="restore"></cv:msg></label>
							<label for="instanceType" class="select-label data-store-label" ><!-- !!! STYLE -->
								<select id="instanceType" name="instanceType"  data-ng-required="false"
										data-ng-model="restoreData.vmOptions.instanceType"
										data-ng-disabled="!isInstanceTypeListAvailable()"
										data-ng-options="instanceType as getInstanceTypeLabel(instanceType) for instanceType in restoreData.vmOptions.instanceTypeList track by instanceType.name"
										data-ng-change="instanceTypeChanged(restoreData.vmOptions.instanceType, {{restoreData.vmOptions.instanceType || 'null'}})">
										<option value=''>{{getInstanceTypeDropdownText()}}</option>
								</select>
								<span class="help-block cv-help-block" data-ng-show="!restoreData.isAll() && cv.vmFullRestoreForm.getAttempted() && !restoreData.vmOptions.instanceType">
									<cv:msg key="error.instanceShape" bundle="restore"></cv:msg>
								</span>
							</label>						
						
						<!-- open a new modal to show network settings information information -->
							<label for="networkSettings" class="label-only restore-options-label"><cv:msg key="label.networkSettings" bundle="restore"></cv:msg></label>
							
								<div class="restoreModalSecurityGroupMultiSelect">
								<label for="networkSettings" class="data-store-label" >
								
							 	<isteven-multi-select
					   				  input-model="restoreData.vmOptions.networkSettingsMultiSelectList"
					   				  output-model="restoreData.vmOptions.selectedNetworkSettings"
					  				  button-label="networkName"
					  				  item-label="networkName"
					   				  tick-property="ticked"
					   				  class="isteven-multi-select user-group-select"
					   				  id="networkSettings"
					   				  name="networkSettings"
					   				  helper-elements="all none filter"
					   				  max-labels="1"					   				 
					   				  on-item-click="doSelectedNetworksConflict(data)"
					   				  on-select-none="funClick()"
					   				  on-select-all="areSelectedNetworksValid()"
					   				  on-reset="funcClick()"
					   				  on-close="networkSettingsBlurred()"
					   				  is-disabled="!isNetworkSettingsListAvailable()">
						 		</isteven-multi-select>		
									
							    <span class="help-block cv-help-block" data-ng-show="!restoreData.isAll() && cv.vmFullRestoreForm.getAttempted() && !isNetworkSettingsListAvailable()">
									<cv:msg key="error.dataLoading" bundle="restore"></cv:msg>
								</span>
								</label>
								
								</div>
		
							
							<label for="securityGroupsSelection"class="label-only restore-options-label"><cv:msg key="label.securityGroupsLabel" bundle="restore"></cv:msg></label>
								<div class="restoreModalSecurityGroupMultiSelect">
								<label for="securityGroupsSelection" class="data-store-label">
									<isteven-multi-select
					   				  input-model="restoreData.vmOptions.securityGroupsMultiSelectList"
					   				  output-model="restoreData.vmOptions.selectedSecurityGroups"
					  				  button-label="groupName"
					  				  item-label="groupName"
					   				  tick-property="ticked"
					   				  class="isteven-multi-select user-group-select"
					   				  id="securityGroupsSelection"
					   				  name="securityGroupsSelection"
					   				  helper-elements="all none filter"
					   				  max-labels="1"					   				 
					   				  on-item-click="funcClick()"
					   				  on-select-none="funcClick()"
					   				  on-select-all="funcClick()"
					   				  on-reset="funcClick()"
					   				  on-close="securityGroupsBlurred()"
					   				  is-disabled="!isSecurityGroupsListAvailable()">
									</isteven-multi-select>		
									<span class="help-block cv-help-block" data-ng-show="!restoreData.isAll() && cv.vmFullRestoreForm.getAttempted() && !isSecurityGroupsListAvailable()">
										<cv:msg key="error.dataLoading" bundle="restore"></cv:msg>
									</span>	
																				
								</label>
								</div>		
									<!-- this looks like ssh key type needs some sort of dropdown -->
							<label class="label-only restore-options-label"><cv:msg key="label.selectSSHKey" bundle="restore"></cv:msg></label>
							<div class="restoreModalSSHKeysMultiSelect">
							
							<label for="SSHKeys" class="data-store-label" ><!-- !!! STYLE -->
							
							<isteven-multi-select
					   				  input-model="restoreData.vmOptions.sshKeysMultiSelectList"
					   				  output-model="restoreData.vmOptions.selectedSSHKey"
					  				  button-label="keyName"
					  				  item-label="keyName"
					   				  tick-property="ticked"
					   				  class="isteven-multi-select user-group-select"
					   				  id="sshKeySelection"
					   				  name="sshKeySelection"
					   				  helper-elements="all none filter"
					   				  max-labels="1"					   				 
					   				  on-item-click="funcClick()"
					   				  on-select-none="funcClick()"
					   				  on-select-all="funcClick()"
					   				  on-reset="funcClick()"
					   				  on-close="sshKeySelectionBlurred()"
					   				  is-disabled="!isSSHKeyListAvailable()">
						 		</isteven-multi-select>				
								
								<span class="help-block cv-help-block" data-ng-show="!restoreData.isAll() && cv.vmFullRestoreForm.getAttempted() && !isSSHKeyListAvailable()">
									<cv:msg key="error.dataLoading" bundle="restore"></cv:msg>
								</span>
							</label>	
						   </div>					
					</div>
						<div class="button-container">
							<fmt:bundle basename="localization.messages">
								<button id="vmFullRestoreOracleCloud_button_#5179" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
								<button id="vmFullRestoreOracleCloud_button_#7893" type="submit"  class="btn btn-primary cvBusyOnAjax" ><fmt:message key="Submit" /></button> 
							</fmt:bundle>
						</div>
					</form>
				</div>
				<label id="powerOnOracleCloudClassicLabel" data-ng-if="showVM" data-ng-click="restoreData.globalOptions.powerOn = !restoreData.globalOptions.powerOn" for="powerOn" class="overwriteLabel" ng-init="restoreData.globalOptions.powerOn=true">
					<toggle-control id="powerOnOracleCloudClassic" status="restoreData.globalOptions.powerOn ? 'enabled-activity' : 'disabled-activity'">
					</toggle-control><span><cv:msg key="label.powerInstanceOn" bundle="restore"/></span>
				</label>
				<label>
					<div class="global-options remove-border-padding padding-top-10 padding-left-10">
						<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
					</div>
				</label>
		</div>
</fmt:bundle>
