<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
</script>
<div class="vmFullRestoreKubernetes">
	<div class="setup-content padding-top-0">
		<div>
			<span class="{{vmFullKubernetes.serverMessageTop.type}} serverMessage">{{vmFullKubernetes.serverMessageTop.message}}</span>
			<div class="global-options">
				<div>
					<div>
						<label for="serverId" class="select-label restorePathLabel">
							<cv:msg key="label.destinationCluster" bundle="kubernetes"></cv:msg>
							<div class="company-multi-select" data-ng-if="!isOutOfPlaceRestore">
								<p class="no-margin">{{vmFullKubernetes.restoreData.globalOptions.serverDetails.name}}</p>
							</div> <select id="serverId" name="serverId"
							data-ng-model="vmFullKubernetes.restoreData.globalOptions.serverDetails"
							data-ng-options="server.name for server in vmFullKubernetes.servers"
							required
							data-ng-change="vmFullKubernetes.destinationServerChanged()"
							data-ng-if="isOutOfPlaceRestore">
						</select>
						</label>
					</div>
					<div>
						<label for="destinationProxy"
							class="select-label restorePathLabel"> <cv:msg
								key="label.proxy" bundle="restore"></cv:msg> <select
							id="destinationProxy" name="destinationProxy"
							data-ng-required="true"
							data-ng-model="vmFullKubernetes.restoreData.globalOptions.proxy"
							data-ng-options="ds as ds.clientName for ds in vmFullKubernetes.restoreData.globalOptions.proxyList track by (ds.clientName|lowercase)">
						</select>
						</label>
					</div>
				</div>
				<%-- 				<div data-ng-show="!vmFullKubernetes.isEndUser"
					data-ng-disabled="vmFullKubernetes.restoreData.globalOptions.disableInPlaceRestore">
					<input name="showInPlaceRestore" id="showInPlaceRestore" type="checkbox" data-ng-model="vmFullKubernetes.restoreData.globalOptions.inPlaceRestore"
						data-ng-change="vmFullKubernetes.populateInPlaceOptions()" />
					<label for="showInPlaceRestore" class="overwriteLabel">
						<cv:msg	key="label.inPlaceRestore" bundle="restore" />
					</label>
				</div> --%>
				<%-- <div>
					<input name="overwrite"	id="overwrite" type="checkbox" data-ng-model="vmFullKubernetes.restoreData.globalOptions.overwrite"
					data-ng-change="vmFullKubernetes.overwriteOptionChanged()">
					<label for="overwrite">
						<cv:msg	key="warning.overwrite" bundle="restore" />
					</label>
				</div> --%>
			</div>
			<div class="local-options">
				<div class="error"
					data-ng-show="cv.vmFullRestoreForm.getAttempted() && vmFullKubernetes.showSomeVmsInvalidWarning()">
					<cv:msg key="error.allApplicationOptions" bundle="restore" />
				</div>
				<div>
					<ul class="vm-full-restore-list">
						<li
							data-ng-if="::vmFullKubernetes.restoreData.multipleVMsSelected">
							<a class="btn font-weight-bold"
							data-ng-click="vmFullKubernetes.displayAllVmOptions()"
							data-ng-class="{'selected-value': vmFullKubernetes.restoreData.isAll()}">
								<cv:msg key="label.allApplications" bundle="restore" />
						</a>
						</li>
						<li
							data-ng-repeat="vmOptions in vmFullKubernetes.restoreData.vmOptionsList">
							<a class="btn"
							data-ng-click="vmFullKubernetes.displayVmOptions(vmOptions)"
							title="{{vmOptions.browseData.displayName}}"
							data-ng-class="{'selected-value': vmFullKubernetes.restoreData.vmOptions == vmOptions}">
								{{vmOptions.browseData.displayName}} </a> <span class="error"
							data-ng-show="cv.vmFullRestoreForm.getAttempted() && !vmFullKubernetes.isVmOptionValid(vmOptions)">*</span>
						</li>
					</ul>
				</div>
				<form name="vmFullRestoreForm" novalidate
					data-cv-submit="vmFullKubernetes.restoreVms(vmFullRestoreForm.$valid)" autocomplete="off"
					class='vm-full-restore-form form-horizontal bootstrap-wrapper padding-bottom-0'>
					<div class="{{isOutOfPlaceRestore ? '' : 'in-place-restore'}}">
						<div id="perVmOptions"
							class="mainFormContent hyperv-restore-form-content">
							<div class="{{vmFullKubernetes.serverMessage.type}}"
								data-ng-bind="vmFullKubernetes.serverMessage.message"></div>
							<div class="form-group">
								<div data-ng-if="!vmFullKubernetes.restoreData.isAll()">
								<div class="col-xs-12" data-ng-if="!isOutOfPlaceRestore">
                                       <label for="inPlaceDisplayName"> <cv:msg
                                          key="label.application" bundle="kubernetes" />
                                          <input type="text" name="inPlaceDisplayName" id="inPlaceDisplayName"
                                             data-ng-model="vmFullKubernetes.restoreData.vmOptions.inPlaceDisplayName"
                                             data-ng-disabled="!isOutOfPlaceRestore"
                                             data-ng-required="!isOutOfPlaceRestore"                                                                                       
                                             data-ng-pattern="vmFullKubernetes.k8sRegex"/>
                                             	<span class="help-block"
											data-ng-show="!isOutOfPlaceRestore
													&& vmFullRestoreForm.displayName.$error.required
													&& cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
											<cv:msg key="error.applicationName.required" bundle="restore" />
										</span>
                                       </label>
								</div>
									<div class="col-xs-12" data-ng-if="isOutOfPlaceRestore">
										<label for="displayName"> <cv:msg
												key="label.application" bundle="kubernetes" />
							<input type="text" name="displayName" id="displayName"
											data-ng-model="vmFullKubernetes.restoreData.vmOptions.displayName"
											data-ng-disabled="!isOutOfPlaceRestore"
											data-ng-required="isOutOfPlaceRestore"
											data-ng-pattern="vmFullKubernetes.k8sRegex"
						/>
											<span class="help-block"
											data-ng-show="isOutOfPlaceRestore
													&& vmFullRestoreForm.displayName.$error.required
													&& cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
											<cv:msg key="error.applicationName.required" bundle="restore" />
										</span>
										<span class="help-block"
											data-ng-show="isOutOfPlaceRestore
											&& vmFullRestoreForm.displayName.$error.pattern
											&& cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
											<cv:msg key="error.invalidApplicationName" bundle="restore" />
										</span>
										</label>
									</div>
								</div>
								<div class="col-xs-12" data-ng-if="!vmFullKubernetes.isEndUser && isOutOfPlaceRestore">
									<label id="vmFullRestoreKubernetes_namespace" data-ng-click="vmFullKubernetes.manageActivity()">
										<toggle-control id="vmFullRestoreKubernetes_toggle_manual_namespace"
											status="vmFullKubernetes.restoreData.vmOptions.manualNamespaceEntry">
										</toggle-control>
										<span><cv:msg key="label.manualNamespace" bundle="restore" /></span>
									</label>
								</div>

								<div class="col-xs-12" data-ng-if="!vmFullKubernetes.isEndUser && isOutOfPlaceRestore && vmFullKubernetes.manualEntryEnabled">
									<label for="manualNamespace"> <cv:msg key="label.namespace" bundle="kubernetes" />
										<input type="text" name="manualNamespaceInput" id="manualNamespaceInput"
											data-ng-model="vmFullKubernetes.restoreData.vmOptions.manualNamespace"
											data-ng-blur="vmFullKubernetes.manualNamespaceChanged()">
									</label>
								</div>
						
								<div class="col-xs-12">
									<div
										data-ng-if="!vmFullKubernetes.isEndUser && isOutOfPlaceRestore && !vmFullKubernetes.manualEntryEnabled">
										<label for="projects"><cv-help-text help-label="<cv:msg key='label.namespace' bundle='kubernetes' />" 
											help-text="'<cv:msg key='label.namespaceNote' bundle='kubernetes' />'"></cv-help-text>
											<select name="namespace" id="projects"
												data-ng-model="vmFullKubernetes.restoreData.vmOptions.project"
												data-ng-options="p as p.displayName for p in vmFullKubernetes.restoreData.globalOptions.projectList track by (p.displayName|lowercase)"
												data-ng-change="vmFullKubernetes.projectChanged()" /> 
											</select>
										</label>
									</div>
								</div>
								<div class="col-xs-12">
									<div
										data-ng-if="!vmFullKubernetes.isEndUser && isOutOfPlaceRestore">
										<label for="storageClass"> <cv:msg
												key="label.storageClass" bundle="restore" /> <select
											name="storageClass" id="storageClass"
											data-ng-model="vmFullKubernetes.restoreData.vmOptions.storageClass"
											data-ng-options="s as s.displayName for s in vmFullKubernetes.restoreData.globalOptions.storageClassList track by (s.displayName|lowercase)"
											data-ng-change="vmFullKubernetes.storageClassChanged()" /> </select>
										</label>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="button-container">
						<button id="vmFullRestoreKubernetes_button_#4469"
							type="button" class="btn btn-default"
							data-ng-click="vmFullKubernetes.closeModal()">
							<cv:msg key="Cancel" bundle="messages" />
						</button>
						<button id="vmFullRestoreKubernetes_button_#6282"
							type="submit" class="btn cvBusyOnAjax btn-primary">
							<cv:msg key="Submit" bundle="messages" />
						</button>
					</div>
				</form>
			</div>
			<div>
				<label id="vmFullRestoreKubernetes_label_overwrite"
					data-ng-click="vmFullKubernetes.restoreData.globalOptions.overwrite  = !vmFullKubernetes.restoreData.globalOptions.overwrite; vmFullKubernetes.overwriteOptionChanged()">
					<toggle-control id="vmFullRestoreKubernetes_toggle_overwrite"
						status="vmFullKubernetes.restoreData.globalOptions.overwrite ? 'enabled-activity' : 'disabled-activity'">
					</toggle-control><span><cv:msg key="warning.overwrite" bundle="restore" /></span>
				</label>
			</div>
			<div>
				<label>
					<div class="global-options remove-border-padding padding-top-10 padding-left-10">
						<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
					</div>
				</label>
			</div>
		</div>
	</div>
</div>
