<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.restore"></cv:cvMessages>
    <cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
 <fmt:bundle basename="localization.restore">
		<!-- <div class="setup-title">
			<h1><cv:msg key="label.restoreOpts" bundle="restore"/></h1>
		</div> -->
		<!-- showVM will be true when we get destination servers..If users doesn't have access to servers then we will only allow user to choose Vm name and do retsore -->
		<div class="setup-content" data-ng-if="!showVM">
		<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
				   <form name="vmFullRestoreForm" novalidate  data-cv-submit="restoreVms()" autocomplete ="off" >
				   <label for="displayName"
							class="data-store-label"><cv:msg key="label.changeVmDisplayName" bundle="restore"/>
						<input  type="text" name="displayName"
							data-ng-model="restoreData.vmOptions.displayName" data-ng-required="true" data-ng-pattern="azureVmNameRegex" />
						<span class="help-block"
							data-ng-show=" (vmFullRestoreForm.displayName.$error || !vmFullRestoreForm.displayName.$valid) && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
							<cv:msg key="error.displayName.azure" bundle="restore"/>
						</span>
					</label>
					<label id="vmFullRestoreHyperV_label_powerOn_endUser" data-ng-click="restoreData.globalOptions.powerOn = !restoreData.globalOptions.powerOn" for="powerOn" class="overwriteLabel">
							<toggle-control id="vmFullRestoreHyperV_toggle_powerOn_endUser" status="restoreData.globalOptions.powerOn ? 'enabled-activity' : 'disabled-activity'">
							</toggle-control><span><cv:msg key="label.powerOn" bundle="restore"/></span>
						</label>
						<label id="vmFullRestoreHyperV_label_overwrite_endUser" data-ng-click="restoreData.globalOptions.overwrite = !restoreData.globalOptions.overwrite; overwriteOptionChanged()">
							<toggle-control id="vmFullRestoreHyperV_toggle_overwrite_endUser" status="restoreData.globalOptions.overwrite ? 'enabled-activity' : 'disabled-activity'">
							</toggle-control><span><cv:msg key="warning.overwrite" bundle="restore" /></span>
			          </label>
			    <div class="button-container" >
				<fmt:bundle basename="localization.messages">
					<button id="vmFullRestoreAzure_button_#1750" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancel()"><fmt:message key="Cancel" /></button>
					<button id="vmFullRestoreAzure_button_#7976" type="submit"  class="btn btn-primary"><fmt:message key="Submit" /></button>
				</fmt:bundle>
				</div>
				</form>

			</div>
		<div class="setup-content" data-ng-if="showVM">
		<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<div class="global-options">
				<div>
					<label for="serverId">
					<fmt:message key="label.fsServer"/>
							 <div class="company-multi-select" data-ng-if="!isOutOfPlaceRestore">
								<p>{{restoreData.globalOptions.server.clientName}}</p>
							</div>

							<select data-ng-model="restoreData.globalOptions.server"
									data-ng-options="server.name for server in servers" required
									data-ng-change="destinationServerChanged()"
									data-ng-if="isOutOfPlaceRestore">
							</select>
					</label>
					<div  style="clear:both;"></div>
				</div>
				<div data-ng-if="showProxy">
						<label for="destinationProxy" class="select-label restorePathLabel" >
							<cv-help-text data-ng-if="distributeWorkload" help-text="label.proxy.auto.help" help-label="label.proxy"></cv-help-text>
							<span data-ng-if="!distributeWorkload">
								<cv:msg key="label.proxy" bundle="restore"></cv:msg>
							</span>
							<select id="destinationProxy" name="destinationProxy"  data-ng-required="true"
									data-ng-model="restoreData.globalOptions.proxy"
									data-ng-options="ds as ds.clientName for ds in restoreData.globalOptions.proxyList track by (ds.clientName|lowercase)">
							</select>
						</label>
					</div>
				<%-- <!-- show an option to do out of place restore -->
				<div data-ng-disabled="restoreData.globalOptions.disableInPlaceRestore || isCrossRestore()">
					<input name="showInPlaceRestore" id="showInPlaceRestore"
						type="checkbox" data-ng-model="restoreData.globalOptions.inPlaceRestore"
						data-ng-change="populateInPlaceOptions()">
					<label for="showInPlaceRestore" class="overwriteLabel"><cv:msg
						key="label.inPlaceRestore" bundle="restore" />
					</label>
				</div> --%>
			</div>
			<div class="local-options">
			<div class="error" data-ng-show="cv.vmFullRestoreForm.getAttempted() && showSomeVmsInvalidWarning()" ><fmt:message key="error.allVmOptions" /></div>
			<ul class="vm-full-restore-list">
			<li data-ng-show="multipleVmsSelected()">
					<a class="btn" data-ng-click="displayAllVmOptions()" data-ng-class="{'selected-value': restoreData.isAll()}"><fmt:message key="label.allvms" /></a>
				</li>
 				<li data-ng-repeat="vmOptions in restoreData.vmOptionsList">
					<a class="btn" data-ng-click="displayVmOptions(vmOptions)"
						data-ng-class="{'selected-value': restoreData.vmOptions == vmOptions}">{{vmOptions.browseData.displayName}}
						<span class="error" data-ng-show="cv.vmFullRestoreForm.getAttempted() && !isVmOptionValid(vmOptions)">*</span>
						</a>
				</li>
			</ul>
			<form name="vmFullRestoreForm" novalidate class='vm-full-restore-form' cv-submit="restoreVms()" autocomplete ="off" >
				<div id="perVmOptions" class="mainFormContent hyperv-restore-form-content">
					<label data-ng-show="!restoreData.isAll()" for="displayName"
							class="data-store-label"><cv:msg key="label.changeVmDisplayName" bundle="restore"/>
						<input data-ng-disabled="isRestoreInPlace()" type="text" name="displayName"
							data-ng-model="restoreData.vmOptions.displayName" data-ng-required="!restoreData.isAll() && !isRestoreInPlace()"  data-ng-pattern="azureVmNameRegex" />
						<span class="help-block"
							data-ng-show="!isRestoreInPlace() && (vmFullRestoreForm.displayName.$error || !vmFullRestoreForm.displayName.$valid) && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
							<cv:msg key="error.displayName.azure" bundle="restore"/>
						</span>
					</label>

						<!-- prefix/suffix for vm display names on the all vms tab -->
						<div data-ng-if="!isRestoreInPlace()" class="address-settings-reduce-padding" data-ng-show="restoreData.isAll()">
						<input name="enablePrefixSuffix" id="enablePrefixSuffix" type="checkbox"
							data-ng-model="restoreData.globalOptions.enablePrefixSuffix" data-ng-disabled="isRestoreInPlace()" data-ng-change="prefixSuffixSelectorChanged()">
							<label for="enablePrefixSuffix" class="label-only restore-options-label"><cv:msg key="label.dispayNamePrefixSuffixTitle" bundle="restore"/></label>
							<label class="label-only restore-options-label">
								<input id="displayNamePrefix" type="radio" name="displayNamePrefixSuffix" value="prefix" data-ng-model="restoreData.prefixSuffixSelector"
									data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix || isRestoreInPlace()" data-ng-change="prefixSuffixNameChanged()"/><span class="restore-settings-right-padding"><cv:msg key="label.prefix" bundle="restore"/></span>
								<input id="displayNameSuffix" type="radio" name="displayNamePrefixSuffix" value="suffix" data-ng-model="restoreData.prefixSuffixSelector"
									data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix || isRestoreInPlace()" data-ng-change="prefixSuffixNameChanged()"/><span class="restore-settings-right-padding"><cv:msg key="label.suffix" bundle="restore"/></span>
								<input type="text" name="displayNamePrefixSuffix" placeholder="<cv:msg key="placeholder.prefixSuffixDisplayName" bundle="restore"/>"
									data-ng-model="restoreData.displayNamePrefixSuffix" data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix || isRestoreInPlace()" data-ng-blur="prefixSuffixNameChanged()"/>
							</label>
						</div>
						<!-- COMMENTING THESE OPTIONS OUT UNTIL INVENTORY BROWSE IS FIXED TO RETURN STORAGE ACCOUNTS PROPERLY: -->
						<label data-ng-if="!isRestoreInPlace()" for="azureContainer" class="destination-vm">{{azureContainerLabel}}
							<select data-ng-show="azureContainerOptionsLoaded" id="azureContainer" name="azureContainer"  data-ng-required="true"
									data-ng-change="azureContainerOptionChanged('{{restoreData.vmOptions.azureContainer}}')"
									data-ng-model="restoreData.vmOptions.azureContainer"
									data-ng-options="item.guid as item.displayName for item in restoreData.globalOptions.azureContainerList">
							</select>
							<select data-ng-show="!azureContainerOptionsLoaded" data-ng-disabled="true" id="azureContainerPlaceholder" name="azureContainerPlaceholder"  data-ng-required="false">
							 	<option value=""><cv:msg key="label.loading" bundle="restoreJs"/></option>
							</select>
							<span class="help-block" data-ng-show="restoreData.vmOptions.azureContainer === null && cv.vmFullRestoreForm.getAttempted()">{{azureContainerError}}</span>
						</label>
						<label data-ng-if="!isRestoreInPlace()" for="region" class="destination-vm"><cv:msg key="label.region" bundle="restore"/>
							<select data-ng-show="azureRegionsLoaded" id="region" name="region"  data-ng-required="true"
									data-ng-change="azureRegionChanged('{{restoreData.vmOptions.azureRegions}}')"
									data-ng-model="restoreData.vmOptions.azureRegions"
									data-ng-options="item.guid as item.displayName for item in restoreData.vmOptions.azureRegionsList">
							</select>
							<select data-ng-show="!azureRegionsLoaded" data-ng-disabled="true" id="azureRegionPlaceholder" name="azureRegionPlaceholder"  data-ng-required="false">
							 	<option value=""><cv:msg key="label.loading" bundle="restoreJs"/></option>
							</select>
							<span class="help-block" data-ng-show="restoreData.vmOptions.azureRegions === null && cv.vmFullRestoreForm.getAttempted()">
								<cv:msg key="error.region" bundle="restore"/>
							</span>
						</label>
						<label data-ng-if="!isRestoreInPlace() && isAvailabilityZoneApplicable && (restoreData.vmOptions.restoreAsManagedVM || restoreData.isAll())" for="availabilityZone" class="destination-vm"><cv:msg key="label.availabilityZone" bundle="restore"/>
							<select data-ng-show="azureRegionsLoaded" id="availabilityZone" name="availabilityZone"  data-ng-required="true"
									data-ng-model="restoreData.vmOptions.azureAvailabilityZone"
									data-ng-change="azureAvailabilityZoneChanged('{{restoreData.vmOptions.azureAvailabilityZone}}')"
									data-ng-options="item as item for item in restoreData.vmOptions.azureAvailabilityZonesList">
							</select>
							<select data-ng-show="!azureRegionsLoaded" data-ng-disabled="true" id="azureRegionPlaceholder" name="azureRegionPlaceholder"  data-ng-required="false">
							 	<option value=""><cv:msg key="label.loading" bundle="restoreJs"/></option>
							</select>
							<span class="help-block" data-ng-show="restoreData.vmOptions.azureRegions === null && cv.vmFullRestoreForm.getAttempted()">
								<cv:msg key="error.region" bundle="restore"/>
							</span>
						</label>
						<label data-ng-if="!isRestoreInPlace() ||(isRestoreInPlace()&& restoreData.vmOptions.restoreAsManagedVM)" for="storageAccount" class="destination-vm"><cv:msg key="label.storageAccount" bundle="restore"/>
							<select data-ng-show="azureStorageAccountOptionsLoaded()" id="storageAccount" name="storageAccount"  data-ng-required="true"
									data-ng-change="azureStorageAccountOptionChanged('{{restoreData.vmOptions.azureStorageAccount}}')"
									data-ng-model="restoreData.vmOptions.azureStorageAccount"
									data-ng-options="item.dataStoreName as item.dataStoreName for item in restoreData.vmOptions.azureStorageAccountList">
							</select>
							<select data-ng-show="!azureStorageAccountOptionsLoaded()" data-ng-disabled="true" id="storageAccountPlaceholder" name="storageAccountPlaceholder"  data-ng-required="false">
							 	<option value=""></option>
							</select>
							<span class="help-block" data-ng-if="isStorageAccountListEmpty"><i class="ion-alert-circled" ></i>
								{{noStorageAccountError.message}}
							</span>
							<span class="help-block" data-ng-show="restoreData.vmOptions.azureStorageAccount === null && cv.vmFullRestoreForm.getAttempted()">
								<cv:msg key="error.storageAccount" bundle="restore"/>
							</span>
						</label>
                    <div data-ng-if="!isRestoreInPlace()">
						 <label data-ng-show="!restoreData.isAll() && (originalVendor != 'AZURE_V2'  &&  originalVendor != 'AZURE_STACK')" for="operatingSystemSelect" class="destination-vm">
	                             <cv:msg key="label.operatingsystem" bundle="restore"></cv:msg>
	                          </label>
	                              <isteven-multi-select
								  input-model="restoreData.vmOptions.operatingSystemList"
								  output-model="restoreData.vmOptions.selectedOperatingSystem"
								  button-label="name"
								  item-label="name"
								  tick-property="ticked"
								  selection-mode="single"
								  class="isteven-multi-select user-group-select"
								  id="name"
								  name="name"
								  data-ng-if="originalVendor != 'AZURE_V2' &&  originalVendor != 'AZURE_STACK' && !restoreData.isAll()">
								</isteven-multi-select>
						<label for="azureVmSize" class="destination-vm"><cv:msg key="label.vmSize" bundle="restore"/>
							<select data-ng-show="azureVmSizesLoaded" id="azureVmSize" name="azureVmSize"  data-ng-required="true"
									data-ng-model="restoreData.vmOptions.azureVmSize"
									data-ng-change="azureVmSizeOptionChanged()"
									data-ng-options="item as item.name for item in restoreData.vmOptions.azureVmSizeList">
							</select>
							<select data-ng-show="!azureVmSizesLoaded" data-ng-disabled="true" id="azureVmSizePlaceholder" name="azureVmSizePlaceholder"  data-ng-required="false">
							 	<option value=""><cv:msg key="label.selectRegionMessage" bundle="restoreJs"/></option>
							</select>
							<span class="help-block" data-ng-show="restoreData.vmOptions.azureVmSize === null && cv.vmFullRestoreForm.getAttempted()"><cv:msg key="error.vmSize" bundle="restore"/></span>
						</label>
						<label for="azureDiskType" data-ng-if="(isDiskSkuApplicable && restoreData.vmOptions.restoreAsManagedVM) || (restoreData.isAll())" class="destination-vm"><cv:msg key="label.diskType" bundle="restore"/>
							<select data-ng-show="azureVmSizesLoaded" id="azureDiskType" name="azureDiskType"  data-ng-required="true"
									data-ng-model="restoreData.vmOptions.azureDiskType"
									data-ng-change="azureVmDiskTypeChanged()"
									data-ng-options="item as item.name for item in restoreData.vmOptions.azureDiskSkuNames track by item.id">
							</select>
							<select data-ng-show="!azureVmSizesLoaded" data-ng-disabled="true" id="azureVmDiskTypeholder" name="azureVmDiskTypeholder"  data-ng-required="false">
							 	<option value=""><cv:msg key="label.selectVmSizeMessage" bundle="restoreJs"/></option>
							</select>
							<span class="help-block" data-ng-show="restoreData.vmOptions.azureDiskType === null && cv.vmFullRestoreForm.getAttempted()"><cv:msg key="error.diskType" bundle="restore"/></span>
						</label>




										<label for="azureVmNetwork" class="destination-vm"><cv:msg key="label.networkInterface" bundle="restore"/>

												<isteven-multi-select
								   				  input-model="restoreData.vmOptions.azureNetworkList"
								   				  output-model="restoreData.vmOptions.azureNetworkInfoSelectedList"
								  				  button-label="networkDisplayLabel"
								  				  item-label="networkDisplayLabel"
								   				  tick-property="ticked"
								   				  class="isteven-multi-select user-group-select"
								   				  id="azureNetworkInfoSelection"
								   				  name="azureNetworkInfoSelection"
								   				  helper-elements="all none filter"
								   				  max-labels="1"
								   				  on-item-click="funcClick()"
								   				  on-select-none="funcClick()"
								   				  on-select-all="funcClick()"
								   				  on-close="azureNetworkOptionListChanged(restoreData.vmOptions.azureNetworkInfoSelectedList)"
								   				  on-reset="funcClick()">
												</isteven-multi-select>
											</label>



	                         <div data-ng-if="((vendor=='AZURE_V2') || (vendor=='AZURE_STACK'))">
	                       	<input name="createPublicIp" id="createPublicIp"
								type="checkbox" data-ng-model="restoreData.vmOptions.createPublicIp"
								data-ng-change="azureCreatePublicIpChanged()"> <label
								for="createPublicIp" class="destination-vm"><cv:msg
									key="label.createPublicIp" bundle="restore" /></label>
					<!-- 	<div class="cv-modal-wrapper no-pad">
						<input id="createPublicIp" type="checkbox" data-ng-model="restoreData.vmOptions.createPublicIp" data-ng-change="azureCreatePublicIpChanged('{{restoreData.vmOptions.createPublicIp}}')">
	                    <label class="checkbox-label" >Create Public Ip</label>
	                    </div> -->
						<label for="securityGroup" class="destination-vm"><cv:msg key="label.securityGroup" bundle="restore"/>
							<select  id="securityGroup" name="securityGroup"  data-ng-required="true"
									data-ng-model="restoreData.vmOptions.securityGroup"
									data-ng-change="securityGroupChanged('{{restoreData.vmOptions.securityGroup}}')"
									data-ng-options="item as item.groupName for item in restoreData.vmOptions.securityGroupList">
							</select>
							<%-- <select data-ng-show="!securityGroupLoaded" data-ng-disabled="true" id="securityGroupPlaceholder" name="securityGroupPlaceholder"  data-ng-required="false">
							 	<option value=""><cv:msg key="label.loading" bundle="restoreJs"/></option>
							</select> --%>
							<%-- <span class="help-block" data-ng-show="restoreData.vmOptions.securityGroup === null && cv.vmFullRestoreForm.getAttempted()"><cv:msg key="error.vmSize" bundle="restore"/></span> --%>
						</label>
	                     </div>
						 <div data-ng-if="((vendor==='AZURE_V2') || (vendor==='AZURE_STACK'))" title="{{restoreData.vmOptions.isAll && restoreAsManagedVMChangedAtVMLevel ? restoreAsManagedVMTitle : ''}}">
							<input name="restoreAsManagedVM" id="restoreAsManagedVM"
								type="checkbox" data-ng-model="restoreData.vmOptions.restoreAsManagedVM"
								data-ng-change="azureRestoreAsManagedVMChanged()"> <label
								for="restoreAsManagedVM" class="destination-vm top-margin" ><cv:msg
									key="label.restoreAsManagedVM" bundle="restore" /></label>
						</div>
					</div>
				</div>
				<div class="button-container">
					<button id="vmFullRestoreAzure_button_#2783" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button>
					<button id="vmFullRestoreAzure_button_#4312" type="submit"  class="btn cvBusyOnAjax btn-primary"><cv:msg key="Submit" bundle="messages"/></button>
				</div>
			</form>
			</div>
				<label id="vmFullRestoreAzure_label_powerOn" data-ng-click="restoreData.globalOptions.powerOn = !restoreData.globalOptions.powerOn" for="powerOn" class="overwriteLabel">
					<toggle-control id="vmFullRestoreAzure_toggle_powerOn" status="restoreData.globalOptions.powerOn ? 'enabled-activity' : 'disabled-activity'">
					</toggle-control><span><cv:msg key="label.powerOn" bundle="restore"/></span>
				</label>
				<label id="vmFullRestoreAzure_label_overwrite" data-ng-click="restoreData.globalOptions.overwrite = !restoreData.globalOptions.overwrite; overwriteOptionChanged()">
					<toggle-control id="vmFullRestoreAzure_toggle_overwrite" status="restoreData.globalOptions.overwrite ? 'enabled-activity' : 'disabled-activity'">
					</toggle-control><span><cv:msg key="warning.overwrite" bundle="restore" /></span>
				</label>
				<label>
					<div class="global-options remove-border-padding padding-top-10 padding-left-10">
						<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
					</div>
				</label>
		</div>
</fmt:bundle>
