<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><span data-ng-if="!vmFailbackController.isUndoFailoverOnlySupported"><cv:msg key="action.failback" bundle="vmsJs"/></span><span data-ng-if="vmFailbackController.isUndoFailoverOnlySupported"><cv:msg key="label.undoFailover" bundle="dr"/></span></h1>
	</div>
	<div class="bootstrap-wrapper">
		<div class="modal-body">
				<form ng-submit="vmFailbackController.failback()">
					<cv-please-note data-ng-if="vmFailbackController.showSourceVMOverwrittenNote" header='<cv:msg key="action.note" bundle="restoreJs" />' body='<cv:msg key="msg.sourceVMOverwrittenAtFailover" bundle="dr"/>'></cv-please-note>
					<div class="form-group">
						<div class="col-md-12">
							<label>
								<span  data-ng-if="vmFailbackController.isUndoFailoverOnlySupported">
									<cv:msg key="label.confirmUndoFailover" bundle="dr"/>
								</span>
								<span  data-ng-if="!vmFailbackController.isUndoFailoverOnlySupported">
									<cv:msg key="msg.confirmPowerOffDRVM" bundle="dr"/>
								</span>
							</label>
						</div>
					</div>
					<div class="form-group" data-ng-if="vmFailbackController.showUndoFailover && vmFailbackController.DRVendorType != 'ORACLE_CLOUD_INFRASTRUCTURE'"  data-ng-disabled="vmFailbackController.disableDiscardChanges">
						<div class="checkbox">
							<input type="checkbox" name="discardChanges" id="discardChanges" data-ng-model="vmFailbackController.discardChanges"/>
							<label for="discardChanges" class="cv-label">
								<cv:msg key="label.discardChanges" bundle="vmsJs"/>
								<cv-help-component ng-cloak help-text="<cv:msg key="info.discatdChanges" bundle="vmsJs" />" ></cv-help-component>
							</label>
							<span data-ng-if="vmFailbackController.missingDiscardChanges" class="col-xs-12 server-message {{vmFailbackController.missingDiscardChanges.type}}">{{vmFailbackController.missingDiscardChanges.message}}</span>
						</div>
					</div>
					<div data-ng-if="vmFailbackController.DRVendorType === 'MICROSOFT'">
					<img ng-src="{{vmFailbackController.imgRootPath}}/undo-failover-steps.png" class="dr4StepsImg"></img>
							<div class="dr4StepsTxt">
								<div class="drStepsTxt"><cv:msg key="label.discardChanges" bundle="dr" /></div>
								<div class="drStepsTxt"><cv:msg key="label.powerOffDRVM" bundle="dr"/></div>
								<div class="drStepsTxt"><cv:msg key="label.powerONProductionVM" bundle="dr"/></div>
								<div class="drStepsTxt"><cv:msg key="label.enableLiveSync" bundle="dr"/></div>
							</div>

					</div>
					<div data-ng-if="vmFailbackController.DRVendorType != 'MICROSOFT'" data-ng-switch="vmFailbackController.discardChanges">
						<div data-ng-switch-when="true">
							<img ng-src="{{vmFailbackController.imgRootPath}}/undo-failover-steps.png" class="dr4StepsImg"></img>
							<div class="dr4StepsTxt">
								<div class="drStepsTxt"><cv:msg key="label.discardChanges" bundle="dr" /></div>
								<div class="drStepsTxt"><cv:msg key="label.powerOffDRVM" bundle="dr"/></div>
								<div class="drStepsTxt"><cv:msg key="label.powerONProductionVM" bundle="dr"/></div>
								<div class="drStepsTxt"><cv:msg key="label.enableLiveSync" bundle="dr"/></div>
							</div>
						</div>
						<div data-ng-switch-default>
							<img ng-src="{{vmFailbackController.imgRootPath}}/failback-steps.png" class="dr5StepsImg marginTop10px"></img>
							<div class="dr5StepsTxt marginTop10px">
								<div class="drStepsTxt"><cv:msg key="label.shutdownDRVM" bundle="dr"/></div>
								<div class="drStepsTxt"><cv:msg key="label.incrementalBackupDRVM" bundle="dr"/></div>
								<div class="drStepsTxt"><cv:msg key="label.restoreChangestoProductionVM" bundle="dr"/></div>
								<div class="drStepsTxt padding0505px"><cv:msg key="label.powerOnSourceVM" bundle="dr"/></div>
								<div class="drStepsTxt"><cv:msg key="label.enableSync" bundle="dr"/></div>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
	<div class="setup-content">
		<div class="button-container">
			<button id="vmFailback_button_#2827" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="vmFailbackController.closeModal()"><cv:msg key="Cancel" bundle="messages"/></button>
			<button id="vmFailback_button_#7954" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="vmFailbackController.failback()"><span data-ng-if="!vmFailbackController.isUndoFailoverOnlySupported"><cv:msg key="action.failback" bundle="vmsJs"/></span><span data-ng-if="vmFailbackController.isUndoFailoverOnlySupported"><cv:msg key="label.undoFailover" bundle="dr"/></span></button>
		</div>
	</div>
</div>