<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<span class="setup-content">
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
</span>
<div class="form-horizontal edit-users-grid-form bootstrap-wrapper vm-disk-restore-form">
	<form name="vmDiskAsNewInstaceAWSRestoreForm" novalidate data-cv-submit="restoreVms()" autocomplete ="off" >
		<div>
			<!-- Destination client -->
			<div class="form-group">
				<label for="serverId" class="col-xs-12 col-md-5 col-lg-5">
					<cv:msg key="label.destinationServer" bundle="restore"/>
				</label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<cv-select-hypervisors
						model="model"
						vendor="AMAZON"
						ctrl="ctrl">
					</cv-select-hypervisors>
				</div>
			</div>
			<!-- Proxy client -->
			<div class="form-group" data-ng-show="!hideProxy">
				<label for="destinationProxy" class="col-xs-12 col-md-5 col-lg-5" >
					<cv:msg key="label.proxyClient" bundle="restore"/>
				</label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<cv-select-proxy
						model="model"
						vendor="AMAZON"
						ctrl="ctrl"
						selection="single">
					 </cv-select-proxy>
				 </div>
			</div>
					
			<!-- Instance display name -->
			<div class="form-group">
				<label for="instanceDisplayName" class="col-xs-12 col-md-5 col-lg-5">
					<cv:msg key="label.changeInstanceDisplayName" bundle="restore"/>
				</label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input class="no-padding" type="text" name="instanceDisplayName" data-ng-model="model.instanceDisplayName"/>
				</div>
			</div>
			
			<div data-ng-bind="serverMessage.message"></div>
		</div>
		
		<div class="error" data-ng-show="cv.vmDiskAsNewInstaceAWSRestoreForm.getAttempted() && showSomeVmsInvalidWarning()" ><cv:msg key="error.allInstanceOptions" bundle="restore"/></div>
		<div>
			<uib-accordion close-others="true" class="text-left tab-panel-padding">
				<!-- Amazon instance options -->
				<div uib-accordion-group is-open="amazonInstanceOptions" class="accordion">
					<uib-accordion-heading><cv:msg key="label.amazonVolumeOptions" bundle="restore"/>
						<i class="pull-right glyphicon" data-ng-class="{'glyphicon-chevron-down': amazonInstanceOptions, 'glyphicon-chevron-right': !amazonInstanceOptions}"></i>
					</uib-accordion-heading>
					<div class="form-group">
						<div class="col-xs-12 col-md-5 col-lg-5 scrolling-div-300">
							<ul class="vm-disk-restore-list width-full" >
								<li data-ng-repeat="diskOptions in model.diskOptionsList">
									<a class="btn" data-ng-click="displayDiskOptions(diskOptions)" 
									data-ng-class="{'selected-value': model.diskOptions == diskOptions}" 
									title="{{diskOptions.browseData.displayName}}">{{diskOptions.browseData.displayName}}</a>
									<!-- <span data-ng-show="cv.vmDiskRestoreForm.getAttempted() && !isDiskOptionValid(diskOptions)">(!)</span>-->
								</li>
							</ul>
						</div>		
						<div class="no-padding col-xs-7 col-md-7 col-lg-7">
							<div id="vm-per-disk-options" class="mainFormContent">
								<!-- Volume name selection -->
								<input type="text" name="displayName"
								data-ng-model="model.diskOptions.newName" 
								data-ng-required="false" 
								placeholder="<cv:msg key='label.renameAWSVolume' bundle='restore'/>"/>
								<span class="parenthetical-text no-margin italic">
									<cv:msg key="label.volumeName" bundle="restore"/>
								</span>
							</div>
						</div>
					</div>
				</div>
				<!-- Amazon cloud options -->
				<div uib-accordion-group is-open="amazonCloudOptions" class="accordion">
					<uib-accordion-heading><cv:msg key="label.amazonCloudOptions" bundle="restore"/>
						<i class="pull-right glyphicon" data-ng-class="{'glyphicon-chevron-down': amazonCloudOptions, 'glyphicon-chevron-right': !amazonCloudOptions}"></i>
					</uib-accordion-heading>
					
					<!-- Availability zone -->
					<cv-availability-zone
						selected-hypervisor="model.selectedHypervisor"
						selected-availability-zone="model.selectedAvailabilityZone"
						on-after-availability-zone-selected="ctrl.refreshAvailabilityZone(availabilityZone)">
					</cv-availability-zone>
				
					
					<!-- AMI Selection-->
					<cv-amazon-ami-selection
						selected-hypervisor="model.selectedHypervisor"
						selected-availability-zone="model.selectedAvailabilityZone"
						model="model"
						ctrl="ctrl">
					</cv-amazon-ami-selection>
					
					<!-- Instance type selection -->
					<cv-instance-types
						selected-hypervisor = "model.selectedHypervisor"
							selected-instance-type = "model.selectedInstanceType"
							hide-auto-select-instance-type = "true">
						</cv-instance-types>			
					
					<!-- Network settings and Security groups selection -->
					<div data-ng-if="ctrl.showNetworkSettings">
						<cv-network-setting
							selected-hypervisor = "model.selectedHypervisor"
							selected-availability-zone ="model.selectedAvailabilityZone"
							selected-network-settings = "model.selectedNetworkSettings"
							auto-security-group-checked = "model.autoSecurityGroupChecked"
							selected-security-groups = "model.selectedSecurityGroups">
						</cv-network-setting>
					</div >
				</div>	
			</uib-accordion>
		</div>
		
		<div class="form-group">
			<div class="col-xs-12">
				<input name="powerOn" id="powerOn" type="checkbox" data-ng-model="model.powerOn">
				<label for="powerOn" class="overwriteLabel">
					<cv:msg key="label.powerInstanceOn" bundle="restore"/>
				</label>
			</div>
		</div>
		
		<div class="form-group">
			<div class="col-xs-12">
				<input name="overwrite" id="overwrite" 
					type="checkbox" data-ng-model="model.overwrite"
					data-ng-change="overwriteOptionChanged()">
				<label for="overwrite" class="overwriteLabel">
					<cv:msg key="warning.overwriteInstance" bundle="restore"/>
				</label>
			</div>
		</div>
		<div class="form-group">
			<div class="col-xs-12">
				<label>
					<div class="global-options remove-border-padding padding-top-10 padding-left-10">
						<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
					</div>
				</label>
			</div>
		</div>
		
		<div class="modal-footer">
			<button id="vmDiskAsNewInstanceAWSRestore_button_#2126" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"> 
				<cv:msg key="Cancel" bundle="messages"/>
			</button>
			<button id="vmDiskAsNewInstanceAWSRestore_button_#1191" type="submit"  class="btn btn-primary cvBusyOnAjax" > 
				<cv:msg key="Submit" bundle="messages"/>
			</button>
		</div>
	</form>
</div>
