<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.security"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvMessages bundle="localization.${param.vendor}"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvEnum name="App.VSAFailoverStatus"></cv:cvEnum>
	<cv:cvEnum name="App.VSAReplicationStatus"></cv:cvEnum>
    <cv:cvEnum name="Api.VirtualAppJobPhaseType"></cv:cvEnum>
	<cv:cvEnum name="App.VMSLAStatus"></cv:cvEnum>
	<cv:cvEnum name="Common.VSVendor"></cv:cvEnum>
</script>
<cv:bundle override="${param.vendor}"/>
<div class="row">
	<div class="col-xs-12"><h1 class="page-title" data-ng-bind="vm.name"></h1></div>
</div>
<cv-tab-nav></cv-tab-nav>
<div class="row">
	<div class="col-md-12">
		<span data-ng-if="vm.subclientId && vm.vmStatus !== 'NOT_PROTECTED' && vm.isContentIndexded" class="page-action-item search-widget-wrapper search-filter">
			<input name="fileAndFolderSearch" id="fileAndFolderSearch" type="search" data-ng-model="model.vmSearchTerm" style="width:220px" autocomplete="off"
			 placeholder="<cv:msg key="label.globalSearch.filesCommandDescription" bundle="messages" />" class="search-field" data-ng-keyup="$event.keyCode == 13 && searchVM()" title="<cv:msg key="placeholder.searchFilesAndFolders" bundle="serversJs" />">
			<input style="display:none" type="search" name="fileAndFolderSearch" />
			<span data-ng-click="model.vmSearchTerm=''" class="form-control-clear glyphicon glyphicon-remove form-control-feedback" title='<cv:msg key="label.clear" bundle="messages" />'></span>
		</span>
		<!-- <span data-ng-if="vm.subclientId && showRemoveVM && !vm.isDeleted" data-ng-click="removeVM()"><a class="page-action-item" href=""><cv:msg key="action.remove" bundle="vmsJs" /></a></span>
		<cv-capability-links data-ng-if="vmDetailsActionsLoaded" cv-permitted-options="permittedOptions"></cv-capability-links>  -->
	</div>
</div>
<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
<div class="margin-top-20" data-ng-if="!hidePage">
	<!-- Overview tab -->
	<div class="row" data-ng-if="isOverviewTabSelected">

		<div class="col-md-6">
			<cv-tile-component data-ac-id="vmDetails-label_summary-servers" data-title='<cv:msg key="label.summary" bundle="servers"/>' cv-capability="cvCapabilityConfig.general">
				<ul class="list-style-secondary">
					<li data-ng-if="showInfra" class="group" data-ng-if="vm.pseudoClient.clientName"><span class="pageDetailColumn">
						<cv:msg key="header.server" bundle="vmsJs" /></span>
						<a href="{{detailsCustomHref}}"><span data-ng-bind="vm.pseudoClient.clientName"></span></a></li>
					<li data-ng-if="showInfra" class="group" data-ng-if="vm.subclientName"><span class="pageDetailColumn">
						<cv:msg key="header.vmGroup" bundle="vmsJs" /></span>
						<a href="{{detailsCustomHrefForAppGroup}}"> <span data-ng-bind="vm.vsaNextBackupSubClientEntity.subclientName"></span></a></li>
					<li data-ng-if="showInfra && showOSAndVMHost" class="group"><span class="pageDetailColumn" data-ng-bind="vmHostText"></span> <span class="pageDetailColumn" data-ng-bind="vm.vmHost"></span></li>
					<li data-ng-if="showOSAndVMHost" class="group"><span class="pageDetailColumn"><cv:msg key="header.OS" bundle="vmsJs" /></span>
						<span class="pageDetailColumn" data-ng-bind="vm.strOSName"></span></li>
				    <li data-ng-if="showVendor" class="group"><span class="pageDetailColumn">
						<cv:msg key="filter.vmvendor" bundle="vmsJs" /></span>
						<span class="pageDetailColumn" data-ng-bind="vendorText"></span></li>
					<li class="group"><span class="pageDetailColumn" data-ng-bind="vmSizeText"></span> <span class="pageDetailColumn" data-ng-bind="vm.vmSize | capacity"></span></li>
					<li class="group" data-ng-if="vm.applicationSize && vm.applicationSize!=0"><span class="pageDetailColumn" data-ng-bind="appSizeText"></span> <span class="pageDetailColumn" data-ng-bind="vm.applicationSize | capacity"></span></li>

					<li data-ng-if="vm.plan.planName" class="group">
					   <div>
					   <span class="pageDetailColumn"><cv:msg key="header.plan" bundle="vmsJs" /></span>
						<div class="pageDetailColumn inline-editor">   <a  data-ng-if="$state.href('profile')" href="#/profileDetails/{{vm.plan.planId}}"><span  class="inline-editor-text" >{{vm.plan.planName}}</span></a>
						<span data-ng-if="!$state.href('profile')" class="inline-editor-text" >{{vm.plan.planName}}</span>
					    <span  class="inline-editor-buttons">
					        <a class="inline-editor-button text"  data-ng-click="editPlan()"> <cv:msg key="label.inlineEdit" bundle="messagesJs"/></a>
					    </span>
					    </div>
					    </div>
					</li>
					<li class="group"><span class="pageDetailColumn"><cv:msg key="header.latestRecoveryPoint" bundle="vmsJs" /></span> <span data-ng-if="vm.LatestRecoveryTime" class="pageDetailColumn" ng-bind="vm.LatestRecoveryTime*1000 | date:'medium'">
						</span></li>
					<li class="group"><span class="pageDetailColumn"><cv:msg key="header.oldestRecoveryPoint" bundle="vmsJs" /></span> <span data-ng-if="vm.OldestRecoveryPoint" class="pageDetailColumn" ng-bind="vm.OldestRecoveryPoint*1000 | date:'medium'">
						</span></li>

					<li data-ng-if="companyId" class="group">
						<span class="pageDetailColumn"><cv:msg key="label.company" bundle="messagesJs" /></span>
						<span class="pageDetailColumn" >
							<a href="#/subscriptions/{{companyId}}" data-ng-bind="companyName"></a>
						</span>
					</li>
					<li class="group"><span class="pageDetailColumn"><cv:msg key="header.syncStatus" bundle="vmsJs" /></span> 
						<span class="pageDetailColumn">
							<span data-ng-class="{'text-success':isVMProtected,'text-danger':!isVMProtected && !isWarningStatus && !isVmBackuedUpWithError, 'text-warning':isWarningStatus || isVmBackuedUpWithError}"
							 data-ng-bind="vmStatus">
							</span>
							<div data-ng-if="isWarningStatus || isVmBackuedUpWithError">
								<span
								 	ng-bind-html="miniText">
								</span>
								<cv-call-out data-ng-if="vmFailureReasonExists && isWarningStatus" html-template="vmFailureReason"></cv-call-out>
								<span data-ng-if="vmFailureReasonExists && isVmBackuedUpWithError" data-ng-bind="vmFailureReason"></span>
							</div>
						</span>
					</li>
				</ul>
			</cv-tile-component>
			<div data-ng-if="vm.hasOwnProperty('discoveredApps') && validationInfo.hasOwnProperty('bootStatus')">
				<cv-tile-component data-ac-id="vmDetails-label_applicationsDiscovered" data-title='<cv:msg key="label.backupValidationStats" bundle="dr"/>' loader="isBackupValidationInfoLoaded">
				<ul class="list-style-secondary">
					<li class="group"><span class="pageDetailColumn">
						<cv:msg key="label.bootStatus" bundle="dr" /></span>
						<span ng-if="validationInfo.bootStatus === true" class="text-success"><cv:msg key="label.success" bundle="dr" /></span><span data-ng-if="validationInfo.bootStatus === false" class="notProtected"><cv:msg key="label.failed" bundle="dr" /><span>
					</li>
					<li class="group" data-ng-if="validationInfo.hasOwnProperty('lastValidationJobId')">
					<span class="pageDetailColumn" data-ng-if="backupRanAfterLastValidationJob">
						<cv-help-text help-label="label.lastInvalidValidationJobId" help-text="label.latestBackupValidationToolTip"></cv-help-text>
					</span>
					<span class="pageDetailColumn" data-ng-if="!backupRanAfterLastValidationJob">
						<cv:msg key="label.lastInvalidValidationJobId" bundle="dr" />
					</span>
						<a href=#/jobs/{{validationInfo.lastValidationJobId}}>{{validationInfo.lastValidationJobId}}</a>
					</li>
					<li class="group" data-ng-if="validationInfo.hasOwnProperty('lastValidatedBackupJobId')"><span class="pageDetailColumn">
						<cv:msg key="label.lastValidatedBackupJobId" bundle="dr" /></span>
						<a href=#/jobs/{{validationInfo.lastValidatedBackupJobId}}>{{validationInfo.lastValidatedBackupJobId}}</a>
					</li>
					<li class="group" data-ng-if="validationInfo.hasOwnProperty('lastValidatedBackupJobCompletionTime')"><span class="pageDetailColumn">
						<cv:msg key="label.lastValidatedBackupJobCompletionTime" bundle="dr" /></span>
						<span class="pageDetailColumn">{{validationInfo.lastValidatedBackupJobCompletionTime*1000 | date:'medium'}}</span>
					</li>
				</ul>
					<div class="resultCheckReadiness">
					<table id="disoveredAppsList" class="detailTable checkReadinessTable" data-ng-if="backupValidationInfo.length > 0 && backupValidationGridOptions.gridOptions.columnDefs.length > 1">
					<thead>
						<tr class="heading" id="discoveredAppsHeader">
							<th data-ng-bind-html="'<cv:msg key="label.name" bundle="dr"/>'"></th>
							<th data-ng-bind-html="'<cv:msg key="label.scriptStatus" bundle="dr"/>'"></th>
							<th data-ng-bind-html="'<cv:msg key="label.failureReason" bundle="dr"/>'"></th>
						</tr>
					</thead>
					<tbody>
						<tr data-ng-repeat="applicationDiscovered in backupValidationInfo | orderBy: 'appName'" id="discoveredApp_{{$index}}">
							<td data-ng-bind-html="applicationDiscovered.appName"></td>
							<td class="white-space-normal">
								<span ng-if="applicationDiscovered.validationStatus === true" class="text-success">
									<cv:msg key="label.success" bundle="dr" />
								</span>
								<span data-ng-if="applicationDiscovered.validationStatus === false" class="notProtected">
									<cv:msg key="label.failed" bundle="dr" />
								</span>
							</td>
							<td data-ng-bind-html="applicationDiscovered.failureReason"></td>
						</tr>
					</tbody>
					</table>
					</div>
				</cv-tile-component>
			</div>
		</div>
		<div class="col-md-6">
			<cv-backup-history is-live-mount-supported="false" live-mount="liveMountVM(toTime)" data-title='<cv:msg key="label.recoveryPoint" bundle="vmsJs"/>' entity="backupEntity" params="historyParams" on-restore="performVMRestore(job, fromTimeStr, toTimeStr)"
			on-validate-backup="validatePITBackup" is-backup-validation-eligible="isAppValidationEnabled" ng-if="showBackupHistoryCalendarView() && vm && vm.subclientId" show-legend="'true'"></cv-backup-history>
		</div>
		<div class="col-md-12"  data-ng-if="vm && vm.vendor === 'VMW' && showReplicationGrid">
			<cv-replication-monitor app-type-id="106" replication-entites="vm.siteInfo"> </cv-replication-monitor>
		</div>



	</div>
	<!-- Configuration tab -->
	<div class="row" data-ng-if="!isOverviewTabSelected">
		<div class="col-md-6">
			<cv-security-component entity-type='entityType' generic-entity='genericEntity' associations='formattedSecurityAssociations'
				associations-loaded="associationsLoaded" data-show-Owners='true' default-tab='owner' cv-capability="cvCapabilityConfig.security">
			</cv-security-component>
		</div>
		<div class="col-md-6" data-ng-if="vm">
			<cv-passkey-setting-component source-page="vmDetails" vm-props="vm">
			</cv-passkey-setting-component>
		</div>
		<div class="col-md-6" data-ng-if="vm">
			<cv-entity-tags-tile data-ng-if="entityObject" entity="entityObject" has-edit-permissions="userHasEditTagsPermission"></cv-entity-tags-tile>
		</div>
		
	</div>
</div>
