<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.anomaly"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<span data-ng-bind="::virtualizeMeTitle"/>
	</h1>
</div>
<div class="setup-content">
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<form name="vmFullRestoreForm" novalidate class='thisVM restore-form' data-cv-submit="virtualizeVM()" autocomplete="off">
		<div >
			<label for="backupSets" class="select-label restorePathLabel">
				<cv:msg key="label.backupSet" bundle="restore"></cv:msg>
				<select data-ng-model="virtualizeMeData.globalOptions.backupSet"
					data-ng-options="backupSet as getBackupSetName(backupSet) for backupSet in virtualizeMeData.globalOptions.backupSets" required
					data-ng-change="backupSetChanged()">
				</select>
			</label>
		</div>
		<!-- virtualization target -->
		<div >
			<label for="virtualization-target" class="select-label restorePathLabel">
				<cv:msg key="label.lifeCyclePolicy" bundle="restore"></cv:msg>
				<select	name="virtualizationTarget"
					data-ng-model="virtualizeMeData.globalOptions.virtualizationTarget"
					data-ng-changed="virtualizationTargetChanged(virtualizeMeData.globalOptions.virtualizationTarget)"
					data-ng-disabled="!isVirtualizationTargetListAvailable() || !showOptions"
					data-ng-options="vTarget as getVirtualizationTargetName(vTarget) for vTarget in virtualizeMeData.globalOptions.virtualizationTargetList" required>
					<option value=''>{{getVirtualizationTargetDropdownText()}}</option>
				</select>
				<span class="help-block"
					data-ng-show="vmFullRestoreForm.virtualizationTarget.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.virtualizationTarget) && isVirtualizationTargetListAvailable() || (!virtualizeMeData.globalOptions.virtualizationTarget && cv.vmFullRestoreForm.getAttempted())">
						<cv:msg key="error.lifeCyclePolicy" bundle="restore"></cv:msg>
				</span>
			</label>
		</div>
		<div >
			<label for="displayName" class="destination-vm">
				{{vmDisplayNameLabel}}
				<input type="text" name="displayName"
					data-ng-required="true"
					data-ng-model="virtualizeMeData.globalOptions.displayName"/>
					<span class="help-block" data-ng-show="!isValidClientName() || (vmFullRestoreForm.displayName.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName) || (!virtualizeMeData.globalOptions.displayName && cv.vmFullRestoreForm.getAttempted()))">
						{{vmDisplayNameError}}
					</span>
			</label>
		</div>
		<div >
			<label for="hostName" class="destination-vm">
				<cv:msg	key="label.hostname" bundle="restore"></cv:msg>
				<input type="text" name="hostName"
					data-ng-required="virtualizeMeData.globalOptions.osType === 'Windows'"
					data-ng-model="virtualizeMeData.globalOptions.hostName"
					data-ng-pattern="hostNamePattern" />
					<span class="help-block" data-ng-show="virtualizeMeData.globalOptions.osType === 'Windows' && (!vmFullRestoreForm.hostName.$error.pattern && vmFullRestoreForm.hostName.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.hostName) || (!virtualizeMeData.globalOptions.hostName && cv.vmFullRestoreForm.getAttempted()))">
						<cv:msg key="error.hostName" bundle="restore"></cv:msg>
					</span>
					<span class="help-block margin-bottom-20" data-ng-show="virtualizeMeData.globalOptions.osType === 'Windows' && vmFullRestoreForm.hostName.$error.pattern && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.hostName)">
						<cv:msg key="error.hostname.pattern.virtualizeMe" bundle="restore"></cv:msg>
					</span>
			</label>
		</div>

		<div>
			<label for="networkSettingsDestination" class="select-label restorePathLabel">
				<cv:msg key="label.networkSettings" bundle="restore"></cv:msg>
				<select	name="networkSettings"
					data-ng-model="virtualizeMeData.globalOptions.networkSettings.destinationNetwork"
					data-ng-disabled="!isNetworksAvailable()"
					data-ng-options="network.destinationNetwork as network.destinationNetwork for network in virtualizeMeData.globalOptions.virtualizationTarget.networkList" required>
					<option disabled value=''><cv:msg key="label.selectNetworkSettings" bundle="restore"></cv:msg></option>
				</select>
				<span class="help-block"
					data-ng-show="vmFullRestoreForm.networkSettings.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.networkSettings) && isNetworksAvailable() || (!virtualizeMeData.globalOptions.networkSettings && cv.vmFullRestoreForm.getAttempted())">
						<cv:msg key="error.networkSettings" bundle="restore"></cv:msg>
				</span>
			</label>
		</div>
		<div >
		<label for="mountPoints" ><cv:msg key="label.mountPoints" bundle="restore"/>
										<div class="company-multi-select">
											<isteven-multi-select
							   				  input-model="virtualizeMeData.globalOptions.systemState.hwconfig.mtpt_list"
							   				  output-model="virtualizeMeData.globalOptions.selectedMountPointList"
							   				  disable-property="itemDisabled"
							  				  button-label="mtpt_name"
							  				  item-label="displayName"
							   				  tick-property="selected"
							   				  class="isteven-multi-select user-group-select"
							   				  id="mountPoints"
							   				  name="mountPoints"
							   				  max-labels="3"
							   				  on-item-click="funcClick()"
							   				  on-select-none="funcClick()"
							   				  on-select-all="funcClick()"
							   				  on-reset="funcClick()"
							   				  on-close="funcClick()"
							   				  helper-elements=""
							   				  is-disabled="!virtualizeMeData.globalOptions.systemState.hwconfig || !virtualizeMeData.globalOptions.systemState.hwconfig.mtpt_list.length">
											</isteven-multi-select>
									</div>
									</label>
		</div>
		<!-- select Clone option -->
		<div>
			<input name="cloneSelected" id="cloneSelected" type="checkbox"
				data-ng-model="virtualizeMeData.globalOptions.cloneMachine"
				data-ng-click="cloneOptionChanged()" />
			<label for="cloneSelected" class="overwriteLabel">
				<cv:msg key="label.cloneMachine" bundle="restore"></cv:msg>
			</label>
		</div>
    	<!-- Hiding this option for now -->

  		<%--
		<div class="global-options" data-ng-if="virtualizeMeData.globalOptions.cloneMachine">
		<span class="border-title"></span>
			 <label> <cv:msg	key="label.cloneClientName" bundle="restore" /> <input
				type="text" name="cloneClientName" data-ng-model="virtualizeMeData.globalOptions.cloneClientName" />
			</label> <label> <cv:msg	key="label.cloneHostName" bundle="restore" /> <input
				type="text" name="cloneHostName" data-ng-model="virtualizeMeData.globalOptions.cloneHostName" />
			</label>
		</div>
	 	--%>
		<div >
			<input name="overwrite" id="overwrite" type="checkbox"
				data-ng-model="virtualizeMeData.globalOptions.overwrite"
				data-ng-change="overwriteOptionChanged()">
			<label for="overwrite" class="overwriteLabel">
				<cv:msg key="warning.overwriteVM" bundle="restore"></cv:msg>
			</label>
		</div>
		<div class="button-container">
			<button id="virtualizeFileSystemVmware_button_#6837" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax"
				data-ng-click="cancel()">
				<cv:msg key="Cancel" bundle="messages"></cv:msg>
			</button>
			<button id="virtualizeFileSystemVmware_button_#5337" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="!showOptions">
				<cv:msg key="Submit" bundle="messages"></cv:msg>
			</button>
		</div>
	</form>
</div>