<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.devices"></cv:cvMessages>
	<cv:cvMessages bundle="localization.devicesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div data-ng-controller="userDetailController">
	<h1 class='page-title'>{{user.userEntity.userName}}</h1>
	<cv-capability-links data-ng-if="user" cv-permitted-options="permittedOptions"></cv-capability-links>
	<cv-tab-nav ng-if="isUserLoaded"></cv-tab-nav>
	<span class="server-message {{serverMessageDetails.type}}">{{serverMessageDetails.message}}</span>
	<div class="row">
		<div class="col-md-12">
			<div data-ng-if="isUserLoaded" class="page-details-box maxdiv">
				<div class="page-details group">
					<ul class="list-style-secondary">
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="tableHeader.name" bundle="users" /></span>
							<span class="pageDetailColumn">{{user.fullName}}</span>
						</li>
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="label.email" bundle="users" /></span>
							<span class="pageDetailColumn"><a href='mailto:{{user.email}}'>{{user.email}}</a></span>
						</li>
						<li class="group">
							<span class="pageDetail-three-columns-first"><cv:msg key="label.enabled" bundle="users" /></span>
							<span class="pageDetail-three-columns-second" data-ng-disabled="!enableUserAvailabilty">
								<toggle-control status="user.enableUser ? 'enabled-activity':'disabled-activity'" data-ng-click="toggleUserStatus()"></toggle-control>
							</span>
						</li>
						<li class="group user-detail-list">
							<span class="pageDetailColumn"><cv:msg key="tableHeader.userGroup" bundle="users" /></span>
							<span class="pageDetailColumn wrap-cv-fancy-tooltip">
								<cv-fancy-tooltip data-ng-if="user.userMap && user.userMap.length !== 0" cv-objects="user.userMap" cv-display-width="700"></cv-fancy-tooltip>
								<span class="server-message no-padding" data-ng-if="!user.userMap || user.userMap.length === 0"><cv:msg key="label.noGroup" bundle="users" /></span>
							</span>
						</li>
						<li class="group">
							<cv-plan-migration user-info="currUserInfo" is-modal=false show-tile="canEditUser" server-msg="serverMessageDetails"></cv-plan-migration>
						</li>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<div data-ng-if="showDevices">
		<div class="group" data-ng-controller="kendoDevicesListController">
			<div class="maxdiv">
				<cv-kendo-grid data-cv-grid-options="gridOptions"></cv-kendo-grid>
			</div>
		</div>
	</div>
</div>
