<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<!-- This jsp takes credentials for appaware feature  -->
<script>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div>
	<div class="setup-title"><h1><cv:msg key="header.setCredentials" bundle="servers"/></h1></div>
	<div class="bootstrap-wrapper">
		<div class="form-group">
			<div class="{{editCredServerMessage.type}} serverMessage">{{editCredServerMessage.message}}</div>
		</div>
		<form name="setCredentialForm"  novalidate data-cv-submit="saveCredentials()" autocomplete="off">
			<div class="form-group">
				<h4 class="col-xs-12"><cv:msg key="label.guestCredentials" bundle="servers"/></h4>
			</div>
			<div data-ng-if ="model.guestCredentials === 'enabled-activity'">
			<cv-credential-manager id="credentialMgr" model="model" form-name="setCredentialForm" input-name="guestName"
			password-complexity="1" is-optional="false" show-credential="true" password-required-on-edit="true"></cv-credential-manager>
			</div>
			<!-- if vsa ssh enable -->
			<div data-ng-if="isVsaSSHEnabled">
				<div class="form-group">
					<div class="col-xs-12">
						<label class="appCredentials"  data-ng-click="manageCredentials('app')">
							<toggle-control status="model.appCredentials" title="<cv:msg key="label.useGuestCredentials" bundle="servers"/>" ></toggle-control>
							<span><cv:msg key="label.useApplicationCredentials" bundle="servers"/></span>
						</label>
					</div>
				</div>
				<div data-ng-if ="model.appCredentials === 'enabled-activity'">
					<cv-credential-directive id="setCredentialsId" credentials="model" form-name="setCredentialForm" input-name="appName" password-complexity="1"></cv-credential-directive>
				</div>
			</div><!--end of vsa ssh is enabled -->
			<div class="button-container">
				<button id="setCredentials_button_#3619" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button> 
				<button id="setCredentials_button_#7890" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="Save" bundle="messages"/></button> 
			</div>
		</form>
		
	</div>
</div>
