<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.events"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vms"></cv:cvMessages>
	<cv:cvMessages bundle="localization.${param.vendor}"></cv:cvMessages>
	<cv:cvEnum name="Common.VSVendor"></cv:cvEnum>
</script>
<cv:bundle override="${param.vendor}"/>
<div class="row">
	<div class="col-xs-12 flex-detail-header"><cv-changename data-ng-if="changeNameObj" obj='changeNameObj' service-method='changeServerName.do' class="float-left"></cv-changename></div>
</div>
<div class="serverDetails-alerts">
	<alert-detail-sign class="margin-top-20" data-ng-if="showOverlay && !allProxiesFailed" type="danger" text="label.proxyInstallMessage"></alert-detail-sign>
	<alert-detail-sign class="margin-top-20"  data-ng-if="allProxiesFailed" type="danger" text="label.allProxiesFailedMessage" link-label="action.deleteServer" extra-func="deleteServer()" ></alert-detail-sign>
	<alert-detail-sign class="margin-top-20"  data-ng-if="!showOverlay && !allProxiesFailed && subclientList.length === 1 && subclientList[0].sc.commonProperties.isDefaultSubclient && subclientList[0].sc.commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyId == 0" type="danger" text="label.collectionNotAdded" link-label="action.addCollection" extra-func="openAddCollectionDialog()"></alert-detail-sign>
</div>
<cv-tab-nav></cv-tab-nav>
<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
<div data-ng-if="!hidePage" data-ng-class="{'overlay':showOverlay || allProxiesFailed}">
	<!-- Overview tab -->
	<div data-ng-show="selectedTabIndex === 0">
		<div class="overviewTab">
			<div data-ng-if="selectedTabIndex === 0 && details">
				<div class="row">
					<div class="col-md-6">
						<cv-tile-component data-ac-id="serverDetails-heading-general" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />' loader="details.clientInfo" cv-capability="cvCapabilityConfig.general">
							<ul class="list-style__row group">
								<li data-ng-if="userName && serverType!=='VMW'" class="group">
									<span class="pageDetailColumn"><cv:msg key="label.userName" bundle="servers" /> </span>
									<span class="pageDetailColumn ">{{userName}}</span>
								</li>
								<li data-ng-if="hostNameFromInstance && serverType ==='AMAZON'" class="group">
		                           	<span class="pageDetailColumn"><cv-help-text help-label="<cv:msg key="label.regionEndPoints" bundle="servers"/>"
										help-text="'<cv:msg key='info.region' bundle='servers'/>'">
									</cv-help-text> </span>
									<span class="pageDetailColumn ">{{hostNameFromInstance}}</span>
								</li>
								<li data-ng-if="serverType ==='VCLOUD' && organization" class="group">
									<span class="pageDetailColumn"><cv:msg key="label.organization" bundle="servers" /> </span>
									<span class="pageDetailColumn ">{{organization}}</span>
								</li>
								<li data-ng-if="hostNameFromInstance && !hideHostname && !(serverType ==='VCLOUD' && adminAccountAssociated)" class="group">
									<span class="pageDetailColumn">{{hostNameLabel}} </span>
									<span class="pageDetailColumn ">{{hostNameFromInstance}}</span>
								</li>
								<li data-ng-if="serverType" class="group">
									<span class="pageDetailColumn"><cv:msg key="label.vendor" bundle="servers" /> </span>
									<span class="pageDetailColumn ">{{::serverTypeName}}</span>
								</li>
								<li data-ng-if="vmBackupInfo.vmTotalCount" class="group">
									<span class="pageDetailColumn">{{::protectedVMCountLabel}}</span>
									<span class="pageDetailColumn ">{{vmBackupInfo.vmProtectedCount + vmBackupInfo.vmBackedUpWithErrorCount}}</span>
								</li>

								<li data-ng-if="companyId" class="group padding-top-15">
									<span class="pageDetailColumn"><cv:msg key="label.company" bundle="messagesJs" /></span>
									<span class="pageDetailColumn" >
										<a href="#/subscriptions/{{companyId}}" data-ng-bind="companyName"></a>
									</span>
								</li>
							</ul>
							 <div class="page-details-box-links" data-ng-if="showEditServer">
                        		<a data-ng-if="serverType!='MICROSOFT'" href="" data-ng-click="showEditServerDialog()">
                            		<cv:msg key="label.edit" bundle="clients" />
                        		</a>
                        		<a data-ng-if="serverType=='MICROSOFT'" href="" data-ng-click="editAccount()">
									<cv:msg key="action.edit" bundle="collections" />
								</a>
                    		</div>
						</cv-tile-component>
						<cv-tile-component data-ng-if="serverType=='VMW'" data-ac-id="serverDetails-label_account" data-title='<cv:msg key="label.account" bundle="servers"/>'>
							<ul class="list-style-secondary">
								<li class="group">
									<span class="pageDetailColumn"><cv:msg key="label.hostName" bundle="servers" /></span>
									<span class="pageDetailColumn " ><span data-ng-if="hostName"> {{hostNameFromInstance}}</span>
									<span data-ng-if="!hostNameFromInstance && serverDetailLoaded"><cv:msg key="label.notSet" bundle="settingsJs" /></span>
									<span data-ng-if="!serverDetailLoaded"><cv:msg key="Loading" bundle="messages" /></span>
								</li>
								<li class="group">
									<span class="pageDetailColumn"><cv:msg key="label.userName" bundle="servers" /></span>
									<span class="pageDetailColumn " ><span data-ng-if="userName"> {{userName}}</span>
									<span data-ng-if="!userName && serverDetailLoaded"><cv:msg key="label.notSet" bundle="settingsJs" /></span>
									<span data-ng-if="!serverDetailLoaded"><cv:msg key="Loading" bundle="messages" /></span>
								</li>
							</ul>
							<div class="page-details-box-links" >
								<a href="" data-ng-click="editAccount()">
									<cv:msg key="action.edit" bundle="collections" />
								</a>
							</div>
						</cv-tile-component>
					</div>
					<div class="col-md-6">
						<cv-backup-history data-title='<cv:msg key="label.recoveryPoint" bundle="vmsJs"/>' entity="backupEntity" show-legend="'true'" params="historyParams"  on-restore="performRestore(job, fromTimeStr, toTimeStr)" ng-if="backupEntity"></cv-backup-history>
					</div>
				</div>
				<cv-kendo-grid data-cv-grid-options="gridOptions" class="details"></cv-kendo-grid>
			</div>
		</div>
	</div>
	 <!-- Distribution tab -->
	 <div data-ng-if="selectedTabIndex === 1">
	 	<data-ng-include src="'reportView.do'"></data-ng-include>
	 </div>
	 <!-- Configuration tab -->
    <div data-ng-show="selectedTabIndex === 2">
		<div class="row">
			<div class="col-md-6">
				<cv-tile-component data-ac-id="serverDetails-heading_clientActivityControl-clients" data-title='<cv:msg key="heading.clientActivityControl" bundle="clients"/>' loader="dataManagement">
					<ul class="list-style-secondary">
						<cv:comp name="show.label.data.management">
						<li class="group">
						<span class="pageDetailColumn"><cv-help-text help-label="Data_Backup" help-text="info.help.dataBackup"/></span>
							<span class="pageDetailColumn">
								<toggle-control class="{{dataManagement}}" status="dataManagement" data-ng-click="manageActivity('backup')" title="Enable/disable <cv:msg key='Data_Backup' bundle='clients' />"></toggle-control>
							</span>
						</li>
						</cv:comp>
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="Data_Restore" bundle="clients"/></span>
							<span class="pageDetailColumn">
								<toggle-control class="{{dataRecovery}}" status="dataRecovery" data-ng-click="manageActivity('restore')" title="Enable/disable <cv:msg key='Data_Restore' bundle='clients' />"></toggle-control>
							</span>
						</li>
					</ul>
				</cv-tile-component>
				<cv-tile-component data-ng-if="(serverType == 'MICROSOFT') && showHyperVTile" data-title='<cv:msg key="heading.hypervMonitoring" bundle="clients"/>'>
					<ul class="list-style-secondary" data-ng-class="{'disabled-interaction':disableHyperVMonitor}">
						<li class="group" data-ng-class="{'manage-activity':disableHyperVMonitor}"><span class="pageDetailColumn"><cv:msg key="metricsCollection" bundle="clients"/></span>
							<span class="pageDetailColumn">
								<toggle-control class="{{hypervMonitoring}}" status="hypervMonitoring" data-ng-click="manageMonitoring()" title="Enable/disable <cv:msg key='metricsCollection' bundle='clients' />"></toggle-control>
							</span>
						</li>
					</ul>
					<span class="tile-link-wrapper ng-scope">
							<a class="tile-content-link ng-scope" title='<cv:msg key="label.reportDataUnavailable" bundle="clients"/>' href="#/reportDetails?name=Hyper-V%20Monitoring&app=ADMIN_CONSOLE"><cv:msg key="viewHypervReport" bundle="clients"/></a>
					</span>
				</cv-tile-component>
				<cv-tile-component data-ng-if="showSettingsTab" data-ac-id="serverDetails-label_settings-profiles" data-title='<cv:msg key="label.settings" bundle="profiles"/>'>
					<ul class="list-style-secondary">
						<li class="group" data-ng-if="serverType=='VMW'">
							<span class="pageDetailColumn "><cv:msg key="label.vCloudHostName" bundle="servers" /></span>
							<span class="pageDetailColumn " ><span data-ng-if="vcloudHostName"> {{vcloudHostName}}</span>
							<span data-ng-if="!vcloudHostName"><cv:msg key="label.notSet" bundle="settingsJs" /></span>
							<a class="edit-link-float-right-action" data-ng-click="showVCloudDetailsDialog('showVcloud')" title="<cv:msg key="action.edit.ellipsis" bundle="collectionsJs" />"><cv:msg key="action.edit.ellipsis" bundle="collectionsJs" /></a>
							</span>
							<!-- <span class="pageDetailColumn " data-ng-if="!vcloudHostName"><cv:msg key="label.notSet" bundle="settingsJs" /></span>
							<span class="pageDetailColumn " ><a title='<cv:msg key="action.edit" bundle="collections" />' href="" data-ng-click="showVCloudDetailsDialog('showVcloud')">  <i class="glyphicon glyphicon-pencil "></i> </a></span>-->
						</li>
						<li class="group" data-ng-if="showFBROption">
							<span class="pageDetailColumn"><cv:msg key="label.fbrUnixMA" bundle="servers" /></span>
							<span class="pageDetailColumn" ><span data-ng-if="fbrMAUnix.mediaAgentName"> {{fbrMAUnix.mediaAgentName}}</span>
							<span data-ng-if="!fbrMAUnix.mediaAgentName"><cv:msg key="label.notSet" bundle="settingsJs" /></span>
							<a class="edit-link-float-right-action" data-ng-click="showVCloudDetailsDialog('showFREL')" title="<cv:msg key="action.edit.ellipsis" bundle="collectionsJs" />"><cv:msg key="action.edit.ellipsis" bundle="collectionsJs" /></a>
							</span>
							<!-- <span class="pageDetailColumn small-width" data-ng-if="!fbrMAUnix.mediaAgentName"><cv:msg key="label.notSet" bundle="settingsJs" /></span>
							<span class="pageDetailColumn small-width" ><a href="" data-ng-click="showVCloudDetailsDialog('showFREL')"><cv:msg key="action.edit" bundle="collections" /></a></span>-->
						</li>
						<li class="group" data-ng-if="showMountAccessNode">
							<span class="pageDetailColumn"><cv:msg key="label.mountProxy" bundle="servers" /></span>
							<span class="pageDetailColumn" ><span data-ng-if="mountProxy.length!=0"> {{mountProxy[0].mediaAgentName}}</span>
							<span data-ng-if="mountProxy.length==0"><cv:msg key="label.notSet" bundle="settingsJs" /></span>
							<a class="edit-link-float-right-action" data-ng-click="showVCloudDetailsDialog('showMountProxy')" title="<cv:msg key="action.edit.ellipsis" bundle="collectionsJs" />"><cv:msg key="action.edit.ellipsis" bundle="collectionsJs" /></a>
							</span>
						</li>
						<li class="group" data-ng-if="isAppAwareEnabled && isAppAwareEnabledVendor">
							<span class="pageDetailColumn "><cv:msg key="label.guestCredentials" bundle="servers" /></span>
							<span class="pageDetailColumn " ><span data-ng-if="guestUserName"> {{guestUserName}}</span>
							<span data-ng-if="!guestUserName"><cv:msg key="label.notSet" bundle="settingsJs" />
							<a class="edit-link-float-right-action" data-ng-click="editAppCredentials()" title="<cv:msg key="action.edit.ellipsis" bundle="collectionsJs" />"><cv:msg key="action.edit.ellipsis" bundle="collectionsJs" /></a>
							</span>
							</span>
							<!-- <span class="pageDetailColumn small-width" data-ng-if="guestUserName">{{guestUserName}}</span>
							<span class="pageDetailColumn small-width" data-ng-if="!guestUserName"><cv:msg key="label.notSet" bundle="settingsJs" /></span>
							<span class="pageDetailColumn small-width" ><a href="" data-ng-click="editAppCredentials()"><cv:msg key="action.edit" bundle="collections" /></a></span>-->
						</li>
						<li class="group" data-ng-if="isAppAwareEnabled && isAppAwareEnabledVendor && isVsaSSHEnabled">
							<span class="pageDetailColumn "><cv:msg key="label.applicationCredentials" bundle="servers" /></span>
							<span class="pageDetailColumn " ><span data-ng-if="appUserName"> {{appUserName}}</span>
							<span data-ng-if="!appUserName"><cv:msg key="label.notSet" bundle="settingsJs" /></span>
							<a style='margin-left:10px' title='<cv:msg key="action.edit.ellipsis" bundle="collectionsJs" />' href="" data-ng-click="editAppCredentials()"><i class="glyphicon glyphicon-pencil "></i> </a>
							</span>
							<!-- <span class="pageDetailColumn small-width" data-ng-if="appUserName">{{appUserName}}</span>
							<span class="pageDetailColumn small-width" data-ng-if="!appUserName"><cv:msg key="label.notSet" bundle="settingsJs" /></span>
							<span class="pageDetailColumn small-width" ><a href="" data-ng-click="editAppCredentials()"><cv:msg key="action.edit" bundle="collections" /></a></span>-->
						</li>
						<li class="group planMigration-block" data-ng-if="planRuleEnabled">
							<cv-region-select  data-cv-client-id="serverId" data-cv-client-region-info="clientRegion"></cv-region-select>
						</li>
						<li class="group planMigration-block padding-top-15" data-ng-if="clientTimeZoneObject">
							<cv-time-zone-select  data-cv-client-time-zone-object="clientTimeZoneObject"></cv-time-zone-select>
						</li>
					</ul>
					<!--  <div class="page-details-box-links">
						<a href="" data-ng-click="showVCloudDetailsDialog()"><cv:msg key="action.edit" bundle="collections" />
						</a>
					</div>-->
				</cv-tile-component>				
            	<span data-ng-if="showTenants">
					<cv-tenant-component  instance-id="instanceId">
		 			</cv-tenant-component>
				</span>
			</div>
			<div class="col-md-6">
				<div data-ng-if="showProxyMessage">
					<cv-tile-component data-ac-id="label-proxy-message" class="failedProxy" data-title='<cv:msg key="label.proxy" bundle="servers"/>'>
						<cv-help-text help-label="<cv:msg key="label.accessNodes.adminAccountAssociated" bundle="servers"></cv:msg>"
									  help-text="'<cv:msg key='info.accessNodes.removeAdminAccountAssociation' bundle='servers'/>'"
									  help-direction="bottom"></cv-help-text>
					</cv-tile-component>
				</div>
				<div data-ng-show="showProxyTile">
					<cv-proxy-component instance-id="instanceId" client-id="serverId" server-name="serverName" server-type="serverType" proxies-info="proxiesInfo"  virtual-server-info="virtualServerInfo" ctrl="ctrl"></cv-proxy-component>
				</div>
				<span>
					<cv-security-component entity-type='entityType' generic-entity = 'genericEntity' associations='formattedSecurityAssociations' associations-loaded='associationsLoaded' data-show-Owners='true' cv-capability="cvCapabilityConfig.security">
					</cv-security-component>
				</span>
				<!-- <div data-ng-if="showCIPolicy">
					<cv-analytics-plan-component datasource-type="'VSA'" client-id="serverId"></cv-analytics-plan-component>
				</div> -->
			<%-- <div data-ng-if="serverType === 'AMAZON' && instanceId && showAutoScale">
				<cv-auto-scale-proxy-component
                	server-id="serverId"
                	virtual-server-info="virtualServerInfo"
                	instance-id="instanceId"
                	server-name="serverName">
           		 </cv-auto-scale-proxy-component>
            </div> --%>
            	<span data-ng-if="showVcenterTile">
					<cv-vcenter-component  instance-id="instanceId" server-name="serverName" host-name="hostName" server-type="serverType" client-id="serverId">
		 			</cv-vcenter-component>
				</span>
			</div>
		</div>
	</div>
</div>